/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting.custom;

import com.radensolutions.reporting.custom.NXCLDataSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRValueParameter;
import org.netxms.api.client.NetXMSClientException;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.TableRow;
import org.netxms.client.constants.AggregationFunction;
import org.netxms.client.datacollection.DciSummaryTableColumn;

public class PerformanceDataSource
extends NXCLDataSource {
    private final Type type;
    private List<ReportRow> rows = new LinkedList<ReportRow>();
    private ReportRow currentRow;

    public PerformanceDataSource(Type type, JRDataset dataset, Map<String, ? extends JRValueParameter> parameters) {
        super(dataset, parameters);
        this.type = type;
        this.dataset = dataset;
        this.parameters = parameters;
    }

    @Override
    public void loadData(NXCSession session) throws IOException, NetXMSClientException {
        Date to;
        Date from;
        Long baseObjectId = (Long)this.getParameterValue("OBJECT_ID");
        Object fromObj = this.getParameterValue("PERIOD_START");
        Object toObj = this.getParameterValue("PERIOD_END");
        if (fromObj instanceof Long && toObj instanceof Long) {
            from = new Date((Long)fromObj * 1000L);
            to = new Date((Long)toObj * 1000L);
        } else {
            from = new Date(0L);
            to = new Date(0L);
        }
        ArrayList<DciSummaryTableColumn> columns = new ArrayList<DciSummaryTableColumn>();
        switch (this.type) {
            case CPU: {
                columns.add(new DciSummaryTableColumn("System.CPU.Usage", "System.CPU.Usage", 0));
                break;
            }
            case TRAFFIC: {
                columns.add(new DciSummaryTableColumn("System.CPU.Usage", "System.CPU.Usage", 0));
                break;
            }
            case DISK: {
                columns.add(new DciSummaryTableColumn("FileSystem.UsedPerc", "FileSystem\\.UsedPerc.*", DciSummaryTableColumn.REGEXP_MATCH));
            }
        }
        Table table = session.queryAdHocDciSummaryTable(baseObjectId.longValue(), columns, AggregationFunction.AVERAGE, from, to, true);
        for (TableRow row : table.getAllRows()) {
            this.rows.add(new ReportRow(row));
        }
        switch (this.type) {
            case CPU: {
                Collections.sort(this.rows, new Comparator<ReportRow>(){

                    @Override
                    public int compare(ReportRow o1, ReportRow o2) {
                        int valueResult = o2.value.compareTo(o1.value);
                        if (valueResult != 0) {
                            return valueResult;
                        }
                        return o1.nodeName.compareTo(o2.nodeName);
                    }
                });
                break;
            }
            case DISK: {
                Collections.sort(this.rows, new Comparator<ReportRow>(){

                    @Override
                    public int compare(ReportRow o1, ReportRow o2) {
                        int nameResult = o1.nodeName.compareTo(o2.nodeName);
                        if (nameResult == 0) {
                            return o2.value.compareTo(o1.value);
                        }
                        return nameResult;
                    }
                });
            }
        }
    }

    public boolean next() throws JRException {
        if (!this.rows.isEmpty()) {
            this.currentRow = this.rows.remove(0);
            return true;
        }
        return false;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        String name = jrField.getName();
        if (name.equalsIgnoreCase("node")) {
            return this.currentRow.nodeName;
        }
        if (name.equalsIgnoreCase("id")) {
            return this.currentRow.id;
        }
        if (name.equalsIgnoreCase("instance")) {
            return this.currentRow.instance;
        }
        if (name.equalsIgnoreCase("value")) {
            return this.currentRow.value;
        }
        return null;
    }

    private class ReportRow {
        long id;
        String nodeName;
        String instance;
        Double value;

        public ReportRow(long id, String nodeName, String instance, Double value) {
            this.id = id;
            this.nodeName = nodeName;
            this.instance = instance;
            this.value = value;
        }

        public ReportRow(TableRow row) {
            this.id = row.getObjectId();
            this.nodeName = row.get(0).getValue();
            this.instance = row.get(1).getValue();
            try {
                this.value = new Double(row.get(2).getValue());
            }
            catch (NumberFormatException e) {
                this.value = 0.0;
            }
        }
    }

    public static enum Type {
        CPU,
        TRAFFIC,
        DISK;

    }
}

