/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TagBits;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public abstract class TypeBinding
extends Binding
implements BaseTypes,
TagBits,
TypeConstants,
TypeIds {
    public int id = Integer.MAX_VALUE;
    public long tagBits = 0L;

    public static final TypeBinding wellKnownType(Scope scope, int id) {
        switch (id) {
            case 5: {
                return BooleanBinding;
            }
            case 3: {
                return ByteBinding;
            }
            case 2: {
                return CharBinding;
            }
            case 4: {
                return ShortBinding;
            }
            case 8: {
                return DoubleBinding;
            }
            case 9: {
                return FloatBinding;
            }
            case 10: {
                return IntBinding;
            }
            case 7: {
                return LongBinding;
            }
            case 1: {
                return scope.getJavaLangObject();
            }
            case 11: {
                return scope.getJavaLangString();
            }
        }
        return null;
    }

    public int kind() {
        return 4;
    }

    public boolean canBeInstantiated() {
        return !this.isBaseType();
    }

    public TypeBinding capture(Scope scope, int position) {
        return this;
    }

    public void collectSubstitutes(Scope scope, TypeBinding otherType, Map substitutes, int constraint) {
    }

    public abstract char[] constantPoolName();

    public String debugName() {
        return new String(this.readableName());
    }

    public int dimensions() {
        return 0;
    }

    public ReferenceBinding enclosingType() {
        return null;
    }

    public TypeBinding erasure() {
        return this;
    }

    public TypeBinding genericCast(TypeBinding otherType) {
        if (this == otherType) {
            return null;
        }
        TypeBinding otherErasure = otherType.erasure();
        if (otherErasure == this.erasure()) {
            return null;
        }
        return otherErasure;
    }

    public char[] genericTypeSignature() {
        return this.signature();
    }

    public abstract PackageBinding getPackage();

    public final boolean isAnonymousType() {
        return (this.tagBits & 0x20L) != 0L;
    }

    public boolean isAnnotationType() {
        return false;
    }

    public final boolean isArrayType() {
        return (this.tagBits & 1L) != 0L;
    }

    public final boolean isBaseType() {
        return (this.tagBits & 2L) != 0L;
    }

    public boolean isBoundParameterizedType() {
        return (this.tagBits & 0x800000L) != 0L;
    }

    public boolean isCapture() {
        return false;
    }

    public boolean isClass() {
        return false;
    }

    public abstract boolean isCompatibleWith(TypeBinding var1);

    public boolean isEnum() {
        return false;
    }

    public boolean isEquivalentTo(TypeBinding otherType) {
        if (this == otherType) {
            return true;
        }
        if (otherType == null) {
            return false;
        }
        if (otherType.isWildcard()) {
            return ((WildcardBinding)otherType).boundCheck(this);
        }
        return false;
    }

    public boolean isGenericType() {
        return false;
    }

    public final boolean isHierarchyInconsistent() {
        return (this.tagBits & 0x8000L) != 0L;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isIntersectingWith(TypeBinding otherType) {
        return this == otherType;
    }

    public final boolean isLocalType() {
        return (this.tagBits & 0x10L) != 0L;
    }

    public final boolean isMemberType() {
        return (this.tagBits & 8L) != 0L;
    }

    public final boolean isNestedType() {
        return (this.tagBits & 4L) != 0L;
    }

    public final boolean isNumericType() {
        switch (this.id) {
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public boolean isParameterizedType() {
        return false;
    }

    public boolean isProvablyDistinctFrom(TypeBinding otherType, int depth) {
        if (this == otherType) {
            return false;
        }
        if (depth > 1) {
            return true;
        }
        switch (otherType.kind()) {
            case 516: 
            case 4100: {
                return false;
            }
        }
        switch (this.kind()) {
            case 516: 
            case 4100: {
                return false;
            }
            case 260: {
                ParameterizedTypeBinding parameterizedType = (ParameterizedTypeBinding)this;
                if (parameterizedType.type.isProvablyDistinctFrom(otherType.erasure(), depth)) {
                    return true;
                }
                switch (otherType.kind()) {
                    case 1028: 
                    case 2052: {
                        return false;
                    }
                    case 260: {
                        TypeBinding[] arguments = parameterizedType.arguments;
                        if (arguments == null) {
                            return false;
                        }
                        ParameterizedTypeBinding otherParameterizedType = (ParameterizedTypeBinding)otherType;
                        TypeBinding[] otherArguments = otherParameterizedType.arguments;
                        if (otherArguments == null) {
                            return false;
                        }
                        int i = 0;
                        int length = arguments.length;
                        while (i < length) {
                            if (arguments[i].isProvablyDistinctFrom(otherArguments[i], depth + 1)) {
                                return true;
                            }
                            ++i;
                        }
                        return false;
                    }
                }
                break;
            }
            case 1028: {
                return this.erasure().isProvablyDistinctFrom(otherType.erasure(), 0);
            }
            case 2052: {
                return this != otherType.erasure();
            }
        }
        return this != otherType;
    }

    public boolean isRawType() {
        return false;
    }

    public boolean isReifiable() {
        TypeBinding leafType = this.leafComponentType();
        if (!(leafType instanceof ReferenceBinding)) {
            return true;
        }
        ReferenceBinding current = (ReferenceBinding)leafType;
        do {
            switch (current.kind()) {
                case 516: 
                case 2052: 
                case 4100: {
                    return false;
                }
                case 260: {
                    if (!this.isBoundParameterizedType()) break;
                    return false;
                }
                case 1028: {
                    return true;
                }
            }
            if (!current.isStatic()) continue;
            return true;
        } while ((current = current.enclosingType()) != null);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public boolean isTypeArgumentContainedBy(TypeBinding otherType) {
        if (this == otherType) {
            return true;
        }
        switch (otherType.kind()) {
            case 516: {
                TypeBinding lowerBound = this;
                TypeBinding upperBound = this;
                switch (this.kind()) {
                    case 516: {
                        WildcardBinding wildcard = (WildcardBinding)this;
                        switch (wildcard.boundKind) {
                            case 1: {
                                upperBound = wildcard.bound;
                                lowerBound = null;
                                break;
                            }
                            case 2: {
                                upperBound = wildcard;
                                lowerBound = wildcard.bound;
                                break;
                            }
                            case 0: {
                                upperBound = wildcard;
                                lowerBound = null;
                                break;
                            }
                        }
                        break;
                    }
                    case 4100: {
                        if (!this.isCapture()) break;
                        CaptureBinding capture = (CaptureBinding)this;
                        if (capture.lowerBound == null) break;
                        lowerBound = capture.lowerBound;
                        break;
                    }
                }
                WildcardBinding otherWildcard = (WildcardBinding)otherType;
                if (otherWildcard.otherBounds != null) {
                    return false;
                }
                switch (otherWildcard.boundKind) {
                    case 1: {
                        if (otherWildcard.bound == this) {
                            return true;
                        }
                        if (upperBound == null) return false;
                        if (!upperBound.isCompatibleWith(otherWildcard.bound)) return false;
                        return true;
                    }
                    case 2: {
                        if (otherWildcard.bound == this) {
                            return true;
                        }
                        if (lowerBound == null) return false;
                        if (!otherWildcard.bound.isCompatibleWith(lowerBound)) return false;
                        return true;
                    }
                }
                return true;
            }
            case 260: {
                int otherLength;
                ReferenceBinding enclosing;
                if (!this.isParameterizedType()) {
                    return false;
                }
                ParameterizedTypeBinding paramType = (ParameterizedTypeBinding)this;
                ParameterizedTypeBinding otherParamType = (ParameterizedTypeBinding)otherType;
                if (paramType.type != otherParamType.type) {
                    return false;
                }
                if (!paramType.isStatic() && (enclosing = this.enclosingType()) != null) {
                    ReferenceBinding otherEnclosing = otherParamType.enclosingType();
                    if (otherEnclosing == null) {
                        return false;
                    }
                    if ((otherEnclosing.tagBits & 0x40000000L) == 0L ? enclosing != otherEnclosing : !enclosing.isEquivalentTo(otherParamType.enclosingType())) {
                        return false;
                    }
                }
                int length = paramType.arguments == null ? 0 : paramType.arguments.length;
                TypeBinding[] otherArguments = otherParamType.arguments;
                int n = otherLength = otherArguments == null ? 0 : otherArguments.length;
                if (otherLength != length) {
                    return false;
                }
                int i = 0;
                while (i < length) {
                    TypeBinding argument = paramType.arguments[i];
                    TypeBinding otherArgument = otherArguments[i];
                    if (argument != otherArgument) {
                        int kind = argument.kind();
                        if (otherArgument.kind() != kind) {
                            return false;
                        }
                        block17 : switch (kind) {
                            case 260: {
                                if (!argument.isTypeArgumentContainedBy(otherArgument)) return false;
                                break;
                            }
                            case 516: {
                                WildcardBinding wildcard = (WildcardBinding)argument;
                                WildcardBinding otherWildcard = (WildcardBinding)otherArgument;
                                switch (wildcard.boundKind) {
                                    case 1: {
                                        if (otherWildcard.boundKind != 0) return false;
                                        if (wildcard.bound != wildcard.typeVariable().upperBound()) return false;
                                        break block17;
                                    }
                                    case 2: {
                                        break;
                                    }
                                    case 0: {
                                        if (otherWildcard.boundKind != 1) return false;
                                        if (otherWildcard.bound != otherWildcard.typeVariable().upperBound()) return false;
                                        break block17;
                                    }
                                }
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public boolean isTypeArgumentIntersecting(TypeBinding otherArgument) {
        if (this == otherArgument) {
            return true;
        }
        switch (this.kind()) {
            case 4100: {
                return true;
            }
            case 516: {
                switch (otherArgument.kind()) {
                    case 4100: {
                        return true;
                    }
                    case 516: {
                        TypeBinding lowerBound1 = null;
                        TypeBinding upperBound1 = null;
                        WildcardBinding wildcard = (WildcardBinding)this;
                        switch (wildcard.boundKind) {
                            case 1: {
                                upperBound1 = wildcard.bound;
                                break;
                            }
                            case 2: {
                                lowerBound1 = wildcard.bound;
                            }
                        }
                        TypeBinding lowerBound2 = null;
                        TypeBinding upperBound2 = null;
                        WildcardBinding otherWildcard = (WildcardBinding)otherArgument;
                        switch (otherWildcard.boundKind) {
                            case 1: {
                                upperBound2 = otherWildcard.bound;
                                break;
                            }
                            case 2: {
                                lowerBound2 = otherWildcard.bound;
                            }
                        }
                        if (lowerBound1 != null) {
                            if (lowerBound2 != null) {
                                return true;
                            }
                            if (upperBound2 != null) {
                                return lowerBound1.isCompatibleWith(upperBound2);
                            }
                            return true;
                        }
                        if (upperBound1 != null) {
                            if (lowerBound2 != null) {
                                return lowerBound2.isCompatibleWith(upperBound1);
                            }
                            if (upperBound2 != null) {
                                if (upperBound1.isInterface()) {
                                    if (upperBound2.isInterface()) {
                                        return true;
                                    }
                                    if (upperBound2.isArrayType() || upperBound2 instanceof ReferenceBinding && ((ReferenceBinding)upperBound2).isFinal()) {
                                        return upperBound2.isCompatibleWith(upperBound1);
                                    }
                                    return true;
                                }
                                if (upperBound2.isInterface() && (upperBound1.isArrayType() || upperBound1 instanceof ReferenceBinding && ((ReferenceBinding)upperBound1).isFinal())) {
                                    return upperBound1.isCompatibleWith(upperBound2);
                                }
                                return true;
                            }
                            return true;
                        }
                        return true;
                    }
                }
                WildcardBinding wildcard = (WildcardBinding)this;
                switch (wildcard.boundKind) {
                    case 1: {
                        return otherArgument.isCompatibleWith(wildcard.bound);
                    }
                    case 2: {
                        return wildcard.bound.isCompatibleWith(otherArgument);
                    }
                }
                return true;
            }
        }
        switch (otherArgument.kind()) {
            case 4100: {
                return true;
            }
            case 516: {
                WildcardBinding otherWildcard = (WildcardBinding)otherArgument;
                switch (otherWildcard.boundKind) {
                    case 1: {
                        return this.isCompatibleWith(otherWildcard.bound);
                    }
                    case 2: {
                        return otherWildcard.bound.isCompatibleWith(this);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean isTypeVariable() {
        return false;
    }

    public boolean isUnboundWildcard() {
        return false;
    }

    public boolean isUncheckedException(boolean includeSupertype) {
        return false;
    }

    public boolean isWildcard() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean needsUncheckedConversion(TypeBinding targetType) {
        if (this == targetType) {
            return false;
        }
        if (!((targetType = targetType.leafComponentType()) instanceof ReferenceBinding)) {
            return false;
        }
        currentType = this.leafComponentType();
        if (!(currentType instanceof ReferenceBinding)) {
            return false;
        }
        compatible = ((ReferenceBinding)currentType).findSuperTypeWithSameErasure(targetType);
        if (compatible != null) ** GOTO lbl14
        return false;
lbl-1000:
        // 1 sources

        {
            if (targetType.isBoundParameterizedType() || targetType.isGenericType()) {
                return true;
            }
            if (compatible.isStatic() || (compatible = compatible.enclosingType()) == null || (targetType = targetType.enclosingType()) == null) break;
lbl14:
            // 2 sources

            ** while (compatible.isRawType())
        }
lbl15:
        // 2 sources

        return false;
    }

    public TypeBinding leafComponentType() {
        return this;
    }

    public char[] qualifiedPackageName() {
        PackageBinding packageBinding = this.getPackage();
        return packageBinding == null || packageBinding.compoundName == CharOperation.NO_CHAR_CHAR ? CharOperation.NO_CHAR : packageBinding.readableName();
    }

    public abstract char[] qualifiedSourceName();

    public char[] signature() {
        return this.constantPoolName();
    }

    public abstract char[] sourceName();

    public void swapUnresolved(UnresolvedReferenceBinding unresolvedType, ReferenceBinding resolvedType, LookupEnvironment environment) {
    }

    public TypeVariableBinding[] typeVariables() {
        return NoTypeVariables;
    }
}

