/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barcode4j;

import net.sf.jasperreports.components.barcode4j.BarcodeComponent;
import net.sf.jasperreports.components.barcode4j.EAN128Component;
import net.sf.jasperreports.components.barcode4j.UniformBarcodeVisitor;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public class CompiledBarcodeFactory
extends UniformBarcodeVisitor {
    private final JRBaseObjectFactory baseFactory;
    private BarcodeComponent compiledComponent;

    public CompiledBarcodeFactory(JRBaseObjectFactory baseFactory) {
        this.baseFactory = baseFactory;
    }

    public BarcodeComponent toCompiledComponent(BarcodeComponent barcode) {
        barcode.receive(this);
        return this.compiledComponent;
    }

    protected void createCompiledBarcode(BarcodeComponent barcode) {
        this.compiledComponent = barcode.cloneObject();
        JRExpression compiledCodeExpression = this.baseFactory.getExpression(barcode.getCodeExpression());
        this.compiledComponent.setCodeExpression(compiledCodeExpression);
        JRExpression compiledPatternExpression = this.baseFactory.getExpression(barcode.getPatternExpression());
        this.compiledComponent.setPatternExpression(compiledPatternExpression);
        if (barcode instanceof EAN128Component) {
            JRExpression compiledTemplateExpression = this.baseFactory.getExpression(((EAN128Component)barcode).getTemplateExpression());
            ((EAN128Component)this.compiledComponent).setTemplateExpression(compiledTemplateExpression);
        }
    }

    @Override
    protected void visitBarcode(BarcodeComponent barcode) {
        this.createCompiledBarcode(barcode);
    }
}

