/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.nxsl.views;

import java.io.IOException;
import java.io.InputStream;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.ActionHandler;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.netxms.api.client.scripts.Script;
import org.netxms.api.client.scripts.ScriptLibraryManager;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.Messages;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class ScriptEditorView
extends ViewPart
implements ISaveablePart {
    public static final String ID = "org.netxms.ui.eclipse.nxsl.views.ScriptEditorView";
    private ScriptLibraryManager scriptLibraryManager;
    private ScriptEditor editor;
    private long scriptId;
    private String scriptName;
    private RefreshAction actionRefresh;
    private Action actionSave;
    private FindReplaceAction actionFindReplace;
    private boolean modified = false;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.scriptLibraryManager = (ScriptLibraryManager)ConsoleSharedData.getSession();
        this.scriptId = Long.parseLong(site.getSecondaryId());
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.editor = new ScriptEditor(parent, 0, 768);
        this.editor.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ScriptEditorView.this.modified) {
                    ScriptEditorView.this.modified = true;
                    ScriptEditorView.this.firePropertyChange(257);
                    ScriptEditorView.this.actionSave.setEnabled(true);
                    ScriptEditorView.this.actionFindReplace.update();
                }
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.reloadScript();
    }

    public void setFocus() {
        this.editor.setFocus();
    }

    private ResourceBundle getResourceBundle() throws IOException {
        InputStream in = null;
        String resource = "resource.properties";
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        in = loader != null ? loader.getResourceAsStream(resource) : ClassLoader.getSystemResourceAsStream(resource);
        return new PropertyResourceBundle(in);
    }

    private void createActions() {
        try {
            this.actionFindReplace = new FindReplaceAction(this.getResourceBundle(), "actions.find_and_replace.", (IWorkbenchPart)this);
            IHandlerService hs = (IHandlerService)this.getSite().getService(IHandlerService.class);
            hs.activateHandler("org.eclipse.ui.edit.findReplace", (IHandler)new ActionHandler((IAction)this.actionFindReplace));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.actionRefresh = new RefreshAction(){

            public void run() {
                ScriptEditorView.this.reloadScript();
            }
        };
        Messages.get();
        this.actionSave = new Action(Messages.ScriptEditorView_Save, SharedIcons.SAVE){

            public void run() {
                ScriptEditorView.this.saveScript();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionFindReplace);
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void reloadScript() {
        Messages.get();
        new ConsoleJob(String.format(Messages.ScriptEditorView_LoadJobTitle, this.scriptId), (IWorkbenchPart)this, "org.netxms.ui.eclipse.nxsl", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ScriptEditorView_LoadJobError, ScriptEditorView.this.scriptId);
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Script script = ScriptEditorView.this.scriptLibraryManager.getScript(ScriptEditorView.this.scriptId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ScriptEditorView.this.scriptName = script.getName();
                        ScriptEditorView scriptEditorView = ScriptEditorView.this;
                        Messages.get();
                        scriptEditorView.setPartName(String.format(Messages.ScriptEditorView_PartName, ScriptEditorView.this.scriptName));
                        ScriptEditorView.this.editor.setText(script.getSource());
                        ScriptEditorView.this.actionSave.setEnabled(false);
                        ScriptEditorView.this.actionFindReplace.update();
                    }
                });
            }
        }.start();
    }

    private void saveScript() {
        final String source = this.editor.getText();
        this.editor.getTextWidget().setEditable(false);
        Messages.get();
        new ConsoleJob(Messages.ScriptEditorView_SaveJobTitle, (IWorkbenchPart)this, "org.netxms.ui.eclipse.nxsl", null){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ScriptEditorView_SaveJobError;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ScriptEditorView.this.doScriptSave(source, monitor);
            }
        }.start();
    }

    private void doScriptSave(String source, IProgressMonitor monitor) throws Exception {
        this.scriptLibraryManager.modifyScript(this.scriptId, this.scriptName, source);
        this.editor.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ScriptEditorView.this.editor.isDisposed()) {
                    return;
                }
                ScriptEditorView.this.editor.getTextWidget().setEditable(true);
                ScriptEditorView.this.actionSave.setEnabled(false);
                ScriptEditorView.this.modified = false;
                ScriptEditorView.this.firePropertyChange(257);
            }
        });
    }

    public Object getAdapter(Class adapter) {
        Object object = super.getAdapter(adapter);
        if (object != null) {
            return object;
        }
        if (adapter.equals(IFindReplaceTarget.class)) {
            return this.editor.getFindReplaceTarget();
        }
        return null;
    }

    public void doSave(IProgressMonitor monitor) {
        String source = this.editor.getText();
        this.editor.getTextWidget().setEditable(false);
        try {
            this.doScriptSave(source, monitor);
        }
        catch (Exception e) {
            Shell shell = this.getViewSite().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ScriptEditorView_Error, (String)String.format(Messages.ScriptEditorView_SaveErrorMessage, e.getMessage()));
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }
}

