/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets;

import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.widgets.internal.TableContentProvider;
import org.netxms.ui.eclipse.datacollection.widgets.internal.TableItemComparator;
import org.netxms.ui.eclipse.datacollection.widgets.internal.TableLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class SummaryTableWidget
extends Composite {
    private int tableId;
    private long baseObjectId;
    private IViewPart viewPart;
    private SortableTableViewer viewer;
    private Action actionExportToCsv;
    private Runnable timer;
    private int autoRefreshInterval = 0;

    public SummaryTableWidget(Composite parent, int style, IViewPart viewPart, int tableId, long baseObjectId) {
        super(parent, style);
        this.viewPart = viewPart;
        this.tableId = tableId;
        this.baseObjectId = baseObjectId;
        this.setLayout((Layout)new FillLayout());
        this.viewer = new SortableTableViewer((Composite)this, 65538);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.actionExportToCsv = new ExportToCsvAction(viewPart, (ColumnViewer)this.viewer, true);
        this.createPopupMenu();
        this.timer = new Runnable(){

            @Override
            public void run() {
                if (SummaryTableWidget.this.isDisposed()) {
                    return;
                }
                SummaryTableWidget.this.refresh();
                if (SummaryTableWidget.this.autoRefreshInterval > 0) {
                    SummaryTableWidget.this.getDisplay().timerExec(SummaryTableWidget.this.autoRefreshInterval, SummaryTableWidget.this.timer);
                }
            }
        };
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                SummaryTableWidget.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportToCsv);
    }

    public void refresh() {
        this.viewer.setInput(null);
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.SummaryTable_JobName, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Table table = session.queryDciSummaryTable(SummaryTableWidget.this.tableId, SummaryTableWidget.this.baseObjectId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        SummaryTableWidget.this.update(table);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SummaryTable_JobError;
            }
        }.start();
    }

    public void update(Table table) {
        if (!this.viewer.isInitialized()) {
            String[] names = table.getColumnDisplayNames();
            int[] widths = new int[names.length];
            Arrays.fill(widths, 100);
            this.viewer.createColumns(names, widths, 0, 128);
            WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)(String.valueOf(this.viewPart.getViewSite().getId()) + ".SummaryTable." + Integer.toString(this.tableId)));
            this.viewer.getTable().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    WidgetHelper.saveTableViewerSettings((SortableTableViewer)SummaryTableWidget.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)(String.valueOf(SummaryTableWidget.this.viewPart.getViewSite().getId()) + ".SummaryTable." + Integer.toString(SummaryTableWidget.this.tableId)));
                }
            });
            this.viewer.setComparator((ViewerComparator)new TableItemComparator(table.getColumnDataTypes()));
        }
        this.viewer.setInput((Object)table);
    }

    public SortableTableViewer getViewer() {
        return this.viewer;
    }

    public void setAutoRefresh(int interval) {
        this.getDisplay().timerExec(-1, this.timer);
        this.autoRefreshInterval = interval * 1000;
        if (this.autoRefreshInterval > 0) {
            this.getDisplay().timerExec(this.autoRefreshInterval, this.timer);
        }
    }
}

