/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.MobileDevice;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.perfview.widgets.TableValue;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class TableLastValuesView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.perfview.views.TableLastValues";
    private long objectId;
    private long dciId;
    private TableValue viewer;
    private Action actionRefresh;
    private Action actionExportAllToCsv;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        String[] parts = site.getSecondaryId().split("&");
        if (parts.length != 2) {
            throw new PartInitException("Internal error");
        }
        this.objectId = Long.parseLong(parts[0]);
        AbstractObject object = session.findObjectById(this.objectId);
        if (object == null || !(object instanceof AbstractNode) && !(object instanceof Cluster) && !(object instanceof MobileDevice)) {
            Messages.get();
            throw new PartInitException(Messages.TableLastValuesView_InvalidObjectID);
        }
        this.dciId = Long.parseLong(parts[1]);
        this.setPartName(String.valueOf(object.getObjectName()) + ": [" + Long.toString(this.dciId) + "]");
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TableValue(parent, 0, (IViewPart)this);
        this.createActions();
        this.contributeToActionBars();
        this.viewer.setObject(this.objectId, this.dciId);
        this.refreshTable();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                TableLastValuesView.this.refreshTable();
            }
        };
        this.actionExportAllToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer.getViewer(), false);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IAction)this.actionRefresh);
    }

    public void setFocus() {
        this.viewer.setFocus();
    }

    private void refreshTable() {
        this.viewer.refresh(new Runnable(){

            @Override
            public void run() {
                TableLastValuesView.this.setPartName(String.valueOf(TableLastValuesView.this.viewer.getObjectName()) + ": " + TableLastValuesView.this.viewer.getTitle());
            }
        });
    }
}

