/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.TableCell;

public class TableRow {
    private List<TableCell> cells;
    private long objectId;

    public TableRow(int rowCount) {
        this.objectId = 0L;
        this.cells = new ArrayList<TableCell>(rowCount);
        int i = 0;
        while (i < rowCount) {
            this.cells.add(new TableCell(""));
            ++i;
        }
    }

    public TableRow(TableRow src) {
        this.objectId = src.objectId;
        this.cells = new ArrayList<TableCell>(src.cells.size());
        int i = 0;
        while (i < src.cells.size()) {
            this.cells.add(new TableCell(src.get(i)));
            ++i;
        }
    }

    public TableCell get(int column) throws ArrayIndexOutOfBoundsException {
        return this.cells.get(column);
    }

    public int size() {
        return this.cells.size();
    }

    public long fillMessage(NXCPMessage msg, long baseId, boolean extendedFormat) {
        long varId = baseId;
        if (extendedFormat) {
            msg.setFieldInt32(varId++, (int)this.objectId);
            varId += 9L;
        }
        for (TableCell c : this.cells) {
            msg.setField(varId++, c.getValue());
            if (!extendedFormat) continue;
            msg.setFieldInt16(varId++, c.getStatus());
            varId += 8L;
        }
        return varId;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }

    public String toString() {
        return "TableRow{cells=" + this.cells + ", objectId=" + this.objectId + '}';
    }
}

