/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.netxms.client.IpAddressListElement;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.VPNConnector;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.objectmanager.dialogs.AddAddressListElementDialog;
import org.netxms.ui.eclipse.objectmanager.propertypages.helpers.AddressListElementComparator;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class VPNSubnets
extends PropertyPage {
    private VPNConnector connector;
    private ObjectSelector objectSelector;
    private TableViewer localNetworksList;
    private TableViewer remoteNetworksList;
    private boolean modified = false;
    private List<IpAddressListElement> localNetworksElements;
    private List<IpAddressListElement> remoteNetworksElements;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.connector = (VPNConnector)this.getElement().getAdapter(VPNConnector.class);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        dialogArea.setLayoutData((Object)gd);
        this.objectSelector = new ObjectSelector(dialogArea, 0, true);
        Messages.get();
        this.objectSelector.setLabel(Messages.VPNSubnets_PeerGateway);
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.connector.getPeerGatewayId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.objectSelector.setLayoutData((Object)gd);
        Composite clientArea = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        gd = new GridData();
        clientArea.setLayout((Layout)layout);
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        clientArea.setLayoutData((Object)gd);
        this.localNetworksElements = new ArrayList<IpAddressListElement>(this.connector.getLocalSubnets());
        this.remoteNetworksElements = new ArrayList<IpAddressListElement>(this.connector.getRemoteSubnets());
        this.networksLisr(clientArea, this.localNetworksList, this.localNetworksElements);
        this.networksLisr(clientArea, this.remoteNetworksList, this.remoteNetworksElements);
        return dialogArea;
    }

    private void networksLisr(Composite dialogArea, TableViewer viewList, final List<IpAddressListElement> data) {
        Group clientArea = new Group(dialogArea, 0);
        Messages.get();
        clientArea.setText(Messages.VPNSubnets_RemoteNetworks);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gd = new GridData();
        clientArea.setLayout((Layout)layout);
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        clientArea.setLayoutData((Object)gd);
        viewList = new TableViewer((Composite)clientArea, 67586);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 2;
        gd.heightHint = 100;
        viewList.getTable().setLayoutData((Object)gd);
        viewList.getTable().setSortDirection(128);
        viewList.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewList.setComparator((ViewerComparator)new AddressListElementComparator());
        viewList.setInput((Object)data.toArray());
        final TableViewer list = viewList;
        ImageHyperlink linkAdd = new ImageHyperlink((Composite)clientArea, 0);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                VPNSubnets.this.addTargetAddressListElement(list, data);
            }
        });
        ImageHyperlink linkRemove = new ImageHyperlink((Composite)clientArea, 0);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                VPNSubnets.this.removeTargetAddressListElements(list, data);
            }
        });
    }

    private void addTargetAddressListElement(TableViewer elementList, List<IpAddressListElement> elements) {
        IpAddressListElement element;
        AddAddressListElementDialog dlg = new AddAddressListElementDialog(this.getShell());
        if (dlg.open() == 0 && !elements.contains(element = new IpAddressListElement(0, dlg.getAddress1(), dlg.getAddress2()))) {
            elements.add(element);
            elementList.setInput((Object)elements.toArray());
            this.modified = true;
        }
    }

    private void removeTargetAddressListElements(TableViewer elementList, List<IpAddressListElement> elements) {
        IStructuredSelection selection = (IStructuredSelection)elementList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                elements.remove(o);
            }
            elementList.setInput((Object)elements.toArray());
            this.modified = true;
        }
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getDefaultsButton().setVisible(false);
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    private void applyChanges(final boolean isApply) {
        if (!this.modified) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        final NXCObjectModificationData md = new NXCObjectModificationData(this.connector.getObjectId());
        md.setVpnNetworks(this.localNetworksElements, this.remoteNetworksElements);
        md.setPeerGatewayId(this.objectSelector.getObjectId());
        Messages.get();
        new ConsoleJob(Messages.VPNSubnets_JobName, null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            VPNSubnets.this.setValid(true);
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.VPNSubnets_JobError;
            }
        }.schedule();
    }
}

