/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.netxms.ui.eclipse.charts.widgets.GaugeWidget;
import org.netxms.ui.eclipse.charts.widgets.internal.DataComparisonElement;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class CurrentValueWidget
extends GaugeWidget {
    private Font[] valueFonts = null;

    public CurrentValueWidget(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void createFonts() {
        this.valueFonts = new Font[32];
        int i = 0;
        while (i < this.valueFonts.length) {
            this.valueFonts[i] = new Font((Device)this.getDisplay(), this.fontName, i * 6 + 12, 1);
            ++i;
        }
    }

    @Override
    protected void disposeFonts() {
        if (this.valueFonts != null) {
            int i = 0;
            while (i < this.valueFonts.length) {
                this.valueFonts[i].dispose();
                ++i;
            }
        }
    }

    @Override
    protected void renderElement(GC gc, DataComparisonElement dci, int x, int y, int w, int h) {
        Rectangle rect = new Rectangle(x + 5, y + 5, w - 10, h - 10);
        if (this.elementBordersVisible) {
            gc.drawRectangle(rect);
        }
        if (this.legendVisible) {
            rect.height -= gc.textExtent((String)"MMM").y + 8;
        }
        String value = this.getValueAsDisplayString(dci);
        Font font = WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.valueFonts, (String)value, (int)rect.width, (int)rect.height);
        gc.setFont(font);
        if (dci.getValue() <= this.leftRedZone || dci.getValue() >= this.rightRedZone) {
            gc.setForeground(this.colors.create(RED_ZONE_COLOR));
        } else if (dci.getValue() <= this.leftYellowZone || dci.getValue() >= this.rightYellowZone) {
            gc.setForeground(this.colors.create(YELLOW_ZONE_COLOR));
        } else {
            gc.setForeground(this.colors.create(GREEN_ZONE_COLOR));
        }
        Point ext = gc.textExtent(value, 1);
        gc.drawText(value, rect.x + rect.width / 2 - ext.x / 2, rect.y + rect.height / 2 - ext.y / 2, 0x40000000);
        if (this.legendVisible) {
            gc.setFont(null);
            ext = gc.textExtent(dci.getName(), 1);
            gc.setForeground(SharedColors.getColor((String)"DialChart.Legend", (Display)this.getDisplay()));
            gc.drawText(dci.getName(), rect.x + (rect.width - ext.x) / 2, rect.y + rect.height + 4, true);
        }
    }

    @Override
    public Image takeSnapshot() {
        Rectangle rect = this.getClientArea();
        Image image = new Image((Device)this.getDisplay(), rect.width, rect.height);
        GC gc = new GC((Drawable)image);
        this.print(gc);
        gc.dispose();
        return image;
    }
}

