/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.views;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.api.client.ProgressListener;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCSession;
import org.netxms.client.ServerFile;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.filemanager.Activator;
import org.netxms.ui.eclipse.filemanager.Messages;
import org.netxms.ui.eclipse.filemanager.dialogs.StartClientToServerFileUploadDialog;
import org.netxms.ui.eclipse.filemanager.views.helpers.ServerFileComparator;
import org.netxms.ui.eclipse.filemanager.views.helpers.ServerFileFilter;
import org.netxms.ui.eclipse.filemanager.views.helpers.ServerFileLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ViewServerFile
extends ViewPart
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.usermanager.view.server_files";
    private static final String TABLE_CONFIG_PREFIX = "ServerFilesEditor";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_SIZE = 2;
    public static final int COLUMN_MODIFYED = 3;
    private boolean filterEnabled = false;
    private Composite content;
    private ServerFile[] files;
    private ServerFileFilter filter;
    private FilterText filterText;
    private SortableTableViewer viewer;
    private NXCSession session;
    private Action actionRefresh;
    private Action actionNew;
    private Action actionDelete;
    private Action actionShowFilter;

    public void createPartControl(Composite parent) {
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.content = new Composite(parent, 0);
        this.content.setLayout((Layout)new FormLayout());
        this.filterText = new FilterText(this.content, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ViewServerFile.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                ViewServerFile.this.enableFilter(false);
            }
        });
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.ViewServerFile_FileName;
        Messages.get();
        stringArray[1] = Messages.ViewServerFile_FileType;
        Messages.get();
        stringArray[2] = Messages.ViewServerFile_FileSize;
        Messages.get();
        stringArray[3] = Messages.ViewServerFile_ModificationDate;
        String[] columnNames = stringArray;
        int[] columnWidths = new int[]{300, 150, 300, 300};
        this.viewer = new SortableTableViewer(this.content, columnNames, columnWidths, 0, 128, -1);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ServerFileLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ServerFileComparator());
        this.filter = new ServerFileFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    ViewServerFile.this.actionDelete.setEnabled(selection.size() > 0);
                }
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)ViewServerFile.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)ViewServerFile.TABLE_CONFIG_PREFIX);
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getTable().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.session.addListener((SessionListener)this);
        this.filterText.setCloseAction(this.actionShowFilter);
        if (this.filterEnabled) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.refreshFileList();
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                ViewServerFile.this.refreshFileList();
            }
        };
        Messages.get();
        this.actionNew = new Action(Messages.ViewServerFile_UploadFileOnServerAction){

            public void run() {
                ViewServerFile.this.createFile();
            }
        };
        this.actionNew.setImageDescriptor(SharedIcons.ADD_OBJECT);
        Messages.get();
        this.actionDelete = new Action(Messages.ViewServerFile_DeleteFileOnServerAction){

            public void run() {
                ViewServerFile.this.deleteFile();
            }
        };
        this.actionDelete.setImageDescriptor(SharedIcons.DELETE_OBJECT);
        Messages.get();
        this.actionShowFilter = new Action(Messages.ViewServerFile_ShowFilterAction, 2){

            public void run() {
                ViewServerFile.this.enableFilter(!ViewServerFile.this.filterEnabled);
                ViewServerFile.this.actionShowFilter.setChecked(ViewServerFile.this.filterEnabled);
            }
        };
        this.actionShowFilter.setChecked(this.filterEnabled);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.datacollection.commands.show_dci_filter");
        ActionHandler showFilterHandler = new ActionHandler((IAction)this.actionShowFilter);
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)showFilterHandler);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionDelete);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionDelete);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ViewServerFile.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionShowFilter);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionNew);
        mgr.add((IAction)this.actionDelete);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IContributionItem)new GroupMarker("additions"));
        mgr.add((IContributionItem)new Separator());
    }

    private void refreshFileList() {
        Messages.get();
        new ConsoleJob(Messages.SelectServerFileDialog_JobTitle, null, "org.netxms.ui.eclipse.filemanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ViewServerFile.this.files = ViewServerFile.this.session.listServerFiles();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ViewServerFile.this.viewer.setInput((Object)ViewServerFile.this.files);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SelectServerFileDialog_JobError;
            }
        }.start();
    }

    private void createFile() {
        final StartClientToServerFileUploadDialog dlg = new StartClientToServerFileUploadDialog(this.getSite().getShell());
        if (dlg.open() == 0) {
            final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
            Messages.get();
            new ConsoleJob(Messages.UploadFileToServer_JobTitle, null, "org.netxms.ui.eclipse.filemanager", null){

                protected void runInternal(final IProgressMonitor monitor) throws Exception {
                    session.uploadFileToServer(dlg.getLocalFile(), dlg.getRemoteFileName(), new ProgressListener(){
                        private long prevWorkDone = 0L;

                        public void setTotalWorkAmount(long workTotal) {
                            Messages.get();
                            monitor.beginTask(String.valueOf(Messages.UploadFileToServer_TaskNamePrefix) + dlg.getLocalFile().getAbsolutePath(), (int)workTotal);
                        }

                        public void markProgress(long workDone) {
                            monitor.worked((int)(workDone - this.prevWorkDone));
                            this.prevWorkDone = workDone;
                        }
                    });
                    monitor.done();
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.UploadFileToServer_JobError;
                }
            }.start();
        }
    }

    private void deleteFile() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        if (!MessageDialogHelper.openConfirm((Shell)shell, (String)Messages.ViewServerFile_DeleteConfirmation, (String)Messages.ViewServerFile_DeletAck)) {
            return;
        }
        final Object[] objects = selection.toArray();
        Messages.get();
        new ConsoleJob(Messages.ViewServerFile_DeletFileFromServerJob, (IWorkbenchPart)this, "org.netxms.ui.eclipse.filemanager", "org.netxms.ui.eclipse.filemanager"){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ViewServerFile_ErrorDeleteFileJob;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int i = 0;
                while (i < objects.length) {
                    ViewServerFile.this.session.deleteServerFile(((ServerFile)objects[i]).getName());
                    ++i;
                }
            }
        }.start();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void notificationHandler(SessionNotification n) {
        if (n.getCode() == 1025) {
            this.refreshFileList();
        }
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        super.dispose();
    }

    private void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        this.filterText.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.content.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }
}

