/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.UUID;
import org.netxms.base.InetAddressEx;
import org.netxms.base.NXCPDataInputStream;

public class NXCPMessageField {
    public static final int TYPE_INTEGER = 0;
    public static final int TYPE_STRING = 1;
    public static final int TYPE_INT64 = 2;
    public static final int TYPE_INT16 = 3;
    public static final int TYPE_BINARY = 4;
    public static final int TYPE_FLOAT = 5;
    public static final int TYPE_INETADDR = 6;
    private static final int SIGNED = 1;
    private static final byte[] PADDING = new byte[16];
    private long id;
    private int type;
    private Long integerValue;
    private Double realValue;
    private String stringValue;
    private byte[] binaryValue;
    private InetAddressEx inetAddressValue;

    public String toString() {
        return "NXCPMessageField{id=" + this.id + ", type=" + this.type + ", integerValue=" + this.integerValue + ", realValue=" + this.realValue + ", stringValue='" + this.stringValue + '\'' + ", binaryValue=" + Arrays.toString(this.binaryValue) + ", inetAddressValue=" + this.inetAddressValue + '}';
    }

    private void setStringValue(String value) {
        this.stringValue = value != null ? value : "";
        try {
            this.integerValue = Long.parseLong(this.stringValue);
        }
        catch (NumberFormatException numberFormatException) {
            this.integerValue = 0L;
        }
        try {
            this.realValue = Double.parseDouble(this.stringValue);
        }
        catch (NumberFormatException numberFormatException) {
            this.realValue = 0.0;
        }
    }

    public NXCPMessageField(long varId, int varType, Long value) {
        this.id = varId;
        this.type = varType;
        this.integerValue = value;
        this.stringValue = this.integerValue.toString();
        this.realValue = this.integerValue.doubleValue();
    }

    public NXCPMessageField(long varId, String value) {
        this.id = varId;
        this.type = 1;
        this.setStringValue(value);
    }

    public NXCPMessageField(long varId, Double value) {
        this.id = varId;
        this.type = 5;
        this.realValue = value;
        this.stringValue = value.toString();
        this.integerValue = this.realValue.longValue();
    }

    public NXCPMessageField(long varId, byte[] value) {
        this.id = varId;
        this.type = 4;
        this.binaryValue = value;
        this.stringValue = "";
        this.integerValue = 0L;
        this.realValue = 0.0;
    }

    public NXCPMessageField(long varId, long[] value) {
        this.id = varId;
        this.type = 4;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(value.length * 4);
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            int i = 0;
            while (i < value.length) {
                out.writeInt((int)value[i]);
                ++i;
            }
        }
        catch (IOException iOException) {}
        this.binaryValue = byteStream.toByteArray();
        this.stringValue = "";
        this.integerValue = 0L;
        this.realValue = 0.0;
    }

    public NXCPMessageField(long varId, Long[] value) {
        this.id = varId;
        this.type = 4;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(value.length * 4);
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            int i = 0;
            while (i < value.length) {
                out.writeInt(value[i].intValue());
                ++i;
            }
        }
        catch (IOException iOException) {}
        this.binaryValue = byteStream.toByteArray();
        this.stringValue = "";
        this.integerValue = 0L;
        this.realValue = 0.0;
    }

    public NXCPMessageField(long varId, InetAddress value) {
        this.id = varId;
        this.type = 6;
        this.inetAddressValue = new InetAddressEx(value, value instanceof Inet4Address ? 32 : 128);
        this.stringValue = this.inetAddressValue.toString();
        this.integerValue = 0L;
        this.realValue = 0.0;
    }

    public NXCPMessageField(long varId, UUID value) {
        this.id = varId;
        this.type = 4;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(16);
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            out.writeLong(value.getMostSignificantBits());
            out.writeLong(value.getLeastSignificantBits());
        }
        catch (IOException iOException) {}
        this.binaryValue = byteStream.toByteArray();
        this.stringValue = "";
        this.integerValue = 0L;
        this.realValue = 0.0;
    }

    public NXCPMessageField(byte[] nxcpDataField) throws IOException {
        NXCPDataInputStream in = new NXCPDataInputStream(nxcpDataField);
        this.id = in.readUnsignedInt();
        this.type = in.readUnsignedByte();
        int flags = in.readUnsignedByte();
        if (this.type == 3) {
            this.integerValue = (flags & 1) != 0 ? in.readShort() : in.readUnsignedShort();
            this.realValue = this.integerValue.doubleValue();
            this.stringValue = this.integerValue.toString();
        } else {
            in.skipBytes(2);
            switch (this.type) {
                case 0: {
                    this.integerValue = (flags & 1) != 0 ? (long)in.readInt() : in.readUnsignedInt();
                    this.realValue = this.integerValue.doubleValue();
                    this.stringValue = this.integerValue.toString();
                    break;
                }
                case 2: {
                    this.integerValue = in.readLong();
                    this.realValue = this.integerValue.doubleValue();
                    this.stringValue = this.integerValue.toString();
                    break;
                }
                case 5: {
                    this.realValue = in.readDouble();
                    this.integerValue = this.realValue.longValue();
                    this.stringValue = this.realValue.toString();
                    break;
                }
                case 1: {
                    int len = in.readInt() / 2;
                    StringBuilder sb = new StringBuilder(len);
                    while (len > 0) {
                        sb.append(in.readChar());
                        --len;
                    }
                    this.setStringValue(sb.toString());
                    break;
                }
                case 4: {
                    this.binaryValue = new byte[in.readInt()];
                    in.readFully(this.binaryValue);
                    break;
                }
                case 6: {
                    this.binaryValue = new byte[16];
                    in.readFully(this.binaryValue);
                    int family = in.readUnsignedByte();
                    int bits = in.readUnsignedByte();
                    in.skipBytes(6);
                    this.inetAddressValue = new InetAddressEx(InetAddress.getByAddress(family == 0 ? Arrays.copyOf(this.binaryValue, 4) : this.binaryValue), bits);
                    this.stringValue = this.inetAddressValue.toString();
                }
            }
        }
        in.close();
    }

    public Long getAsInteger() {
        return this.integerValue;
    }

    public Double getAsReal() {
        return this.realValue;
    }

    public String getAsString() {
        return this.stringValue;
    }

    public byte[] getAsBinary() {
        return this.binaryValue;
    }

    public InetAddress getAsInetAddress() {
        if (this.type == 6) {
            return this.inetAddressValue.address;
        }
        if (this.type == 4) {
            try {
                return InetAddress.getByAddress(this.binaryValue);
            }
            catch (UnknownHostException unknownHostException) {
                return null;
            }
        }
        byte[] addr = new byte[4];
        long intVal = this.integerValue;
        addr[0] = (byte)((intVal & 0xFFFFFFFFFF000000L) >> 24);
        addr[1] = (byte)((intVal & 0xFF0000L) >> 16);
        addr[2] = (byte)((intVal & 0xFF00L) >> 8);
        addr[3] = (byte)(intVal & 0xFFL);
        try {
            return InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public InetAddressEx getAsInetAddressEx() {
        if (this.type == 6) {
            return this.inetAddressValue;
        }
        if (this.type == 4) {
            try {
                return new InetAddressEx(InetAddress.getByAddress(this.binaryValue), this.binaryValue.length * 8);
            }
            catch (UnknownHostException unknownHostException) {
                return null;
            }
        }
        byte[] addr = new byte[4];
        long intVal = this.integerValue;
        addr[0] = (byte)((intVal & 0xFFFFFFFFFF000000L) >> 24);
        addr[1] = (byte)((intVal & 0xFF0000L) >> 16);
        addr[2] = (byte)((intVal & 0xFF00L) >> 8);
        addr[3] = (byte)(intVal & 0xFFL);
        try {
            return new InetAddressEx(InetAddress.getByAddress(addr), 32);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public UUID getAsUUID() {
        long loBits;
        long hiBits;
        if (this.type != 4 || this.binaryValue == null || this.binaryValue.length != 16) {
            return null;
        }
        NXCPDataInputStream in = new NXCPDataInputStream(this.binaryValue);
        try {
            hiBits = in.readLong();
            loBits = in.readLong();
        }
        catch (IOException iOException) {
            hiBits = 0L;
            loBits = 0L;
        }
        in.close();
        return new UUID(hiBits, loBits);
    }

    public long[] getAsUInt32Array() {
        if (this.type != 4 || this.binaryValue == null) {
            return null;
        }
        int count = this.binaryValue.length / 4;
        long[] value = new long[count];
        NXCPDataInputStream in = new NXCPDataInputStream(this.binaryValue);
        try {
            int i = 0;
            while (i < count) {
                value[i] = in.readUnsignedInt();
                ++i;
            }
        }
        catch (IOException iOException) {}
        in.close();
        return value;
    }

    public Long[] getAsUInt32ArrayEx() {
        if (this.type != 4 || this.binaryValue == null) {
            return null;
        }
        int count = this.binaryValue.length / 4;
        Long[] value = new Long[count];
        NXCPDataInputStream in = new NXCPDataInputStream(this.binaryValue);
        try {
            int i = 0;
            while (i < count) {
                value[i] = in.readUnsignedInt();
                ++i;
            }
        }
        catch (IOException iOException) {}
        in.close();
        return value;
    }

    public long getVariableId() {
        return this.id;
    }

    public void setVariableId(long variableId) {
        this.id = variableId;
    }

    public int getVariableType() {
        return this.type;
    }

    private int calculateBinarySize() {
        int size;
        switch (this.type) {
            case 0: {
                size = 12;
                break;
            }
            case 2: 
            case 5: {
                size = 16;
                break;
            }
            case 3: {
                size = 8;
                break;
            }
            case 1: {
                size = this.stringValue.length() * 2 + 12;
                break;
            }
            case 4: {
                size = this.binaryValue.length + 12;
                break;
            }
            case 6: {
                size = 32;
                break;
            }
            default: {
                size = 8;
            }
        }
        return size;
    }

    public byte[] createNXCPDataField() throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(this.calculateBinarySize());
        DataOutputStream out = new DataOutputStream(byteStream);
        out.writeInt(Long.valueOf(this.id).intValue());
        out.writeByte(Long.valueOf(this.type).byteValue());
        out.writeByte(0);
        if (this.type == 3) {
            out.writeShort(this.integerValue.shortValue());
        } else {
            out.writeShort(0);
            switch (this.type) {
                case 0: {
                    out.writeInt(this.integerValue.intValue());
                    break;
                }
                case 2: {
                    out.writeLong(this.integerValue);
                    break;
                }
                case 5: {
                    out.writeDouble(this.realValue);
                    break;
                }
                case 1: {
                    out.writeInt(this.stringValue.length() * 2);
                    out.writeChars(this.stringValue);
                    break;
                }
                case 4: {
                    out.writeInt(this.binaryValue.length);
                    out.write(this.binaryValue);
                    break;
                }
                case 6: {
                    if (this.inetAddressValue.address instanceof Inet4Address) {
                        out.write(this.inetAddressValue.address.getAddress());
                        out.write(PADDING, 0, 12);
                        out.writeByte(0);
                    } else {
                        out.write(this.inetAddressValue.address.getAddress());
                        out.writeByte(1);
                    }
                    out.writeByte(this.inetAddressValue.mask);
                    out.write(PADDING, 0, 6);
                }
            }
        }
        int rem = byteStream.size() % 8;
        if (rem != 0) {
            out.write(PADDING, 0, 8 - rem);
        }
        return byteStream.toByteArray();
    }
}

