/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.imagelibrary.dialogs;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.api.client.images.LibraryImage;
import org.netxms.ui.eclipse.imagelibrary.Messages;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetFactory;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class ImagePropertiesDialog
extends Dialog {
    private String name;
    private String category;
    private String fileName;
    private Text fileNameInputField;
    private Text nameInputField;
    private Combo categoryCombo;
    private Set<String> categories;
    private Shell shell;
    private List<LibraryImage> imageLibrary;
    private boolean editDialog = false;

    public ImagePropertiesDialog(Shell parentShell, Set<String> knownCategories, List<LibraryImage> imageLibrary, boolean editDialog) {
        super(parentShell);
        this.shell = parentShell;
        this.categories = knownCategories;
        this.imageLibrary = imageLibrary;
        this.editDialog = editDialog;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        WidgetFactory widgetFactory = new WidgetFactory(){

            public Control createControl(Composite parent, int style) {
                Composite composite = new Composite(parent, 0);
                GridLayout compositeLayout = new GridLayout();
                compositeLayout.numColumns = 2;
                composite.setLayout((Layout)compositeLayout);
                ImagePropertiesDialog.this.fileNameInputField = new Text(composite, 2060);
                GridData gd = new GridData();
                gd.widthHint = 300;
                gd.grabExcessHorizontalSpace = true;
                gd.grabExcessVerticalSpace = true;
                gd.horizontalAlignment = 4;
                gd.verticalAlignment = 4;
                ImagePropertiesDialog.this.fileNameInputField.setLayoutData((Object)gd);
                Button button = new Button(composite, 0);
                button.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        FileDialog dialog = new FileDialog(ImagePropertiesDialog.this.shell, 4096);
                        Messages.get();
                        dialog.setText(Messages.ImagePropertiesDialog_Title);
                        String[] stringArray = new String[2];
                        Messages.get();
                        stringArray[0] = Messages.ImagePropertiesDialog_ImageFiles;
                        Messages.get();
                        stringArray[1] = Messages.ImagePropertiesDialog_AllFiles;
                        dialog.setFilterNames(stringArray);
                        dialog.setFilterExtensions(new String[]{"*.jpg;*.jpeg;*.png;*.bmp", "*.*"});
                        String selectedFile = dialog.open();
                        if (selectedFile != null) {
                            ImagePropertiesDialog.this.fileName = selectedFile;
                            ImagePropertiesDialog.this.fileNameInputField.setText(selectedFile);
                            if (ImagePropertiesDialog.this.nameInputField.getText().length() == 0) {
                                String imageName = new File(ImagePropertiesDialog.this.fileName).getName();
                                int lastIndexOf = imageName.lastIndexOf(46);
                                if (lastIndexOf != -1) {
                                    imageName = imageName.substring(0, lastIndexOf);
                                }
                                ImagePropertiesDialog.this.nameInputField.setText(imageName);
                            }
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
                button.setText("...");
                return composite;
            }
        };
        Messages.get();
        WidgetHelper.createLabeledControl((Composite)dialogArea, (int)2048, (WidgetFactory)widgetFactory, (String)Messages.ImagePropertiesDialog_ImageFile, (Object)"WidgetHelper::default_layout_data");
        Messages.get();
        this.nameInputField = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2052, (int)-1, (String)Messages.ImagePropertiesDialog_ImageName, (String)(this.name == null ? "" : this.name), (Object)"WidgetHelper::default_layout_data");
        this.nameInputField.getShell().setMinimumSize(300, 0);
        Messages.get();
        this.categoryCombo = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2052, (String)Messages.ImagePropertiesDialog_Category, (Object)"WidgetHelper::default_layout_data");
        this.categoryCombo.getShell().setMinimumSize(300, 0);
        int counter = 0;
        for (String name : this.categories) {
            this.categoryCombo.add(name);
            if (name.equals(this.category)) {
                this.categoryCombo.select(counter);
            }
            ++counter;
        }
        return dialogArea;
    }

    protected void okPressed() {
        this.category = this.categoryCombo.getText();
        this.name = this.nameInputField.getText();
        if (!this.editDialog) {
            int i = 0;
            while (i < this.imageLibrary.size()) {
                LibraryImage image = this.imageLibrary.get(i);
                if (this.name.compareTo(image.getName()) == 0 && this.category.compareTo(image.getCategory()) == 0) {
                    Shell shell = this.getShell();
                    Messages.get();
                    Messages.get();
                    MessageDialogHelper.openError((Shell)shell, (String)Messages.ImagePropertiesDialog_Error, (String)String.format(Messages.ImagePropertiesDialog_ErrorText, this.name, this.category));
                    return;
                }
                ++i;
            }
        }
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.ImagePropertiesDialog_Upload);
    }

    public void setDefaultCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFileName() {
        return this.fileName;
    }
}

