/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.internal.StatusMapConfig;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class StatusMap
extends PropertyPage {
    private StatusMapConfig config;
    private ObjectSelector objectSelector;
    private LabeledText title;
    private Button[] checkSeverity;
    private Combo displayMode;

    protected Control createContents(Composite parent) {
        this.config = (StatusMapConfig)this.getElement().getAdapter(StatusMapConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        this.objectSelector = new ObjectSelector(dialogArea, 0, true);
        Messages.get();
        this.objectSelector.setLabel(Messages.AlarmViewer_RootObject);
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.config.getObjectId());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.objectSelector.setLayoutData((Object)gd);
        this.title = new LabeledText(dialogArea, 0);
        Messages.get();
        this.title.setLabel(Messages.AlarmViewer_Title);
        this.title.setText(this.config.getTitle());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.title.setLayoutData((Object)gd);
        Group severityGroup = new Group(dialogArea, 0);
        Messages.get();
        severityGroup.setText(Messages.StatusMap_SeverityFilter);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        severityGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 5;
        layout.makeColumnsEqualWidth = true;
        severityGroup.setLayout((Layout)layout);
        this.checkSeverity = new Button[5];
        int severity = 4;
        while (severity >= 0) {
            this.checkSeverity[severity] = new Button((Composite)severityGroup, 32);
            this.checkSeverity[severity].setText(StatusDisplayInfo.getStatusText((int)severity));
            this.checkSeverity[severity].setSelection((this.config.getSeverityFilter() & 1 << severity) != 0);
            --severity;
        }
        Messages.get();
        this.displayMode = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)Messages.StatusMap_DisplayMode, (Object)"WidgetHelper::default_layout_data");
        Messages.get();
        this.displayMode.add(Messages.StatusMap_NoGroup);
        Messages.get();
        this.displayMode.add(Messages.StatusMap_Group);
        this.displayMode.select(this.config.isGroupObjects() ? 1 : 0);
        return dialogArea;
    }

    public boolean performOk() {
        this.config.setObjectId(this.objectSelector.getObjectId());
        this.config.setTitle(this.title.getText());
        int severityFilter = 0;
        int i = 0;
        while (i < this.checkSeverity.length) {
            if (this.checkSeverity[i].getSelection()) {
                severityFilter |= 1 << i;
            }
            ++i;
        }
        this.config.setSeverityFilter(severityFilter);
        this.config.setGroupObjects(this.displayMode.getSelectionIndex() == 1);
        return true;
    }
}

