/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.TableValueConfig;
import org.netxms.ui.eclipse.perfview.widgets.TableValue;

public class TableValueElement
extends ElementWidget {
    private TableValueConfig config;
    private TableValue viewer;

    public TableValueElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = TableValueConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new TableValueConfig();
        }
        if (this.config.getTitle().trim().isEmpty()) {
            this.setLayout((Layout)new FillLayout());
            this.viewer = new TableValue((Composite)this, 0, viewPart);
        } else {
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.setLayout((Layout)layout);
            Label title = new Label((Composite)this, 0x1000000);
            title.setText(this.config.getTitle().trim());
            title.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            title.setFont(JFaceResources.getBannerFont());
            this.viewer = new TableValue((Composite)this, 0, viewPart);
            this.viewer.setLayoutData((Object)new GridData(4, 4, true, true));
        }
        this.viewer.setObject(this.config.getObjectId(), this.config.getDciId());
        this.viewer.refresh(null);
        final Display display = this.getDisplay();
        Runnable refreshTimer = new Runnable(){

            @Override
            public void run() {
                if (TableValueElement.this.isDisposed()) {
                    return;
                }
                TableValueElement.this.viewer.refresh(null);
                display.timerExec(TableValueElement.this.config.getRefreshRate() * 1000, (Runnable)this);
            }
        };
        display.timerExec(this.config.getRefreshRate() * 1000, refreshTimer);
    }
}

