/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.netxms.api.client.users.AbstractAccessListElement;
import org.netxms.api.client.users.AbstractUserObject;
import org.netxms.api.client.users.User;
import org.netxms.api.client.users.UserGroup;
import org.netxms.api.client.users.UserManager;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.usermanager.Activator;

public class UserAdapterFactory
implements IAdapterFactory {
    private static final Class[] supportedClasses = new Class[]{IWorkbenchAdapter.class};

    public Class[] getAdapterList() {
        return supportedClasses;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == IWorkbenchAdapter.class) {
            if (adaptableObject instanceof User) {
                return new IWorkbenchAdapter(){

                    public Object[] getChildren(Object o) {
                        return null;
                    }

                    public ImageDescriptor getImageDescriptor(Object object) {
                        return Activator.getImageDescriptor("icons/user.png");
                    }

                    public String getLabel(Object o) {
                        return ((User)o).getName();
                    }

                    public Object getParent(Object o) {
                        return null;
                    }
                };
            }
            if (adaptableObject instanceof UserGroup) {
                return new IWorkbenchAdapter(){

                    public Object[] getChildren(Object o) {
                        long[] members = ((UserGroup)o).getMembers();
                        Object[] childrens = new User[members.length];
                        int i = 0;
                        while (i < members.length) {
                            childrens[i] = ((UserManager)ConsoleSharedData.getSession()).findUserDBObjectById(members[i]);
                            ++i;
                        }
                        return childrens;
                    }

                    public ImageDescriptor getImageDescriptor(Object object) {
                        return Activator.getImageDescriptor("icons/group.png");
                    }

                    public String getLabel(Object o) {
                        return ((UserGroup)o).getName();
                    }

                    public Object getParent(Object o) {
                        return null;
                    }
                };
            }
            if (adaptableObject instanceof AbstractAccessListElement) {
                return new IWorkbenchAdapter(){

                    public Object[] getChildren(Object o) {
                        return null;
                    }

                    public ImageDescriptor getImageDescriptor(Object object) {
                        long userId = ((AbstractAccessListElement)object).getUserId();
                        return Activator.getImageDescriptor(userId < 0x80000000L ? "icons/user.png" : "icons/group.png");
                    }

                    public String getLabel(Object object) {
                        long userId = ((AbstractAccessListElement)object).getUserId();
                        UserManager umgr = (UserManager)ConsoleSharedData.getSession();
                        AbstractUserObject dbo = umgr.findUserDBObjectById(userId);
                        return dbo != null ? dbo.getName() : "{" + Long.toString(userId) + "}";
                    }

                    public Object getParent(Object o) {
                        return null;
                    }
                };
            }
        }
        return null;
    }
}

