/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.datacollection.DciSummaryTableDescriptor;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.SummaryTablesCache;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class SelectSummaryTableDialog
extends Dialog {
    private TableViewer viewer;
    private DciSummaryTableDescriptor table;

    public SelectSummaryTableDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        Messages.get();
        newShell.setText(Messages.SelectSummaryTableDialog_Title);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        Messages.get();
        label.setText(Messages.SelectSummaryTableDialog_Label);
        this.viewer = new TableViewer(dialogArea, 67584);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((DciSummaryTableDescriptor)element).getTitle();
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                DciSummaryTableDescriptor s1 = (DciSummaryTableDescriptor)e1;
                DciSummaryTableDescriptor s2 = (DciSummaryTableDescriptor)e2;
                return s1.getTitle().compareToIgnoreCase(s2.getTitle());
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectSummaryTableDialog.this.okPressed();
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 300;
        gd.widthHint = 400;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setInput((Object)SummaryTablesCache.getTables());
        return dialogArea;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 0) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.SelectSummaryTableDialog_Warning, (String)Messages.SelectSummaryTableDialog_EmptySelectionWarning);
            return;
        }
        this.table = (DciSummaryTableDescriptor)selection.getFirstElement();
        super.okPressed();
    }

    public DciSummaryTableDescriptor getTable() {
        return this.table;
    }
}

