/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.widgets;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.netxms.api.client.reporting.ReportParameter;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.eventmanager.dialogs.EventSelectionDialog;
import org.netxms.ui.eclipse.reporter.Messages;
import org.netxms.ui.eclipse.reporter.widgets.FieldEditor;

public class EventFieldEditor
extends FieldEditor {
    private static final String EMPTY_SELECTION_TEXT;
    private CLabel text;
    private long eventCode = 0L;

    static {
        Messages.get();
        EMPTY_SELECTION_TEXT = Messages.EventFieldEditor_Any;
    }

    public EventFieldEditor(ReportParameter parameter, FormToolkit toolkit, Composite parent) {
        super(parameter, toolkit, parent);
    }

    @Override
    protected Control createContent(Composite parent) {
        Composite content = this.toolkit.createComposite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        content.setLayout((Layout)layout);
        this.text = new CLabel(content, 0);
        this.toolkit.adapt((Composite)this.text);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        this.text.setLayoutData((Object)gd);
        this.text.setText(EMPTY_SELECTION_TEXT);
        ImageHyperlink selectionLink = this.toolkit.createImageHyperlink(content, 0);
        selectionLink.setImage(SharedIcons.IMG_FIND);
        Messages.get();
        selectionLink.setToolTipText(Messages.EventFieldEditor_SelectEvent);
        selectionLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                EventFieldEditor.this.selectEvent();
            }
        });
        ImageHyperlink clearLink = this.toolkit.createImageHyperlink(content, 0);
        clearLink.setImage(SharedIcons.IMG_CLEAR);
        Messages.get();
        clearLink.setToolTipText(Messages.EventFieldEditor_ClearSelection);
        clearLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                EventFieldEditor.this.eventCode = 0L;
                EventFieldEditor.this.text.setText(EMPTY_SELECTION_TEXT);
                EventFieldEditor.this.text.setImage(null);
            }
        });
        return content;
    }

    private void selectEvent() {
        EventSelectionDialog dlg = new EventSelectionDialog(this.getShell());
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            EventTemplate[] events = dlg.getSelectedEvents();
            if (events.length > 0) {
                this.eventCode = events[0].getCode();
                this.text.setText(events[0].getName());
                this.text.setImage(StatusDisplayInfo.getStatusImage((Severity)events[0].getSeverity()));
            } else {
                this.eventCode = 0L;
                this.text.setText(EMPTY_SELECTION_TEXT);
                this.text.setImage(null);
            }
        }
    }

    @Override
    public String getValue() {
        return Long.toString(this.eventCode);
    }
}

