/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.widgets;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.api.client.reporting.ReportParameter;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.reporter.Messages;
import org.netxms.ui.eclipse.reporter.widgets.FieldEditor;

public class ObjectFieldEditor
extends FieldEditor {
    private static final String EMPTY_SELECTION_TEXT;
    private CLabel text;
    private long objectId = 0L;
    private WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();

    static {
        Messages.get();
        EMPTY_SELECTION_TEXT = Messages.ObjectFieldEditor_Any;
    }

    public ObjectFieldEditor(ReportParameter parameter, FormToolkit toolkit, Composite parent) {
        super(parameter, toolkit, parent);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ObjectFieldEditor.this.labelProvider.dispose();
            }
        });
    }

    @Override
    protected Control createContent(Composite parent) {
        Composite content = this.toolkit.createComposite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        content.setLayout((Layout)layout);
        this.text = new CLabel(content, 0);
        this.toolkit.adapt((Composite)this.text);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        this.text.setLayoutData((Object)gd);
        this.text.setText(EMPTY_SELECTION_TEXT);
        ImageHyperlink selectionLink = this.toolkit.createImageHyperlink(content, 0);
        selectionLink.setImage(SharedIcons.IMG_FIND);
        Messages.get();
        selectionLink.setToolTipText(Messages.ObjectFieldEditor_SelectObject);
        selectionLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ObjectFieldEditor.this.selectObject();
            }
        });
        ImageHyperlink clearLink = this.toolkit.createImageHyperlink(content, 0);
        clearLink.setImage(SharedIcons.IMG_CLEAR);
        Messages.get();
        clearLink.setToolTipText(Messages.ObjectFieldEditor_ClearSelection);
        clearLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ObjectFieldEditor.this.objectId = 0L;
                ObjectFieldEditor.this.text.setText(EMPTY_SELECTION_TEXT);
                ObjectFieldEditor.this.text.setImage(null);
            }
        });
        return content;
    }

    private void selectObject() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell(), null, null);
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            AbstractObject[] objects = dlg.getSelectedObjects(AbstractObject.class);
            if (objects.length > 0) {
                this.objectId = objects[0].getObjectId();
                this.text.setText(objects[0].getObjectName());
                this.text.setImage(this.labelProvider.getImage((Object)objects[0]));
            } else {
                this.objectId = 0L;
                this.text.setText(EMPTY_SELECTION_TEXT);
                this.text.setImage(null);
            }
        }
    }

    @Override
    public String getValue() {
        return Long.toString(this.objectId);
    }
}

