/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.netxms.api.client.servermanager.ServerManager;
import org.netxms.api.client.servermanager.ServerVariable;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.serverconfig.Activator;
import org.netxms.ui.eclipse.serverconfig.Messages;
import org.netxms.ui.eclipse.serverconfig.dialogs.VariableEditDialog;
import org.netxms.ui.eclipse.serverconfig.views.helpers.ServerVariableComparator;
import org.netxms.ui.eclipse.serverconfig.views.helpers.ServerVariablesLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ServerConfigurationEditor
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.view.server_config";
    public static final String JOB_FAMILY = "ServerConfigJob";
    private SortableTableViewer viewer;
    private ServerManager session;
    private Map<String, ServerVariable> varList;
    private Action actionAdd;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;
    private Action actionRefresh;
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_VALUE = 1;
    public static final int COLUMN_NEED_RESTART = 2;

    public void createPartControl(Composite parent) {
        String[] stringArray = new String[3];
        Messages.get();
        stringArray[0] = Messages.ServerConfigurationEditor_ColName;
        Messages.get();
        stringArray[1] = Messages.ServerConfigurationEditor_ColValue;
        Messages.get();
        stringArray[2] = Messages.ServerConfigurationEditor_ColRestart;
        String[] names = stringArray;
        int[] widths = new int[]{200, 150, 80};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, -1);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ServerVariablesLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ServerVariableComparator());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ServerConfigurationEditor.this.editVariable();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ServerConfigurationEditor.this.viewer.getSelection();
                ServerConfigurationEditor.this.actionEdit.setEnabled(selection.size() == 1);
                ServerConfigurationEditor.this.actionDelete.setEnabled(selection.size() > 0);
            }
        });
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)settings, (String)"ServerConfigurationEditor");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)ServerConfigurationEditor.this.viewer, (IDialogSettings)settings, (String)"ServerConfigurationEditor");
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "org.netxms.nxmc.serverconfig.viewer");
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.session = (ServerManager)ConsoleSharedData.getSession();
        this.refresh();
    }

    public void refresh() {
        Messages.get();
        new ConsoleJob(Messages.ServerConfigurationEditor_LoadJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", JOB_FAMILY){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ServerConfigurationEditor_LoadJobError;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ServerConfigurationEditor.this.varList = ServerConfigurationEditor.this.session.getServerVariables();
                this.runInUIThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Map map = ServerConfigurationEditor.this.varList;
                        synchronized (map) {
                            ServerConfigurationEditor.this.viewer.setInput((Object)ServerConfigurationEditor.this.varList.values().toArray());
                        }
                    }
                });
            }
        }.start();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionAdd);
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionAdd);
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                ServerConfigurationEditor.this.refresh();
            }
        };
        Messages.get();
        this.actionAdd = new Action(Messages.ServerConfigurationEditor_ActionCreate, SharedIcons.ADD_OBJECT){

            public void run() {
                ServerConfigurationEditor.this.addVariable();
            }
        };
        Messages.get();
        this.actionEdit = new Action(Messages.ServerConfigurationEditor_ActionEdit, SharedIcons.EDIT){

            public void run() {
                ServerConfigurationEditor.this.editVariable();
            }
        };
        this.actionEdit.setEnabled(false);
        Messages.get();
        this.actionDelete = new Action(Messages.ServerConfigurationEditor_ActionDelete, SharedIcons.DELETE_OBJECT){

            public void run() {
                ServerConfigurationEditor.this.deleteVariables();
            }
        };
        this.actionDelete.setEnabled(false);
        this.actionExportToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, false);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ServerConfigurationEditor.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionAdd);
        mgr.add((IAction)this.actionEdit);
        mgr.add((IAction)this.actionDelete);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionExportToCsv);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void addVariable() {
        final VariableEditDialog dlg = new VariableEditDialog(this.getSite().getShell(), null, null);
        if (dlg.open() == 0) {
            Messages.get();
            new ConsoleJob(Messages.ServerConfigurationEditor_CreateJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", JOB_FAMILY){

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.ServerConfigurationEditor_CreateJobError;
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    ServerConfigurationEditor.this.session.setServerVariable(dlg.getVarName(), dlg.getVarValue());
                    ServerConfigurationEditor.this.refresh();
                }
            }.start();
        }
    }

    private void editVariable() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection == null || selection.size() != 1) {
            return;
        }
        ServerVariable var = (ServerVariable)selection.getFirstElement();
        final VariableEditDialog dlg = new VariableEditDialog(this.getSite().getShell(), var.getName(), var.getValue());
        if (dlg.open() == 0) {
            Messages.get();
            new ConsoleJob(Messages.ServerConfigurationEditor_ModifyJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", JOB_FAMILY){

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.ServerConfigurationEditor_ModifyJobError;
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    ServerConfigurationEditor.this.session.setServerVariable(dlg.getVarName(), dlg.getVarValue());
                    ServerConfigurationEditor.this.refresh();
                }
            }.start();
        }
    }

    private void deleteVariables() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection == null || selection.size() == 0) {
            return;
        }
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        if (!MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.ServerConfigurationEditor_DeleteConfirmation, (String)Messages.ServerConfigurationEditor_DeleteConfirmationText)) {
            return;
        }
        final ArrayList<String> names = new ArrayList<String>(selection.size());
        for (Object o : selection.toList()) {
            if (!(o instanceof ServerVariable)) continue;
            names.add(((ServerVariable)o).getName());
        }
        Messages.get();
        new ConsoleJob(Messages.ServerConfigurationEditor_DeleteJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", JOB_FAMILY){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (String n : names) {
                    ServerConfigurationEditor.this.session.deleteServerVariable(n);
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ServerConfigurationEditor.this.refresh();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ServerConfigurationEditor_DeleteJobError;
            }
        }.start();
    }
}

