/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum LinkLayerDiscoveryProtocol {
    UNKNOWN(0),
    FDB(1),
    CDP(2),
    LLDP(3),
    NDP(4),
    EDP(5),
    STP(6);

    private int value;
    private static Map<Integer, LinkLayerDiscoveryProtocol> lookupTable;

    private LinkLayerDiscoveryProtocol(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static LinkLayerDiscoveryProtocol getByValue(int value) {
        LinkLayerDiscoveryProtocol element = lookupTable.get(value);
        if (element == null) {
            Logger.warning(LinkLayerDiscoveryProtocol.class.getName(), "Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }

    static {
        lookupTable = new HashMap<Integer, LinkLayerDiscoveryProtocol>();
        for (LinkLayerDiscoveryProtocol element : LinkLayerDiscoveryProtocol.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

