/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.ClusterResource;
import org.netxms.client.objects.ClusterSyncNetwork;
import org.netxms.client.objects.GenericObject;

public class Cluster
extends GenericObject {
    private int clusterType;
    private List<ClusterSyncNetwork> syncNetworks = new ArrayList<ClusterSyncNetwork>(1);
    private List<ClusterResource> resources = new ArrayList<ClusterResource>();
    private long zoneId;

    public Cluster(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.clusterType = msg.getFieldAsInt32(262L);
        this.zoneId = msg.getFieldAsInt64(147L);
        int count2 = msg.getFieldAsInt32(263L);
        if (count2 > 0) {
            long[] sn = msg.getFieldAsUInt32Array(264L);
            int i = 0;
            while (i < sn.length) {
                InetAddress addr = this.inetAddressFromInt32(sn[i++]);
                InetAddress mask = this.inetAddressFromInt32(sn[i++]);
                this.syncNetworks.add(new ClusterSyncNetwork(addr, mask));
            }
        }
        count2 = msg.getFieldAsInt32(265L);
        long baseId = 0x20000000L;
        int i = 0;
        while (i < count2) {
            this.resources.add(new ClusterResource(msg, baseId));
            ++i;
            baseId += 10L;
        }
    }

    private InetAddress inetAddressFromInt32(long intVal) {
        InetAddress inetAddr;
        byte[] addr = new byte[]{(byte)((intVal & 0xFFFFFFFFFF000000L) >> 24), (byte)((intVal & 0xFF0000L) >> 16), (byte)((intVal & 0xFF00L) >> 8), (byte)(intVal & 0xFFL)};
        try {
            inetAddr = InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            inetAddr = null;
        }
        return inetAddr;
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    @Override
    public boolean isAlarmsVisible() {
        return true;
    }

    public int getClusterType() {
        return this.clusterType;
    }

    public List<ClusterSyncNetwork> getSyncNetworks() {
        return this.syncNetworks;
    }

    public List<ClusterResource> getResources() {
        return this.resources;
    }

    @Override
    public String getObjectClassName() {
        return "Cluster";
    }

    public long getZoneId() {
        return this.zoneId;
    }
}

