/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.net.InetAddress;
import java.util.HashSet;
import org.netxms.base.NXCPMessage;
import org.netxms.client.MacAddress;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.LinkLayerDiscoveryProtocol;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.GenericObject;

public class Interface
extends GenericObject {
    public static final int IF_SYNTHETIC_MASK = 1;
    public static final int IF_PHYSICAL_PORT = 2;
    public static final int IF_EXCLUDE_FROM_TOPOLOGY = 4;
    public static final int IF_LOOPBACK = 8;
    public static final int IF_CREATED_MANUALLY = 16;
    public static final int IF_EXPECTED_STATE_MASK = 0x30000000;
    public static final int ADMIN_STATE_UNKNOWN = 0;
    public static final int ADMIN_STATE_UP = 1;
    public static final int ADMIN_STATE_DOWN = 2;
    public static final int ADMIN_STATE_TESTING = 3;
    public static final int OPER_STATE_UNKNOWN = 0;
    public static final int OPER_STATE_UP = 1;
    public static final int OPER_STATE_DOWN = 2;
    public static final int OPER_STATE_TESTING = 3;
    public static final int PAE_STATE_UNKNOWN = 0;
    public static final int PAE_STATE_INITIALIZE = 1;
    public static final int PAE_STATE_DISCONNECTED = 2;
    public static final int PAE_STATE_CONNECTING = 3;
    public static final int PAE_STATE_AUTHENTICATING = 4;
    public static final int PAE_STATE_AUTHENTICATED = 5;
    public static final int PAE_STATE_ABORTING = 6;
    public static final int PAE_STATE_HELD = 7;
    public static final int PAE_STATE_FORCE_AUTH = 8;
    public static final int PAE_STATE_FORCE_UNAUTH = 9;
    public static final int PAE_STATE_RESTART = 10;
    public static final int BACKEND_STATE_UNKNOWN = 0;
    public static final int BACKEND_STATE_REQUEST = 1;
    public static final int BACKEND_STATE_RESPONSE = 2;
    public static final int BACKEND_STATE_SUCCESS = 3;
    public static final int BACKEND_STATE_FAIL = 4;
    public static final int BACKEND_STATE_TIMEOUT = 5;
    public static final int BACKEND_STATE_IDLE = 6;
    public static final int BACKEND_STATE_INITIALIZE = 7;
    public static final int BACKEND_STATE_IGNORE = 8;
    private static final String[] stateText = new String[]{"UNKNOWN", "UP", "DOWN", "TESTING"};
    private static final String[] paeStateText = new String[]{"UNKNOWN", "INITIALIZE", "DISCONNECTED", "CONNECTING", "AUTHENTICATING", "AUTHENTICATED", "ABORTING", "HELD", "FORCE AUTH", "FORCE UNAUTH", "RESTART"};
    private static final String[] backendStateText = new String[]{"UNKNOWN", "REQUEST", "RESPONSE", "SUCCESS", "FAIL", "TIMEOUT", "IDLE", "INITIALIZE", "IGNORE"};
    private int flags;
    private InetAddress subnetMask;
    private int ifIndex;
    private int ifType;
    private int mtu;
    private int slot;
    private int port;
    private MacAddress macAddress;
    private int requiredPollCount;
    private long peerNodeId;
    private long peerInterfaceId;
    private LinkLayerDiscoveryProtocol peerDiscoveryProtocol;
    private long zoneId;
    private String description;
    private String alias;
    private int adminState;
    private int operState;
    private int dot1xPaeState;
    private int dot1xBackendState;

    public Interface(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.flags = msg.getFieldAsInt32(13L);
        this.subnetMask = msg.getFieldAsInetAddress(9L);
        this.ifIndex = msg.getFieldAsInt32(11L);
        this.ifType = msg.getFieldAsInt32(12L);
        this.mtu = msg.getFieldAsInt32(493L);
        this.slot = msg.getFieldAsInt32(367L);
        this.port = msg.getFieldAsInt32(368L);
        this.macAddress = new MacAddress(msg.getFieldAsBinary(113L));
        this.requiredPollCount = msg.getFieldAsInt32(299L);
        this.peerNodeId = msg.getFieldAsInt64(373L);
        this.peerInterfaceId = msg.getFieldAsInt64(374L);
        this.peerDiscoveryProtocol = LinkLayerDiscoveryProtocol.getByValue(msg.getFieldAsInt32(472L));
        this.zoneId = msg.getFieldAsInt64(147L);
        this.description = msg.getFieldAsString(27L);
        this.alias = msg.getFieldAsString(494L);
        this.adminState = msg.getFieldAsInt32(414L);
        this.operState = msg.getFieldAsInt32(415L);
        this.dot1xPaeState = msg.getFieldAsInt32(403L);
        this.dot1xBackendState = msg.getFieldAsInt32(404L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractNode getParentNode() {
        AbstractNode node = null;
        HashSet hashSet = this.parents;
        synchronized (hashSet) {
            for (Long id : this.parents) {
                AbstractObject object = this.session.findObjectById(id);
                if (!(object instanceof AbstractNode)) continue;
                node = (AbstractNode)object;
                break;
            }
        }
        return node;
    }

    public InetAddress getSubnetMask() {
        return this.subnetMask;
    }

    public int getSubnetMaskBits() {
        byte[] addr = this.subnetMask.getAddress();
        int bits = 0;
        for (int i = 0; i < addr.length; ++i) {
            if (addr[i] == -1) {
                bits += 8;
                continue;
            }
            for (int j = 128; j > 0 && (addr[i] & j) != 0; j >>= 1) {
                ++bits;
            }
            break;
        }
        return bits;
    }

    public int getIfIndex() {
        return this.ifIndex;
    }

    public int getIfType() {
        return this.ifType;
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    public int getRequiredPollCount() {
        return this.requiredPollCount;
    }

    @Override
    public String getObjectClassName() {
        return "Interface";
    }

    public int getSlot() {
        return this.slot;
    }

    public int getPort() {
        return this.port;
    }

    public long getPeerNodeId() {
        return this.peerNodeId;
    }

    public long getPeerInterfaceId() {
        return this.peerInterfaceId;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public String getDescription() {
        return this.description;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getDot1xPaeState() {
        return this.dot1xPaeState;
    }

    public String getDot1xPaeStateAsText() {
        try {
            return paeStateText[this.dot1xPaeState];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return paeStateText[0];
        }
    }

    public int getDot1xBackendState() {
        return this.dot1xBackendState;
    }

    public String getDot1xBackendStateAsText() {
        try {
            return backendStateText[this.dot1xBackendState];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return backendStateText[0];
        }
    }

    public int getAdminState() {
        return this.adminState;
    }

    public String getAdminStateAsText() {
        try {
            return stateText[this.adminState];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return stateText[0];
        }
    }

    public int getOperState() {
        return this.operState;
    }

    public String getOperStateAsText() {
        try {
            return stateText[this.operState];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return stateText[0];
        }
    }

    public int getExpectedState() {
        return (this.flags & 0x30000000) >> 28;
    }

    public boolean isPhysicalPort() {
        return (this.flags & 2) != 0;
    }

    public boolean isLoopback() {
        return (this.flags & 8) != 0;
    }

    public boolean isExcludedFromTopology() {
        return (this.flags & 4) != 0;
    }

    public LinkLayerDiscoveryProtocol getPeerDiscoveryProtocol() {
        return this.peerDiscoveryProtocol;
    }

    public int getMtu() {
        return this.mtu;
    }

    public String getAlias() {
        return this.alias;
    }
}

