/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting.custom;

import com.radensolutions.reporting.custom.NXCLDataSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.ServerAction;
import org.netxms.client.events.EventProcessingPolicy;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.client.events.EventTemplate;
import org.netxms.client.objects.AbstractObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EppDataSource
extends NXCLDataSource {
    private static final Logger log = LoggerFactory.getLogger(EppDataSource.class);
    private final Map<Long, ServerAction> actionMap = new HashMap<Long, ServerAction>();
    private List<Row> rows = new ArrayList<Row>();
    private Row currentRow;

    protected EppDataSource() {
        super(null, null);
    }

    @Override
    public void loadData(NXCSession session) throws IOException, NXCException {
        EventProcessingPolicy epp = session.getEventProcessingPolicy();
        for (ServerAction action : session.getActions()) {
            this.actionMap.put(action.getId(), action);
        }
        int ruleIndex = 0;
        for (EventProcessingPolicyRule rule : epp.getRules()) {
            ArrayList<Cell> filterRows = new ArrayList<Cell>();
            ArrayList<Cell> actionRows = new ArrayList<Cell>();
            this.processSources(session, rule, filterRows);
            this.processEvents(session, rule, filterRows);
            this.processAlarms(rule, actionRows);
            this.processStop(rule, actionRows);
            int count = Math.max(filterRows.size(), actionRows.size());
            String name = rule.getComments();
            if (rule.isDisabled()) {
                name = name + " (disabled)";
            }
            for (int i = 0; i < count; ++i) {
                this.rows.add(new Row(ruleIndex, name, this.safePop(filterRows), this.safePop(actionRows)));
            }
            ++ruleIndex;
        }
    }

    private void processStop(EventProcessingPolicyRule rule, List<Cell> actionRows) {
        int flags = rule.getFlags();
        if ((flags & 1) == 1) {
            actionRows.add(new Cell("Stop Processing", true));
        }
    }

    private void processAlarms(EventProcessingPolicyRule rule, List<Cell> actionRows) {
        List actions;
        int flags = rule.getFlags();
        if ((flags & 8) == 8) {
            switch (rule.getAlarmSeverity()) {
                case NORMAL: 
                case WARNING: 
                case MINOR: 
                case MAJOR: 
                case CRITICAL: 
                case UNKNOWN: {
                    actionRows.add(new Cell("Generate alarm", true));
                    actionRows.add(new Cell(rule.getAlarmMessage()));
                    actionRows.add(new Cell("with key \"" + rule.getAlarmKey() + "\""));
                    break;
                }
                case TERMINATE: {
                    actionRows.add(new Cell("Terminate alarm", true));
                    actionRows.add(new Cell("with key \"" + rule.getAlarmKey() + "\""));
                    break;
                }
                case RESOLVE: {
                    actionRows.add(new Cell("Resolve alarm", true));
                    actionRows.add(new Cell("with key \"" + rule.getAlarmKey() + "\""));
                }
            }
        }
        if ((actions = rule.getActions()).size() > 0) {
            actionRows.add(new Cell("Execute actions", true));
            for (Long actionId : actions) {
                ServerAction action = this.actionMap.get(actionId);
                actionRows.add(new Cell(action.getName()));
            }
        }
    }

    private void processEvents(NXCSession session, EventProcessingPolicyRule rule, List<Cell> filterRows) {
        String prefix;
        int flags = rule.getFlags();
        List events = rule.getEvents();
        if (events.size() > 0) {
            prefix = "";
            prefix = !filterRows.isEmpty() ? "AND " : "IF ";
            if (rule.isEventsInverted()) {
                filterRows.add(new Cell(prefix + "event is NOT", true));
            } else {
                filterRows.add(new Cell(prefix + "event is", true));
            }
            for (Long eventId : events) {
                EventTemplate event = session.findEventTemplateByCode(eventId.longValue());
                filterRows.add(new Cell(event.getName()));
            }
        }
        if ((flags & 0x1F00) != 7936) {
            prefix = "";
            prefix = !filterRows.isEmpty() ? "AND " : "IF ";
            filterRows.add(new Cell(prefix + "event severity is", true));
            if ((flags & 0x100) == 256) {
                filterRows.add(new Cell("Normal"));
            }
            if ((flags & 0x200) == 512) {
                filterRows.add(new Cell("Warning"));
            }
            if ((flags & 0x400) == 1024) {
                filterRows.add(new Cell("Minor"));
            }
            if ((flags & 0x800) == 2048) {
                filterRows.add(new Cell("Major"));
            }
            if ((flags & 0x1000) == 4096) {
                filterRows.add(new Cell("Critical"));
            }
        }
    }

    private void processSources(NXCSession session, EventProcessingPolicyRule rule, List<Cell> filterRows) {
        List sources = rule.getSources();
        if (sources.size() > 0) {
            if (rule.isSourceInverted()) {
                filterRows.add(new Cell("IF source object is NOT", true));
            } else {
                filterRows.add(new Cell("IF source object is", true));
            }
            for (Long objectId : sources) {
                AbstractObject object = session.findObjectById(objectId.longValue());
                String objectName = object != null ? object.getObjectName() : "[" + objectId + "]";
                filterRows.add(new Cell(objectName));
            }
        }
    }

    private Cell safePop(List<Cell> rows) {
        Cell cell = !rows.isEmpty() ? rows.remove(0) : null;
        return cell;
    }

    public boolean next() throws JRException {
        if (this.rows.isEmpty()) {
            return false;
        }
        this.currentRow = this.rows.remove(0);
        return true;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        String name = jrField.getName();
        if ("id".equalsIgnoreCase(name)) {
            return this.currentRow.index;
        }
        if ("name".equalsIgnoreCase(name)) {
            return this.currentRow.name;
        }
        if ("filter".equalsIgnoreCase(name)) {
            return this.currentRow.filter.text;
        }
        if ("filterHighlight".equalsIgnoreCase(name)) {
            return this.currentRow.filter.highlight;
        }
        if ("action".equalsIgnoreCase(name)) {
            return this.currentRow.action.text;
        }
        if ("actionHighlight".equalsIgnoreCase(name)) {
            return this.currentRow.action.highlight;
        }
        return null;
    }

    private class Row {
        private final int index;
        private final String name;
        private final Cell filter;
        private final Cell action;

        public Row(int index, String name, Cell filter, Cell action) {
            this.index = index;
            this.name = name;
            this.filter = filter == null ? new Cell("") : filter;
            this.action = action == null ? new Cell("") : action;
        }
    }

    private class Cell {
        private final String text;
        private final boolean highlight;

        public Cell(String text) {
            this(text, false);
        }

        public Cell(String text, boolean highlight) {
            this.text = text;
            this.highlight = highlight;
        }
    }
}

