/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting.custom;

import com.radensolutions.reporting.custom.NXCLDataSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRValueParameter;
import org.netxms.api.client.NetXMSClientException;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Subnet;

public class IPInventoryDataSource
extends NXCLDataSource {
    private Subnet subnet;
    private ArrayList<Row> rows = new ArrayList();
    private Row currentRow;

    protected IPInventoryDataSource(JRDataset dataset, Map<String, ? extends JRValueParameter> parameters) {
        super(dataset, parameters);
    }

    @Override
    public void loadData(NXCSession session) throws IOException, NetXMSClientException {
        Long subnetId = (Long)this.getParameterValue("OBJECT_ID");
        this.subnet = (Subnet)session.findObjectById(subnetId.longValue(), Subnet.class);
        if (this.subnet != null) {
            long[] map = session.getSubnetAddressMap(subnetId.longValue());
            List objects = session.findMultipleObjects(map, true);
            for (int i = 0; i < map.length; ++i) {
                this.rows.add(new Row(i, map[i], (AbstractObject)objects.get(i)));
            }
        }
    }

    public boolean next() throws JRException {
        if (!this.rows.isEmpty()) {
            this.currentRow = this.rows.remove(0);
            return true;
        }
        return false;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        String name = jrField.getName();
        if (name.equalsIgnoreCase("ip")) {
            if (this.subnet.getMaskBits() < 24) {
                return String.format(".%d.%d", (this.currentRow.index & 0xFF00) >> 8, this.currentRow.index & 0xFF);
            }
            return String.format(".%d", this.currentRow.index & 0xFF);
        }
        if (name.equalsIgnoreCase("status")) {
            return this.currentRow.status;
        }
        if (name.equalsIgnoreCase("name")) {
            return this.currentRow.name;
        }
        if (name.equalsIgnoreCase("subnet")) {
            return String.format("%s/%d", this.subnet.getPrimaryIP().getHostAddress(), this.subnet.getMaskBits());
        }
        return null;
    }

    private class Row {
        int index;
        int status;
        String name;

        public Row(int index, Long id, AbstractObject object) {
            this.index = index;
            this.status = id == 0L ? 0 : (id == 0xFFFFFFFFL ? 1 : 2);
            this.name = object.getStatus() != ObjectStatus.UNKNOWN ? object.getObjectName() : null;
        }
    }
}

