/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting.custom;

import com.radensolutions.reporting.custom.NXCLDataSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRValueParameter;
import org.netxms.api.client.NetXMSClientException;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.EntireNetwork;
import org.netxms.client.objects.Node;

public class InventoryDataSource
extends NXCLDataSource {
    private List<Row> rows = new ArrayList<Row>();
    private Row currentRow;

    protected InventoryDataSource(JRDataset dataset, Map<String, ? extends JRValueParameter> parameters) {
        super(dataset, parameters);
    }

    @Override
    public void loadData(NXCSession session) throws IOException, NetXMSClientException {
        EntireNetwork entireNetwork = (EntireNetwork)session.findObjectById(1L, EntireNetwork.class);
        Set nodes = entireNetwork.getAllChilds(2);
        for (AbstractObject abstractObject : nodes) {
            DciValue[] lastValues;
            Node node = (Node)abstractObject;
            Row row = new Row();
            row.id = (int)node.getObjectId();
            row.name = node.getObjectName();
            row.uname = node.getSystemDescription();
            row.platform = node.hasSnmpAgent() ? "SNMP" : (node.hasAgent() ? node.getPlatformName() : "Unknown");
            row.primaryIp = node.getPrimaryIP().getHostName();
            row.bootTime = (int)(node.getBootTime() == null ? 0L : node.getBootTime().getTime() / 1000L);
            row.lastUpdate = 0;
            for (DciValue lastValue : lastValues = session.getLastValues(node.getObjectId())) {
                if (!lastValue.getName().equalsIgnoreCase("System.Update.LastInstallTime")) continue;
                try {
                    row.lastUpdate = Integer.parseInt(lastValue.getValue());
                }
                catch (Exception e) {
                    row.lastUpdate = 0;
                }
                break;
            }
            this.rows.add(row);
        }
        Collections.sort(this.rows, new Comparator<Row>(){

            @Override
            public int compare(Row o1, Row o2) {
                return o1.platform.compareTo(o2.platform);
            }
        });
    }

    public boolean next() throws JRException {
        if (this.rows.isEmpty()) {
            return false;
        }
        this.currentRow = this.rows.remove(0);
        return true;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        String name = jrField.getName();
        if ("id".equalsIgnoreCase(name)) {
            return this.currentRow.id;
        }
        if ("name".equalsIgnoreCase(name)) {
            return this.currentRow.name;
        }
        if ("uname".equalsIgnoreCase(name)) {
            return this.currentRow.uname;
        }
        if ("primary_ip".equalsIgnoreCase(name)) {
            return this.currentRow.primaryIp;
        }
        if ("platform".equalsIgnoreCase(name)) {
            return this.currentRow.platform;
        }
        if ("boot_time".equalsIgnoreCase(name)) {
            return this.currentRow.bootTime;
        }
        if ("last_update".equalsIgnoreCase(name)) {
            return this.currentRow.lastUpdate;
        }
        return null;
    }

    private class Row {
        int id;
        String name;
        String uname;
        String platform;
        String primaryIp;
        int bootTime;
        int lastUpdate;

        private Row() {
        }
    }
}

