/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting.custom;

import com.radensolutions.reporting.custom.EppDataSource;
import com.radensolutions.reporting.custom.IPInventoryDataSource;
import com.radensolutions.reporting.custom.InventoryDataSource;
import com.radensolutions.reporting.custom.PerformanceDataSource;
import com.radensolutions.reporting.service.ServerSettings;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NXCLQueryExecutor
implements JRQueryExecuter {
    private static final Logger log = LoggerFactory.getLogger(NXCLQueryExecutor.class);
    private ServerSettings settings;
    private JRDataset dataset;
    private Map<String, ? extends JRValueParameter> parametersMap;

    protected NXCLQueryExecutor(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        this.dataset = dataset;
        this.parametersMap = parametersMap;
        JRParameter[] parameters = dataset.getParameters();
        System.out.println("--------------------------");
        for (JRParameter parameter : parameters) {
            if (!parameter.isSystemDefined()) {
                // empty if block
            }
            System.out.print(parameter.isSystemDefined());
            System.out.print(" ");
            System.out.println(parameter.getName());
        }
        System.out.println("--------------------------");
    }

    public JRDataSource createDatasource() throws JRException {
        JRQueryChunk chunk = this.dataset.getQuery().getChunks()[0];
        String queryString = chunk.getText().trim();
        log.debug("query[0]: " + queryString);
        if (queryString.equalsIgnoreCase("epp")) {
            EppDataSource dataSource = new EppDataSource();
            dataSource.connect(this.settings.getNetxmsServer(), this.settings.getNetxmsLogin(), this.settings.getNetxmsPassword());
            return dataSource;
        }
        if (queryString.equalsIgnoreCase("ip-inventory")) {
            IPInventoryDataSource dataSource = new IPInventoryDataSource(this.dataset, this.parametersMap);
            dataSource.connect(this.settings.getNetxmsServer(), this.settings.getNetxmsLogin(), this.settings.getNetxmsPassword());
            return dataSource;
        }
        if (queryString.equalsIgnoreCase("perf-cpu")) {
            PerformanceDataSource dataSource = new PerformanceDataSource(PerformanceDataSource.Type.CPU, this.dataset, this.parametersMap);
            dataSource.connect(this.settings.getNetxmsServer(), this.settings.getNetxmsLogin(), this.settings.getNetxmsPassword());
            return dataSource;
        }
        if (queryString.equalsIgnoreCase("perf-traffic")) {
            PerformanceDataSource dataSource = new PerformanceDataSource(PerformanceDataSource.Type.TRAFFIC, this.dataset, this.parametersMap);
            dataSource.connect(this.settings.getNetxmsServer(), this.settings.getNetxmsLogin(), this.settings.getNetxmsPassword());
            return dataSource;
        }
        if (queryString.equalsIgnoreCase("perf-disk")) {
            PerformanceDataSource dataSource = new PerformanceDataSource(PerformanceDataSource.Type.DISK, this.dataset, this.parametersMap);
            dataSource.connect(this.settings.getNetxmsServer(), this.settings.getNetxmsLogin(), this.settings.getNetxmsPassword());
            return dataSource;
        }
        if (queryString.equalsIgnoreCase("inventory-by-platform")) {
            InventoryDataSource dataSource = new InventoryDataSource(this.dataset, this.parametersMap);
            dataSource.connect(this.settings.getNetxmsServer(), this.settings.getNetxmsLogin(), this.settings.getNetxmsPassword());
            return dataSource;
        }
        return null;
    }

    public void close() {
    }

    public boolean cancelQuery() throws JRException {
        System.out.println("cancelQuery");
        return false;
    }

    public void setSettings(ServerSettings settings) {
        this.settings = settings;
    }
}

