/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting.service.impl;

import com.radensolutions.reporting.model.Notification;
import com.radensolutions.reporting.model.ReportDefinition;
import com.radensolutions.reporting.model.ReportResult;
import com.radensolutions.reporting.service.Connector;
import com.radensolutions.reporting.service.MessageProcessingResult;
import com.radensolutions.reporting.service.NotificationService;
import com.radensolutions.reporting.service.ReportManager;
import com.radensolutions.reporting.service.ReportScheduler;
import com.radensolutions.reporting.service.Session;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.netxms.api.client.reporting.ReportRenderFormat;
import org.netxms.base.NXCPMessage;
import org.quartz.JobDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SessionImpl
implements Session {
    public static final Logger logger = LoggerFactory.getLogger(SessionImpl.class);
    public static final int NXCP_VERSION = 0x2000000;
    @Autowired
    private Connector connector;
    @Autowired
    private ReportManager reportManager;
    @Autowired
    private ReportScheduler scheduler;
    @Autowired
    private NotificationService notificationService;

    @Override
    public MessageProcessingResult processMessage(NXCPMessage message) {
        NXCPMessage reply = new NXCPMessage(29, message.getMessageId());
        File file = null;
        switch (message.getMessageCode()) {
            case 3: 
            case 232: {
                reply.setFieldInt32(28L, 0);
                break;
            }
            case 182: {
                reply = new NXCPMessage(183, message.getMessageId());
                reply.setControl(true);
                reply.setControlData(0x2000000L);
                break;
            }
            case 4352: {
                this.listReports(reply);
                break;
            }
            case 4353: {
                this.getReportDefinition(message, reply);
                break;
            }
            case 4354: {
                this.scheduleExecution(message, reply);
                break;
            }
            case 4358: {
                this.listSchedules(message, reply);
                break;
            }
            case 4359: {
                this.deleteSchedule(message, reply);
                break;
            }
            case 4355: {
                this.listResults(message, reply);
                break;
            }
            case 4356: {
                file = this.renderResult(message, reply);
                break;
            }
            case 4357: {
                this.deleteResult(message, reply);
                break;
            }
            case 4361: {
                this.reportNotify(message, reply);
                break;
            }
            default: {
                reply.setFieldInt32(28L, 28);
            }
        }
        return new MessageProcessingResult(reply, file);
    }

    private void listReports(NXCPMessage reply) {
        List<UUID> list = this.reportManager.listReports();
        reply.setFieldInt32(111L, list.size());
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            UUID uuid = list.get(i);
            reply.setField(0x10000000L + (long)i, uuid);
        }
        reply.setFieldInt32(28L, 0);
    }

    private void getReportDefinition(NXCPMessage request, NXCPMessage reply) {
        UUID reportId = request.getFieldAsUUID(390L);
        String localeString = request.getFieldAsString(450L);
        Locale locale = new Locale(localeString);
        ReportDefinition definition = reportId != null ? this.reportManager.getReportDefinition(reportId, locale) : null;
        if (definition != null) {
            reply.setFieldInt32(28L, 0);
            definition.fillMessage(reply);
        } else {
            reply.setFieldInt32(28L, 46);
        }
    }

    private void listResults(NXCPMessage request, NXCPMessage reply) {
        reply.setFieldInt32(28L, 0);
        int userId = request.getFieldAsInt32(35L);
        UUID reportId = request.getFieldAsUUID(390L);
        List<ReportResult> list = this.reportManager.listResults(reportId, userId);
        long index = 0x30000000L;
        int jobNum = 0;
        for (ReportResult record : list) {
            reply.setField(index++, record.getJobId());
            reply.setFieldInt32(index++, (int)(record.getExecutionTime().getTime() / 1000L));
            reply.setFieldInt32(index++, record.getUserId());
            index += 7L;
            ++jobNum;
        }
        reply.setFieldInt32(111L, jobNum);
        reply.setFieldInt32(28L, 0);
    }

    private void scheduleExecution(NXCPMessage request, NXCPMessage reply) {
        int retCode;
        UUID reportUuid = request.getFieldAsUUID(390L);
        if (reportUuid != null) {
            Map<String, Object> parameters = this.getParametersFromRequest(request);
            UUID jobUuid = request.getFieldAsUUID(467L);
            int jobType = request.getFieldAsInt32(468L);
            long timestamp = request.getFieldAsInt64(94L);
            int userId = request.getFieldAsInt32(35L);
            if (timestamp == 0L) {
                UUID jobId = this.scheduler.execute(jobUuid, userId, reportUuid, parameters);
                if (jobId != null) {
                    reply.setField(331L, jobId);
                }
                this.sendNotify(3001, 0);
            } else {
                int daysOfWeek = request.getFieldAsInt32(448L);
                int daysOfMonth = request.getFieldAsInt32(449L);
                this.scheduler.addRecurrent(jobUuid, reportUuid, jobType, daysOfWeek, daysOfMonth, new Date(timestamp), parameters, userId);
                this.sendNotify(3000, 0);
            }
            retCode = 0;
        } else {
            retCode = 12;
        }
        reply.setFieldInt32(28L, retCode);
    }

    private void listSchedules(NXCPMessage request, NXCPMessage reply) {
        UUID reportId = request.getFieldAsUUID(390L);
        int userId = request.getFieldAsInt32(35L);
        List<JobDetail> jobDetailList = this.scheduler.getSchedules(reportId);
        int jobDetailsNum = 0;
        long varId = 0x30000000L;
        for (JobDetail jobDetail : jobDetailList) {
            Map jobDataMap = jobDetail.getJobDataMap().getWrappedMap();
            try {
                if (!reportId.equals(jobDataMap.get("reportId")) || (Integer)jobDataMap.get("userId") != userId && userId != 0) continue;
                reply.setField(varId, (UUID)jobDataMap.get("jobId"));
                reply.setField(varId + 1L, (UUID)jobDataMap.get("reportId"));
                reply.setFieldInt32(varId + 2L, ((Integer)jobDataMap.get("userId")).intValue());
                reply.setFieldInt64(varId + 3L, ((Date)jobDataMap.get("startDate")).getTime());
                reply.setFieldInt32(varId + 4L, ((Integer)jobDataMap.get("daysOfWeek")).intValue());
                reply.setFieldInt32(varId + 5L, ((Integer)jobDataMap.get("daysOfMonth")).intValue());
                reply.setFieldInt32(varId + 6L, ((Integer)jobDataMap.get("jobType")).intValue());
                reply.setField(varId + 7L, (String)jobDataMap.get("comments"));
                varId += 20L;
                ++jobDetailsNum;
            }
            catch (Exception e) {
                logger.error("Application error: ", (Throwable)e);
            }
        }
        reply.setFieldInt32(111L, jobDetailsNum);
        reply.setFieldInt32(28L, 0);
    }

    private Map<String, Object> getParametersFromRequest(NXCPMessage request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int count = request.getFieldAsInt32(137L);
        long id = 0x10000000L;
        for (int i = 0; i < count; ++i) {
            String key = request.getFieldAsString(id++);
            String value = request.getFieldAsString(id++);
            map.put(key, value);
        }
        return map;
    }

    private File renderResult(NXCPMessage request, NXCPMessage reply) {
        UUID reportId = request.getFieldAsUUID(390L);
        UUID jobId = request.getFieldAsUUID(331L);
        int formatCode = request.getFieldAsInt32(400L);
        ReportRenderFormat format = ReportRenderFormat.valueOf((Integer)formatCode);
        reply.setFieldInt32(28L, 0);
        this.sendNotify(3001, 0);
        return this.reportManager.renderResult(reportId, jobId, format);
    }

    private void deleteResult(NXCPMessage request, NXCPMessage reply) {
        UUID reportId = request.getFieldAsUUID(390L);
        UUID jobId = request.getFieldAsUUID(331L);
        this.reportManager.deleteResult(reportId, jobId);
        reply.setFieldInt32(28L, 0);
        this.sendNotify(3001, 0);
    }

    private void deleteSchedule(NXCPMessage request, NXCPMessage reply) {
        UUID reportId = request.getFieldAsUUID(390L);
        UUID jobId = request.getFieldAsUUID(331L);
        this.scheduler.deleteScheduleJob(reportId, jobId);
        this.notificationService.delete(jobId);
        reply.setFieldInt32(28L, 0);
        this.sendNotify(3000, 0);
    }

    private void reportNotify(NXCPMessage request, NXCPMessage reply) {
        UUID jobId = request.getFieldAsUUID(467L);
        int attachFormatCode = request.getFieldAsInt32(400L);
        String reportName = request.getFieldAsString(469L);
        int count = request.getFieldAsInt32(111L);
        long index = 112L;
        for (int i = 0; i < count; ++i) {
            String mail = request.getFieldAsString(index + (long)i);
            if (mail == null || jobId == null) continue;
            this.notificationService.create(new Notification(jobId, mail, attachFormatCode, reportName));
        }
        reply.setFieldInt32(28L, 0);
    }

    public String toString() {
        return "Session{connector=" + this.connector + '}';
    }

    @Override
    public void sendNotify(int code, int data) {
        NXCPMessage msg = new NXCPMessage(4360);
        msg.setFieldInt32(23L, code);
        msg.setFieldInt32(92L, data);
        try {
            this.connector.sendBroadcast(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

