/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxDataInputStream;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxFloat;
import com.informix.jdbc.IfxSmallFloat;
import com.informix.lang.IfxToJavaType;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;

abstract class IfxSQLInput
implements SQLInput {
    protected IfxConnection conn;
    ByteArrayInputStream a;
    IfxDataInputStream b;
    private Map c;
    protected boolean isNull = false;
    protected byte[] buf = null;
    protected int totalLength;
    protected int unreadLength;
    protected int currentPos = 0;
    private int d = 0;
    protected Trace trace = null;

    IfxSQLInput(IfxConnection ifxConnection, byte[] byArray, int n, int n2) throws SQLException {
        this.a(ifxConnection);
        this.a = new ByteArrayInputStream(byArray, n, n2);
        this.b = new IfxDataInputStream(this.a);
        if (ifxConnection != null) {
            this.b.setClientLocale(ifxConnection.getclLocale());
        }
        this.unreadLength = this.totalLength = n2;
        this.buf = byArray;
        this.d = n;
    }

    void a(IfxConnection ifxConnection) throws SQLException {
        this.conn = ifxConnection;
    }

    void a(Map map) {
        this.c = map;
    }

    byte[] a() throws SQLException {
        byte[] byArray = new byte[this.totalLength];
        System.arraycopy(this.buf, this.d, byArray, 0, this.totalLength);
        return byArray;
    }

    protected void skipBytes(int n) throws SQLException {
        try {
            this.b.skipBytes(n);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    protected int currentPosition() {
        return this.totalLength - this.a.available();
    }

    public int length() {
        return this.totalLength;
    }

    protected int available() {
        return this.a.available();
    }

    protected void reset() {
        this.a.reset();
        this.currentPos = 0;
    }

    protected void checkLength(int n) throws SQLException {
        if (this.unreadLength < n) {
            throw IfxErrMsg.getSQLException(-79772, this.conn);
        }
        this.unreadLength -= n;
    }

    public String readString() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readString().", this.conn);
    }

    public boolean readBoolean() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBoolean().", this.conn);
    }

    public byte readByte() throws SQLException {
        return (byte)this.readShort();
    }

    public short readShort() throws SQLException {
        this.checkLength(2);
        this.isNull = false;
        try {
            short s = this.b.readShort();
            if (s == Short.MIN_VALUE) {
                this.isNull = true;
                s = 0;
            }
            this.currentPos += 2;
            return s;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public int readInt() throws SQLException {
        this.checkLength(4);
        this.isNull = false;
        try {
            int n = this.b.readInt();
            if (n == Integer.MIN_VALUE) {
                this.isNull = true;
                n = 0;
            }
            this.currentPos += 4;
            return n;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public long readLong() throws SQLException {
        this.checkLength(10);
        this.isNull = false;
        try {
            long l = this.b.readLongInt();
            if (l == Long.MIN_VALUE) {
                this.isNull = true;
                l = 0L;
            }
            this.currentPos += 10;
            return l;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public float readFloat() throws SQLException {
        this.checkLength(4);
        byte[] byArray = new byte[4];
        this.isNull = true;
        try {
            this.a.read(byArray, 0, 4);
            this.currentPos += 4;
            this.isNull = IfxSmallFloat.a(byArray);
            if (this.isNull) {
                return 0.0f;
            }
            return IfxToJavaType.IfxToJavaReal(byArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public double readDouble() throws SQLException {
        this.checkLength(8);
        byte[] byArray = new byte[8];
        this.isNull = true;
        try {
            this.a.read(byArray, 0, 8);
            this.isNull = IfxFloat.a(byArray);
            if (this.isNull) {
                return 0.0;
            }
            return IfxToJavaType.IfxToJavaDouble(byArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public BigDecimal readBigDecimal() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBigDecimal().", this.conn);
    }

    public byte[] readBytes() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBytes().", this.conn);
    }

    public byte[] readBytes(int n) throws SQLException {
        byte[] byArray;
        if (this.unreadLength < n) {
            n = this.unreadLength;
        }
        this.checkLength(n);
        try {
            byArray = new byte[n];
            this.b.readFully(byArray, 0, n);
            this.currentPos += n;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        return byArray;
    }

    public Date readDate() throws SQLException {
        this.checkLength(4);
        try {
            Date date = this.b.readDate();
            this.currentPos += 4;
            if (date == null) {
                this.isNull = true;
                return null;
            }
            return date;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public Time readTime() throws SQLException {
        try {
            Timestamp timestamp = this.readTimestamp();
            if (timestamp == null) {
                this.isNull = true;
                return null;
            }
            return new Time(timestamp.getTime());
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public Timestamp readTimestamp() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readTimestamp().", this.conn);
    }

    public Reader readCharacterStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readCharacterStream().", this.conn);
    }

    public InputStream readAsciiStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readAsciiStream().", this.conn);
    }

    public InputStream readBinaryStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBinaryStream().", this.conn);
    }

    public Object readObject() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readObject().", this.conn);
    }

    public Ref readRef() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readRef().", this.conn);
    }

    public Blob readBlob() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBlob().", this.conn);
    }

    public Clob readClob() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readClob().", this.conn);
    }

    public Array readArray() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readArray().", this.conn);
    }

    public boolean wasNull() {
        return this.isNull;
    }
}

