/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxResultSet;
import com.informix.jdbc.IfxCollection;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxValue;
import com.informix.jdbc.ResultSet2;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public abstract class IfxScrollableResultSet
implements IfmxResultSet,
ResultSet2 {
    protected IfxResultSetMetaData rsmd = null;
    protected IfxConnection conn = null;
    protected Trace trace = null;
    protected Vector insertRowVector = null;
    protected Vector colVector = null;
    protected boolean insertMode = false;
    protected boolean lastColWasNull = false;
    protected Hashtable nameToIdxTable = null;
    protected boolean delimIdent = false;
    protected Map typeMap = null;
    protected SQLWarning warnings = null;

    IfxScrollableResultSet(IfxConnection ifxConnection, ResultSetMetaData resultSetMetaData) throws SQLException {
        this.rsmd = (IfxResultSetMetaData)resultSetMetaData;
        if (ifxConnection != null) {
            this.conn = ifxConnection;
            this.trace = ifxConnection.getTrace();
            this.typeMap = ifxConnection.getTypeMap();
        }
    }

    private IfxObject a(int n) throws SQLException {
        return this.a(n, null);
    }

    private IfxObject a(int n, Calendar calendar) throws SQLException {
        IfxObject ifxObject;
        block10: {
            block9: {
                int n2;
                block8: {
                    block7: {
                        n2 = IfxStatement.t;
                        Vector vector = null;
                        vector = this.b(n);
                        ifxObject = (IfxObject)vector.elementAt(n - 1);
                        if (ifxObject != null) break block7;
                        ifxObject = IfxValue.a(this.conn, this.rsmd.a(n));
                        vector.setElementAt(ifxObject, n - 1);
                        if (n2 == 0) break block8;
                    }
                    if (ifxObject instanceof IfxDateTime && !((IfxDateTime)ifxObject).isTimeValue()) {
                        ((IfxDateTime)ifxObject).a(calendar);
                    }
                }
                if (!ifxObject.isNull()) break block9;
                this.lastColWasNull = true;
                if (n2 == 0) break block10;
            }
            this.lastColWasNull = false;
        }
        return ifxObject;
    }

    private Vector b(int n) throws SQLException {
        Vector vector = null;
        try {
            if (this.insertMode) {
                if (this.insertRowVector == null) {
                    if (this.rsmd == null) {
                        throw IfxErrMsg.getSQLException(-79737, this.conn);
                    }
                    this.insertRowVector = new Vector(this.rsmd.getColumnCount());
                    this.insertRowVector.setSize(this.rsmd.getColumnCount());
                }
                vector = this.insertRowVector;
            } else {
                if (this.colVector == null) {
                    throw IfxErrMsg.getSQLException(-79739, this.conn);
                }
                vector = this.colVector;
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (n < 1 || n > vector.size()) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        return vector;
    }

    public boolean wasNull() {
        return this.lastColWasNull;
    }

    public int findColumn(String string) throws SQLException {
        Integer n;
        block12: {
            block11: {
                boolean bl;
                int n2 = IfxStatement.t;
                if (this.nameToIdxTable == null) {
                    if (this.rsmd == null) {
                        throw IfxErrMsg.getSQLException(-79737, this.conn);
                    }
                    int n3 = this.rsmd.getColumnCount();
                    this.nameToIdxTable = new Hashtable(n3);
                    for (int i2 = 1; i2 <= n3; ++i2) {
                        bl = this.delimIdent;
                        if (n2 == 0) {
                            if (!bl) {
                                this.nameToIdxTable.put(this.rsmd.getColumnName(i2).toLowerCase(), new Integer(i2));
                                if (n2 == 0) continue;
                            }
                            this.nameToIdxTable.put(this.rsmd.getColumnName(i2), new Integer(i2));
                            if (n2 == 0) continue;
                        }
                        break;
                    }
                } else {
                    bl = this.delimIdent;
                }
                if (bl) break block11;
                n = (Integer)this.nameToIdxTable.get(string.toLowerCase());
                if (n2 == 0) break block12;
            }
            n = (Integer)this.nameToIdxTable.get(string);
        }
        if (n == null) {
            throw IfxErrMsg.getSQLException(-79738, this.conn);
        }
        return n;
    }

    protected void chainWarnings(SQLWarning sQLWarning) {
        block2: {
            block3: {
                if (sQLWarning == null) break block2;
                if (this.warnings == null) break block3;
                this.warnings.setNextWarning(sQLWarning);
                if (IfxStatement.t == 0) break block2;
            }
            this.warnings = sQLWarning;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public void updateNull(int n) throws SQLException {
        IfxObject ifxObject = this.a(n);
        ifxObject.nullify();
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        IfxObject ifxObject = this.a(n);
        ifxObject.fromBoolean(bl);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        IfxObject ifxObject = this.a(n);
        ifxObject.fromByte(by);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(int n, short s) throws SQLException {
        IfxObject ifxObject = this.a(n);
        ifxObject.fromShort(s);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(int n, int n2) throws SQLException {
        IfxObject ifxObject = this.a(n);
        ifxObject.fromInt(n2);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        IfxObject ifxObject = this.a(n);
        ifxObject.fromLong(l);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(int n, float f2) throws SQLException {
        IfxObject ifxObject = this.a(n);
        ifxObject.fromFloat(f2);
    }

    public void updateFloat(String string, float f2) throws SQLException {
        this.updateFloat(this.findColumn(string), f2);
    }

    public void updateDouble(int n, double d2) throws SQLException {
        IfxObject ifxObject = this.a(n);
        ifxObject.fromDouble(d2);
    }

    public void updateDouble(String string, double d2) throws SQLException {
        this.updateDouble(this.findColumn(string), d2);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        IfxObject ifxObject = this.a(n);
        ifxObject.fromDecimal(bigDecimal);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(int n, String string) throws SQLException {
        IfxObject ifxObject = this.a(n);
        ifxObject.fromString(string);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        IfxObject ifxObject = this.a(n);
        ifxObject.fromBytes(byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(int n, Date date) throws SQLException {
        IfxObject ifxObject = this.a(n);
        ifxObject.fromDate(date);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(int n, Time time) throws SQLException {
        IfxObject ifxObject = this.a(n);
        ifxObject.fromTime(time);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        IfxObject ifxObject = this.a(n);
        ifxObject.fromTimestamp(timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        IfxObject ifxObject = this.a(n);
        ifxObject.fromAsciiStream(inputStream, n2);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        IfxObject ifxObject = this.a(n);
        ifxObject.fromBinaryStream(inputStream, n2);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        IfxObject ifxObject = this.a(n);
        ifxObject.fromCharacterStream(reader, n2);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateObject(int n, Object object) throws SQLException {
        IfxObject ifxObject = this.a(n);
        ifxObject.fromObject(object);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        IfxObject ifxObject = this.a(n);
        ifxObject.fromObject(object, n2);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateIfxObject(int n, Object object) throws SQLException {
        this.a(n, object);
    }

    public void updateIfxObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    private void a(int n, Object object) throws SQLException {
        block4: {
            Vector vector = null;
            try {
                vector = this.b(n);
                IfxObject ifxObject = (IfxObject)object;
                vector.setElementAt(ifxObject, n - 1);
                if (ifxObject.isNull()) {
                    this.lastColWasNull = true;
                    if (IfxStatement.t == 0) break block4;
                }
                this.lastColWasNull = false;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
    }

    public String getString(int n) throws SQLException {
        IfxObject ifxObject = this.a(n);
        String string = null;
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        string = ifxObject.toString();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return string;
    }

    public String getUnloadString(int n) throws SQLException {
        IfxObject ifxObject = this.a(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        ifxObject.setConnection(this.conn);
        return ifxObject.toUnloadString();
    }

    public String getString(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getString(n);
    }

    public Object getObject(int n) throws SQLException {
        Object object = null;
        object = this.conn != null ? this.getObject(n, this.conn.getTypeMap()) : this.getObject(n, (Map)null);
        return object;
    }

    public Object getObject(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getObject(n);
    }

    public Object getObject(int n, Map map) throws SQLException {
        IfxObject ifxObject = this.a(n);
        Object object = null;
        if (ifxObject != null && !ifxObject.isNull()) {
            ifxObject.setTypeMap(map);
            object = ifxObject.toObject();
            DataTruncation dataTruncation = ifxObject.getWarning();
            if (dataTruncation != null) {
                this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
            }
        }
        return object;
    }

    public Object getObject(String string, Map map) throws SQLException {
        int n = this.findColumn(string);
        return this.getObject(n, map);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        IfxObject ifxObject = this.a(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        InputStream inputStream = ifxObject.toAsciiStream();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return inputStream;
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getAsciiStream(n);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            return new StringReader(string);
        }
        return null;
    }

    public Reader getCharacterStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getCharacterStream(n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        IfxObject ifxObject = this.a(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        BigDecimal bigDecimal = ifxObject.toDecimal().setScale(n2, 4);
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        int n2 = this.findColumn(string);
        return this.getBigDecimal(n2, n);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        IfxObject ifxObject = this.a(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        return ifxObject.toDecimal();
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBigDecimal(n);
    }

    public boolean getBoolean(int n) throws SQLException {
        IfxObject ifxObject = this.a(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return false;
        }
        boolean bl = ifxObject.toBoolean();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return bl;
    }

    public boolean getBoolean(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBoolean(n);
    }

    public short getShort(int n) throws SQLException {
        IfxObject ifxObject = this.a(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0;
        }
        short s = ifxObject.toShort();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return s;
    }

    public short getShort(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getShort(n);
    }

    public int getInt(int n) throws SQLException {
        IfxObject ifxObject = this.a(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0;
        }
        int n2 = ifxObject.toInt();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return n2;
    }

    public int getInt(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getInt(n);
    }

    public long getLong(int n) throws SQLException {
        IfxObject ifxObject = this.a(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0L;
        }
        long l = ifxObject.toLong();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return l;
    }

    public long getLong(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getLong(n);
    }

    public float getFloat(int n) throws SQLException {
        IfxObject ifxObject = this.a(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0.0f;
        }
        float f2 = ifxObject.toFloat();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return f2;
    }

    public float getFloat(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getFloat(n);
    }

    public byte getByte(int n) throws SQLException {
        IfxObject ifxObject = this.a(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0;
        }
        byte by = ifxObject.toByte();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return by;
    }

    public byte getByte(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getByte(n);
    }

    public byte[] getBytes(int n) throws SQLException {
        IfxObject ifxObject = this.a(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        byte[] byArray = ifxObject.toBytes();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return byArray;
    }

    public byte[] getBytes(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBytes(n);
    }

    public Date getDate(int n) throws SQLException {
        IfxObject ifxObject = this.a(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Date date = ifxObject.toDate();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return date;
    }

    public Date getDate(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getDate(n);
    }

    public double getDouble(int n) throws SQLException {
        IfxObject ifxObject = this.a(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0.0;
        }
        double d2 = ifxObject.toDouble();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return d2;
    }

    public double getDouble(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getDouble(n);
    }

    public Time getTime(int n) throws SQLException {
        IfxObject ifxObject = this.a(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Time time = ifxObject.toTime();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return time;
    }

    public Time getTime(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getTime(n);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, (Calendar)null);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        IfxObject ifxObject = this.a(n, calendar);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Timestamp timestamp = ifxObject.toTimestamp();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return timestamp;
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getTimestamp(n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getUnicodeStream(int).", this.conn);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getUnicodeStream(String).", this.conn);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        IfxObject ifxObject = this.a(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        InputStream inputStream = ifxObject.toBinaryStream();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return inputStream;
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBinaryStream(n);
    }

    public Interval getInterval(int n) throws SQLException {
        IfxObject ifxObject = this.a(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Interval interval = ifxObject.toInterval();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return interval;
    }

    public Interval getInterval(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getInterval(n);
    }

    public IntervalYM getIntervalYM(int n) throws SQLException {
        IfxObject ifxObject = this.a(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        IntervalYM intervalYM = ifxObject.toIntervalYM();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return intervalYM;
    }

    public IntervalYM getIntervalYM(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getIntervalYM(n);
    }

    public IntervalDF getIntervalDF(int n) throws SQLException {
        IfxObject ifxObject = this.a(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        IntervalDF intervalDF = ifxObject.toIntervalDF();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return intervalDF;
    }

    public IntervalDF getIntervalDF(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getIntervalDF(n);
    }

    public Ref getRef(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getRef(int).", this.conn);
    }

    public Blob getBlob(int n) throws SQLException {
        IfxObject ifxObject = this.a(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Blob blob = ifxObject.toBlob();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return blob;
    }

    public Clob getClob(int n) throws SQLException {
        IfxObject ifxObject = this.a(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Clob clob = ifxObject.toClob();
        DataTruncation dataTruncation = ifxObject.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return clob;
    }

    public Array getArray(int n) throws SQLException {
        IfxCollection ifxCollection = (IfxCollection)this.a(n);
        Array array = null;
        if (ifxCollection != null && !ifxCollection.isNull()) {
            array = ifxCollection.toArray();
        }
        return array;
    }

    public Ref getRef(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getRef(String).", this.conn);
    }

    public Blob getBlob(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBlob(n);
    }

    public Clob getClob(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getClob(n);
    }

    public Array getArray(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getArray(n);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = this.getDate(n);
        if (date == null) {
            return null;
        }
        long l = date.getTime() + (long)calendar.get(15) + (long)calendar.get(16);
        return new Date(l);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getDate(n, calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = this.getTime(n);
        if (time == null) {
            return null;
        }
        long l = time.getTime() + (long)calendar.get(15) + (long)calendar.get(16);
        return new Time(l);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getTime(n, calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getTimestamp(n, calendar);
    }

    protected void finalize() {
        if (this.insertRowVector != null) {
            this.insertRowVector.removeAllElements();
            this.insertRowVector = null;
        }
    }
}

