/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.jcache.interceptor;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cache.interceptor.MethodCacheKey;
import org.springframework.cache.jcache.interceptor.JCacheOperation;
import org.springframework.cache.jcache.interceptor.JCacheOperationSource;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.util.ClassUtils;

public abstract class AbstractFallbackJCacheOperationSource
implements JCacheOperationSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<Object, JCacheOperation<?>> cache = new ConcurrentHashMap(1024);

    @Override
    public JCacheOperation<?> getCacheOperation(Method method, Class<?> targetClass) {
        MethodCacheKey cacheKey = new MethodCacheKey(method, targetClass);
        JCacheOperation<?> cached = this.cache.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        JCacheOperation<?> operation = this.computeCacheOperation(method, targetClass);
        if (operation != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Adding cacheable method '" + method.getName() + "' with operation: " + operation));
            }
            this.cache.put(cacheKey, operation);
        }
        return operation;
    }

    private JCacheOperation<?> computeCacheOperation(Method method, Class<?> targetClass) {
        if (this.allowPublicMethodsOnly() && !Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, targetClass);
        JCacheOperation<?> operation = this.findCacheOperation(specificMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod), targetClass);
        if (operation != null) {
            return operation;
        }
        if (specificMethod != method && (operation = this.findCacheOperation(method, targetClass)) != null) {
            return operation;
        }
        return null;
    }

    protected abstract JCacheOperation<?> findCacheOperation(Method var1, Class<?> var2);

    protected boolean allowPublicMethodsOnly() {
        return false;
    }
}

