/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.provider;

import java.util.Map;
import net.sf.jasperreports.data.AbstractClasspathAwareDataAdapterService;
import net.sf.jasperreports.data.provider.DataSourceProviderDataAdapter;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSourceProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRClassLoader;

public class DataSourceProviderDataAdapterService
extends AbstractClasspathAwareDataAdapterService {
    private JRDataSourceProvider provider = null;

    public DataSourceProviderDataAdapterService(JasperReportsContext jasperReportsContext, DataSourceProviderDataAdapter dsDataAdapter) {
        super(jasperReportsContext, dsDataAdapter);
    }

    public DataSourceProviderDataAdapterService(DataSourceProviderDataAdapter dsDataAdapter) {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), dsDataAdapter);
    }

    public DataSourceProviderDataAdapter getDataSourceProviderDataAdapter() {
        return (DataSourceProviderDataAdapter)this.getDataAdapter();
    }

    public JRDataSourceProvider getProvider() throws JRException {
        DataSourceProviderDataAdapter dsDataAdapter;
        if (this.provider == null && (dsDataAdapter = this.getDataSourceProviderDataAdapter()) != null) {
            ClassLoader oldThreadClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClassLoader(oldThreadClassLoader));
                Class<?> clazz = JRClassLoader.loadClassForRealName(dsDataAdapter.getProviderClass());
                this.provider = (JRDataSourceProvider)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new JRException(e);
            }
            catch (IllegalAccessException e) {
                throw new JRException(e);
            }
            catch (InstantiationException e) {
                throw new JRException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldThreadClassLoader);
            }
        }
        return this.provider;
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        JRDataSourceProvider dsProvider = this.getProvider();
        if (dsProvider != null) {
            JasperReport jr = (JasperReport)parameters.get("JASPER_REPORT");
            parameters.put("REPORT_DATA_SOURCE", dsProvider.create(jr));
        }
    }
}

