/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ObjectLabelComparator;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class TrustedNodes
extends PropertyPage {
    public static final int COLUMN_NAME = 0;
    private AbstractObject object = null;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button deleteButton;
    private HashMap<Long, AbstractObject> trustedNodes = new HashMap(0);
    private boolean isModified = false;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AbstractObject)this.getElement().getAdapter(AbstractObject.class);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        String[] stringArray = new String[1];
        Messages.get();
        stringArray[0] = Messages.TrustedNodes_Node;
        String[] columnNames = stringArray;
        int[] columnWidths = new int[]{300};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ObjectLabelComparator((ILabelProvider)this.viewer.getLabelProvider()));
        AbstractObject[] nodes = this.object.getTrustedNodes();
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] != null) {
                this.trustedNodes.put(nodes[i].getObjectId(), nodes[i]);
            }
            ++i;
        }
        this.viewer.setInput((Object)this.trustedNodes.values().toArray());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gridData);
        this.addButton = new Button(buttons, 8);
        Messages.get();
        this.addButton.setText(Messages.TrustedNodes_Add);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ObjectSelectionDialog dlg = new ObjectSelectionDialog(TrustedNodes.this.getShell(), null, ObjectSelectionDialog.createNodeSelectionFilter((boolean)true));
                if (dlg.open() == 0) {
                    AbstractObject[] nodes = dlg.getSelectedObjects(AbstractNode.class);
                    int i = 0;
                    while (i < nodes.length) {
                        TrustedNodes.this.trustedNodes.put(nodes[i].getObjectId(), nodes[i]);
                        ++i;
                    }
                    TrustedNodes.this.viewer.setInput((Object)TrustedNodes.this.trustedNodes.values().toArray());
                    TrustedNodes.this.isModified = true;
                }
            }
        });
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.deleteButton = new Button(buttons, 8);
        Messages.get();
        this.deleteButton.setText(Messages.TrustedNodes_Delete);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)TrustedNodes.this.viewer.getSelection();
                Iterator it = selection.iterator();
                if (it.hasNext()) {
                    while (it.hasNext()) {
                        AbstractObject object = (AbstractObject)it.next();
                        TrustedNodes.this.trustedNodes.remove(object.getObjectId());
                    }
                    TrustedNodes.this.viewer.setInput((Object)TrustedNodes.this.trustedNodes.values().toArray());
                    TrustedNodes.this.isModified = true;
                }
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (!this.isModified) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        Set<Long> idList = this.trustedNodes.keySet();
        long[] nodes = new long[idList.size()];
        int i = 0;
        for (long id : idList) {
            nodes[i++] = id;
        }
        md.setTrustedNodes(nodes);
        Messages.get();
        new ConsoleJob(String.format(Messages.TrustedNodes_JobName, this.object.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            TrustedNodes.this.setValid(true);
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.TrustedNodes_JobError;
            }
        }.schedule();
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performDefaults() {
        this.trustedNodes.clear();
        this.viewer.setInput((Object)new AbstractObject[0]);
        this.isModified = true;
        super.performDefaults();
    }
}

