/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.api.client.users;

import java.util.Arrays;
import java.util.Date;
import org.netxms.api.client.users.AbstractUserObject;
import org.netxms.base.NXCPMessage;

public class User
extends AbstractUserObject {
    public static final int AUTH_NETXMS_PASSWORD = 0;
    public static final int AUTH_RADIUS = 1;
    public static final int AUTH_CERTIFICATE = 2;
    public static final int AUTH_CERTIFICATE_OR_PASSWORD = 3;
    public static final int AUTH_CERTIFICATE_OR_RADIUS = 4;
    public static final int MAP_CERT_BY_SUBJECT = 0;
    public static final int MAP_CERT_BY_PUBKEY = 1;
    public static final int MAP_CERT_BY_CN = 2;
    private int authMethod;
    private int certMappingMethod;
    private String certMappingData;
    private String fullName;
    private Date lastLogin = null;
    private Date lastPasswordChange = null;
    private int minPasswordLength;
    private Date disabledUntil = null;
    private int authFailures;
    private String xmppId;
    private long[] groups;

    public User(String name) {
        super(name);
        this.fullName = "";
        this.xmppId = "";
        this.groups = new long[0];
    }

    public User(User src) {
        super(src);
        this.authMethod = src.authMethod;
        this.certMappingMethod = src.certMappingMethod;
        this.certMappingData = src.certMappingData;
        this.fullName = src.fullName;
        this.lastLogin = src.lastLogin;
        this.lastPasswordChange = src.lastPasswordChange;
        this.minPasswordLength = src.minPasswordLength;
        this.disabledUntil = src.disabledUntil;
        this.authFailures = src.authFailures;
        this.xmppId = src.xmppId;
        this.groups = Arrays.copyOf(src.groups, src.groups.length);
    }

    public User(NXCPMessage msg) {
        super(msg);
        this.authMethod = msg.getFieldAsInt32(16L);
        this.fullName = msg.getFieldAsString(40L);
        this.certMappingMethod = msg.getFieldAsInt32(279L);
        this.certMappingData = msg.getFieldAsString(280L);
        this.lastLogin = msg.getFieldAsDate(351L);
        this.lastPasswordChange = msg.getFieldAsDate(352L);
        this.minPasswordLength = msg.getFieldAsInt32(350L);
        this.disabledUntil = msg.getFieldAsDate(353L);
        this.authFailures = msg.getFieldAsInt32(354L);
        this.xmppId = msg.getFieldAsString(457L);
        this.groups = msg.getFieldAsUInt32Array(462L);
        if (this.groups == null) {
            this.groups = new long[0];
        }
    }

    @Override
    public void fillMessage(NXCPMessage msg) {
        super.fillMessage(msg);
        msg.setFieldInt16(16L, this.authMethod);
        msg.setField(40L, this.fullName);
        msg.setFieldInt16(279L, this.certMappingMethod);
        msg.setField(280L, this.certMappingData);
        msg.setFieldInt16(350L, this.minPasswordLength);
        msg.setFieldInt32(353L, this.disabledUntil != null ? (int)(this.disabledUntil.getTime() / 1000L) : 0);
        msg.setField(457L, this.xmppId);
        msg.setFieldInt32(284L, this.groups.length);
        if (this.groups.length > 0) {
            msg.setField(462L, this.groups);
        }
    }

    public int getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(int authMethod) {
        this.authMethod = authMethod;
    }

    public int getCertMappingMethod() {
        return this.certMappingMethod;
    }

    public void setCertMappingMethod(int certMappingMethod) {
        this.certMappingMethod = certMappingMethod;
    }

    public String getCertMappingData() {
        return this.certMappingData;
    }

    public void setCertMappingData(String certMappingData) {
        this.certMappingData = certMappingData;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new User(this);
    }

    public int getMinPasswordLength() {
        return this.minPasswordLength;
    }

    public void setMinPasswordLength(int minPasswordLength) {
        this.minPasswordLength = minPasswordLength;
    }

    public Date getDisabledUntil() {
        return this.disabledUntil;
    }

    public void setDisabledUntil(Date disabledUntil) {
        this.disabledUntil = disabledUntil;
    }

    public Date getLastLogin() {
        return this.lastLogin;
    }

    public Date getLastPasswordChange() {
        return this.lastPasswordChange;
    }

    public int getAuthFailures() {
        return this.authFailures;
    }

    public String getXmppId() {
        return this.xmppId;
    }

    public void setXmppId(String xmppId) {
        this.xmppId = xmppId;
    }

    public long[] getGroups() {
        return this.groups;
    }

    public void setGroups(long[] groups) {
        this.groups = groups;
    }
}

