/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.IpAddressListElement;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.GenericObject;

public class VPNConnector
extends GenericObject {
    private long peerGatewayId;
    private List<IpAddressListElement> localSubnets;
    private List<IpAddressListElement> remoteSubnets;

    public VPNConnector(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        InetAddress mask;
        InetAddress addr;
        this.peerGatewayId = msg.getFieldAsInt64(22L);
        long varId = 0x10000000L;
        int count = msg.getFieldAsInt32(161L);
        this.localSubnets = new ArrayList<IpAddressListElement>(count);
        int i = 0;
        while (i < count) {
            addr = msg.getFieldAsInetAddress(varId++);
            mask = msg.getFieldAsInetAddress(varId++);
            this.localSubnets.add(new IpAddressListElement(0, addr, mask));
            ++i;
        }
        count = msg.getFieldAsInt32(162L);
        this.remoteSubnets = new ArrayList<IpAddressListElement>(count);
        i = 0;
        while (i < count) {
            addr = msg.getFieldAsInetAddress(varId++);
            mask = msg.getFieldAsInetAddress(varId++);
            this.remoteSubnets.add(new IpAddressListElement(0, addr, mask));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractNode getParentNode() {
        AbstractNode node = null;
        HashSet hashSet = this.parents;
        synchronized (hashSet) {
            for (Long id : this.parents) {
                AbstractObject object = this.session.findObjectById(id);
                if (!(object instanceof AbstractNode)) continue;
                node = (AbstractNode)object;
                break;
            }
        }
        return node;
    }

    @Override
    public String getObjectClassName() {
        return "VPNConnector";
    }

    public long getPeerGatewayId() {
        return this.peerGatewayId;
    }

    public List<IpAddressListElement> getLocalSubnets() {
        return this.localSubnets;
    }

    public List<IpAddressListElement> getRemoteSubnets() {
        return this.remoteSubnets;
    }
}

