/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.api.client.users.AuthCertificate;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.usermanager.Activator;
import org.netxms.ui.eclipse.usermanager.Messages;
import org.netxms.ui.eclipse.usermanager.dialogs.CreateNewCertificateDialog;
import org.netxms.ui.eclipse.usermanager.dialogs.EditCertificateDialog;
import org.netxms.ui.eclipse.usermanager.views.helpers.CertificateComparator;
import org.netxms.ui.eclipse.usermanager.views.helpers.CertificateLabelProvider;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class CertificateView
extends ViewPart
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.usermanager.view.user_certificate";
    private static final String TABLE_CONFIG_PREFIX = "CertificatesEditor";
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_COMMENTS = 2;
    public static final int COLUMN_SUBJECT = 3;
    private Map<Long, AuthCertificate> certificates = new HashMap<Long, AuthCertificate>();
    private SortableTableViewer viewer;
    private NXCSession session;
    private Action actionRefresh;
    private Action actionNew;
    private Action actionEdit;
    private Action actionDelete;

    public void createPartControl(Composite parent) {
        this.session = (NXCSession)ConsoleSharedData.getSession();
        parent.setLayout((Layout)new FillLayout());
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.CertificateView_ID;
        Messages.get();
        stringArray[1] = Messages.CertificateView_Type;
        Messages.get();
        stringArray[2] = Messages.CertificateView_Comments;
        Messages.get();
        stringArray[3] = Messages.CertificateView_Subject;
        String[] columnNames = stringArray;
        int[] columnWidths = new int[]{30, 100, 200, 200};
        this.viewer = new SortableTableViewer(parent, columnNames, columnWidths, 0, 128, 65538);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new CertificateLabelProvider());
        this.viewer.setComparator((ViewerComparator)new CertificateComparator());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    CertificateView.this.actionEdit.setEnabled(selection.size() == 1);
                    CertificateView.this.actionDelete.setEnabled(selection.size() > 0);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CertificateView.this.actionEdit.run();
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)CertificateView.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)CertificateView.TABLE_CONFIG_PREFIX);
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.session.addListener((SessionListener)this);
        this.refreshCertificateList();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                CertificateView.this.refreshCertificateList();
            }
        };
        Messages.get();
        this.actionNew = new Action(Messages.CertificateView_CreateNewCertif){

            public void run() {
                CertificateView.this.createCertificate();
            }
        };
        this.actionNew.setImageDescriptor(SharedIcons.ADD_OBJECT);
        Messages.get();
        this.actionEdit = new Action(Messages.CertificateView_EditCertifData){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)CertificateView.this.viewer.getSelection();
                if (selection.size() != 1) {
                    return;
                }
                long certId = ((AuthCertificate)selection.getFirstElement()).getId();
                AuthCertificate cert = (AuthCertificate)CertificateView.this.certificates.get(certId);
                if (cert != null) {
                    CertificateView.this.saveCertificate(cert);
                }
            }
        };
        this.actionEdit.setImageDescriptor(SharedIcons.EDIT);
        Messages.get();
        this.actionDelete = new Action(Messages.CertificateView_DeleteCertif){

            public void run() {
                CertificateView.this.deleteCertificate();
            }
        };
        this.actionDelete.setImageDescriptor(SharedIcons.DELETE_OBJECT);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionEdit);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionEdit);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                CertificateView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionNew);
        mgr.add((IAction)this.actionDelete);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IContributionItem)new GroupMarker("additions"));
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionEdit);
    }

    private void refreshCertificateList() {
        Messages.get();
        new ConsoleJob(Messages.CertificateView_RefreshCertif, (IWorkbenchPart)this, "org.netxms.ui.eclipse.usermanager", "org.netxms.ui.eclipse.usermanager"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List cl = CertificateView.this.session.getCertificateList();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        CertificateView.this.certificates.clear();
                        for (AuthCertificate c : cl) {
                            CertificateView.this.certificates.put(c.getId(), c);
                        }
                        CertificateView.this.viewer.setInput((Object)CertificateView.this.certificates.values().toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.CertificateView_ErrorUnableGetCertifList;
            }
        }.start();
    }

    private void createCertificate() {
        final CreateNewCertificateDialog dlg = new CreateNewCertificateDialog(this.getSite().getShell());
        if (dlg.open() == 0) {
            Messages.get();
            new ConsoleJob(Messages.CertificateView_CreateNewCertif, (IWorkbenchPart)this, "org.netxms.ui.eclipse.usermanager", "org.netxms.ui.eclipse.usermanager"){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    String comment = dlg.getComment();
                    byte[] data = dlg.getFileContent();
                    if (data == null) {
                        Messages.get();
                        throw new Exception(Messages.CertificateView_ErrorIncorrectCertifFile);
                    }
                    CertificateView.this.session.createNewCertificate(data, comment);
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.CertificateView_ErrorNewCertifCreation;
                }
            }.start();
        }
    }

    private void deleteCertificate() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        if (!MessageDialogHelper.openConfirm((Shell)shell, (String)Messages.CertificateView_Confirmation, (String)Messages.CertificateView_AckDeleteCertif)) {
            return;
        }
        final Object[] objects = selection.toArray();
        Messages.get();
        new ConsoleJob(Messages.CertificateView_DeleteCertif, (IWorkbenchPart)this, "org.netxms.ui.eclipse.usermanager", "org.netxms.ui.eclipse.usermanager"){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.CertificateView_ErrorDeleteCert;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int i = 0;
                while (i < objects.length) {
                    CertificateView.this.session.deleteCertificate(((AuthCertificate)objects[i]).getId());
                    ++i;
                }
            }
        }.start();
    }

    private void saveCertificate(final AuthCertificate cert) {
        final EditCertificateDialog dlg = new EditCertificateDialog(this.getSite().getShell(), cert);
        if (dlg.open() == 0) {
            Messages.get();
            new ConsoleJob(Messages.CertificateView_SaveCertif, (IWorkbenchPart)this, "org.netxms.ui.eclipse.usermanager", "org.netxms.ui.eclipse.usermanager"){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    CertificateView.this.session.updateCertificate(cert.getId(), dlg.getComments());
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.CertificateView_ErrorSaveCertif;
                }
            }.schedule();
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void notificationHandler(SessionNotification n) {
        if (n.getCode() == 1023) {
            this.refreshCertificateList();
        }
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        super.dispose();
    }
}

