/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.dialogs;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.dashboard.Activator;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.dialogs.helpers.DciIdMatchingData;
import org.netxms.ui.eclipse.dashboard.dialogs.helpers.IdMatchingContentProvider;
import org.netxms.ui.eclipse.dashboard.dialogs.helpers.IdMatchingLabelProvider;
import org.netxms.ui.eclipse.dashboard.dialogs.helpers.ObjectIdMatchingData;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectNodeDciDialog;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.SortableTreeViewer;

public class IdMatchingDialog
extends Dialog {
    public static final int COLUMN_SOURCE_ID = 0;
    public static final int COLUMN_SOURCE_NAME = 1;
    public static final int COLUMN_DESTINATION_ID = 2;
    public static final int COLUMN_DESTINATION_NAME = 3;
    private SortableTreeViewer viewer;
    private Map<Long, ObjectIdMatchingData> objects;
    private Map<Long, DciIdMatchingData> dcis;
    private Action actionMap;

    public IdMatchingDialog(Shell parentShell, Map<Long, ObjectIdMatchingData> objects, Map<Long, DciIdMatchingData> dcis) {
        super(parentShell);
        this.objects = objects;
        this.dcis = dcis;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.IdMatchingDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 64);
        Messages.get();
        label.setText(Messages.IdMatchingDialog_HelpText);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 0;
        label.setLayoutData((Object)gd);
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.IdMatchingDialog_ColumnOriginalID;
        Messages.get();
        stringArray[1] = Messages.IdMatchingDialog_ColumnName;
        Messages.get();
        stringArray[2] = Messages.IdMatchingDialog_ColumnMatchID;
        Messages.get();
        stringArray[3] = Messages.IdMatchingDialog_ColumnMatchName;
        String[] names = stringArray;
        int[] widths = new int[]{100, 300, 80, 300};
        this.viewer = new SortableTreeViewer(dialogArea, names, widths, 0, 128, 67588);
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.getTree().setHeaderVisible(true);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 400;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new IdMatchingContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new IdMatchingLabelProvider());
        this.viewer.setInput((Object)new Object[]{this.objects, this.dcis});
        this.viewer.expandAll();
        this.createActions();
        this.createPopupMenu();
        return dialogArea;
    }

    private void createActions() {
        Messages.get();
        this.actionMap = new Action(Messages.IdMatchingDialog_MapTo, Activator.getImageDescriptor("icons/sync.gif")){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)IdMatchingDialog.this.viewer.getSelection();
                if (selection.size() != 1) {
                    return;
                }
                Object element = selection.getFirstElement();
                if (element instanceof ObjectIdMatchingData) {
                    IdMatchingDialog.this.mapNode((ObjectIdMatchingData)element);
                }
                if (element instanceof DciIdMatchingData) {
                    IdMatchingDialog.this.mapDci((DciIdMatchingData)element);
                }
            }
        };
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                IdMatchingDialog.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionMap);
    }

    private void mapNode(ObjectIdMatchingData data) {
        HashSet<Integer> classFilter;
        switch (data.objectClass) {
            case 2: {
                classFilter = ObjectSelectionDialog.createNodeSelectionFilter((boolean)false);
                break;
            }
            case 5: {
                classFilter = ObjectSelectionDialog.createContainerSelectionFilter();
                break;
            }
            case 6: {
                classFilter = ObjectSelectionDialog.createZoneSelectionFilter();
                break;
            }
            case 23: {
                classFilter = new HashSet<Integer>(2);
                classFilter.add(23);
                classFilter.add(22);
                break;
            }
            default: {
                classFilter = null;
            }
        }
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell(), null, classFilter);
        if (dlg.open() == 0) {
            AbstractObject object = (AbstractObject)dlg.getSelectedObjects().get(0);
            if (object.getObjectClass() == data.objectClass) {
                data.dstId = object.getObjectId();
                data.dstName = object.getObjectName();
                this.updateDciMapping(data);
                this.viewer.update((Object)data, null);
            } else {
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openWarning((Shell)shell, (String)Messages.IdMatchingDialog_Warning, (String)Messages.IdMatchingDialog_ClassMismatch);
            }
        }
    }

    private void updateDciMapping(final ObjectIdMatchingData objData) {
        if (objData.dcis.size() == 0) {
            return;
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.IdMatchingDialog_JobTitle, null, "org.netxms.ui.eclipse.dashboard", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final DciValue[] dciValues = session.getLastValues(objData.dstId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        block0: for (DciIdMatchingData d : objData.dcis) {
                            d.dstNodeId = objData.dstId;
                            d.dstDciId = 0L;
                            d.dstName = null;
                            DciValue[] dciValueArray = dciValues;
                            int n = dciValues.length;
                            int n2 = 0;
                            while (n2 < n) {
                                DciValue v = dciValueArray[n2];
                                if (v.getDescription().equalsIgnoreCase(d.srcName)) {
                                    d.dstDciId = v.getId();
                                    d.dstName = v.getDescription();
                                    continue block0;
                                }
                                ++n2;
                            }
                        }
                        IdMatchingDialog.this.viewer.refresh(true);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.IdMatchingDialog_JobErrorText;
            }
        }.start();
    }

    private void mapDci(DciIdMatchingData data) {
        DciValue v;
        if (data.dstNodeId == 0L) {
            return;
        }
        SelectNodeDciDialog dlg = new SelectNodeDciDialog(this.getShell(), data.dstNodeId);
        if (dlg.open() == 0 && (v = dlg.getSelection()) != null) {
            data.dstDciId = v.getId();
            data.dstName = v.getDescription();
            this.viewer.update((Object)data, null);
        }
    }

    protected void okPressed() {
        boolean ok = true;
        for (ObjectIdMatchingData o : this.objects.values()) {
            if (o.dstId != 0L) continue;
            ok = false;
            break;
        }
        for (DciIdMatchingData d : this.dcis.values()) {
            if (d.dstNodeId != 0L && d.dstDciId != 0L) continue;
            ok = false;
            break;
        }
        if (!ok) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            if (!MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.IdMatchingDialog_MatchingErrors, (String)Messages.IdMatchingDialog_ConfirmationText)) {
                return;
            }
        }
        super.okPressed();
    }
}

