/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.dialogs;

import java.net.InetAddress;
import java.util.HashSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.ui.eclipse.objectbrowser.Messages;
import org.netxms.ui.eclipse.objectbrowser.widgets.internal.AddressListLabelProvider;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class IPAddressSelectionDialog
extends Dialog {
    private AbstractNode node;
    private TableViewer viewer;
    private InetAddress address;

    public IPAddressSelectionDialog(Shell parentShell, AbstractNode node) {
        super(parentShell);
        this.node = node;
    }

    protected void configureShell(Shell newShell) {
        Messages.get();
        newShell.setText(Messages.IPAddressSelectionDialog_Title);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.viewer = new TableViewer(dialogArea, 67584);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 300;
        gd.widthHint = 250;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator(new ViewerComparator(){

            private long addrAsLong(InetAddress addrObject) {
                byte[] addr = addrObject.getAddress();
                return (long)(addr[0] & 0xFF) << 24 | (long)(addr[1] & 0xFF) << 16 | (long)(addr[2] & 0xFF) << 8 | (long)(addr[3] & 0xFF);
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                return Long.signum(this.addrAsLong(((Interface)e1).getPrimaryIP()) - this.addrAsLong(((Interface)e2).getPrimaryIP()));
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new AddressListLabelProvider());
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        TableColumn tc = new TableColumn(table, 16384);
        Messages.get();
        tc.setText(Messages.IPAddressSelectionDialog_IPAddress);
        tc.setWidth(90);
        tc = new TableColumn(table, 16384);
        Messages.get();
        tc.setText(Messages.IPAddressSelectionDialog_Interface);
        tc.setWidth(150);
        HashSet<AbstractObject> addrList = new HashSet<AbstractObject>();
        AbstractObject[] abstractObjectArray = this.node.getChildsAsArray();
        int n = abstractObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            InetAddress addr;
            AbstractObject o = abstractObjectArray[n2];
            if (o instanceof Interface && !(addr = o.getPrimaryIP()).isAnyLocalAddress() && !addr.isLinkLocalAddress() && !addr.isLoopbackAddress()) {
                addrList.add(o);
            }
            ++n2;
        }
        this.viewer.setInput((Object)addrList.toArray());
        return dialogArea;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.IPAddressSelectionDialog_Warning, (String)Messages.IPAddressSelectionDialog_WarningText);
            return;
        }
        this.address = ((Interface)selection.getFirstElement()).getPrimaryIP();
        super.okPressed();
    }

    public InetAddress getAddress() {
        return this.address;
    }
}

