/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ThresholdLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String[] FUNCTIONS = new String[]{"last(", "average(", "deviation(", "diff()", "error(", "sum(", "script("};
    private static final String[] OPERATIONS = new String[]{"<", "<=", "==", ">=", ">", "!=", "like", "!like"};
    private WorkbenchLabelProvider eventLabelProvider = new WorkbenchLabelProvider();
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();
    private Image thresholdIcon = Activator.getImageDescriptor("icons/threshold.png").createImage();

    public Image getColumnImage(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.thresholdIcon;
            }
            case 1: {
                EventTemplate event = this.session.findEventTemplateByCode((long)((Threshold)element).getFireEvent());
                return StatusDisplayInfo.getStatusImage((Severity)(event != null ? event.getSeverity() : Severity.UNKNOWN));
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                int f = ((Threshold)element).getFunction();
                StringBuilder text = new StringBuilder(FUNCTIONS[f]);
                if (f != 3) {
                    text.append(((Threshold)element).getSampleCount());
                    text.append(") ");
                } else {
                    text.append(' ');
                }
                if (f != 6) {
                    text.append(OPERATIONS[((Threshold)element).getOperation()]);
                    text.append(' ');
                    text.append(((Threshold)element).getValue());
                }
                return text.toString();
            }
            case 1: {
                EventTemplate event = this.session.findEventTemplateByCode((long)((Threshold)element).getFireEvent());
                return this.eventLabelProvider.getText((Object)event);
            }
        }
        return null;
    }

    public void dispose() {
        this.eventLabelProvider.dispose();
        this.thresholdIcon.dispose();
        super.dispose();
    }
}

