/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.views.helpers;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.ServerFile;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;

public class ServerFileLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private WorkbenchLabelProvider wbLabelProvider = new WorkbenchLabelProvider();

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getText(element);
            }
            case 1: {
                return ((ServerFile)element).getExtension();
            }
            case 2: {
                return ((ServerFile)element).isDirectory() || ((ServerFile)element).isPlaceholder() ? "" : Long.toString(((ServerFile)element).getSize());
            }
            case 3: {
                return ((ServerFile)element).isPlaceholder() || ((ServerFile)element).getModifyicationTime().getTime() == 0L ? "" : RegionalSettings.getDateTimeFormat().format(((ServerFile)element).getModifyicationTime());
            }
        }
        return null;
    }

    public Image getImage(Object element) {
        return this.wbLabelProvider.getImage(element);
    }

    public String getText(Object element) {
        return this.wbLabelProvider.getText(element);
    }

    public void dispose() {
        this.wbLabelProvider.dispose();
        super.dispose();
    }

    public Color getForeground(Object element) {
        if (((ServerFile)element).isPlaceholder()) {
            return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.DISABLED);
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

