/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Dashboard;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardModifyListener;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.IntermediateSelectionProvider;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class DashboardView
extends ViewPart
implements ISaveablePart {
    public static final String ID = "org.netxms.ui.eclipse.dashboard.views.DashboardView";
    private NXCSession session;
    private Dashboard dashboard;
    private boolean readOnly = true;
    private IntermediateSelectionProvider selectionProvider;
    private DashboardControl dbc;
    private Composite parentComposite;
    private DashboardModifyListener dbcModifyListener;
    private RefreshAction actionRefresh;
    private Action actionEditMode;
    private Action actionSave;
    private Action actionAddAlarmBrowser;
    private Action actionAddLabel;
    private Action actionAddBarChart;
    private Action actionAddPieChart;
    private Action actionAddTubeChart;
    private Action actionAddLineChart;
    private Action actionAddAvailabilityChart;
    private Action actionAddDashboard;
    private Action actionAddStatusIndicator;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.dashboard = (Dashboard)this.session.findObjectById(Long.parseLong(site.getSecondaryId()));
        if (this.dashboard == null) {
            Messages.get();
            throw new PartInitException(Messages.DashboardView_InitError);
        }
        Messages.get();
        this.setPartName(String.valueOf(Messages.DashboardView_PartNamePrefix) + this.dashboard.getObjectName());
    }

    public void createPartControl(Composite parent) {
        this.selectionProvider = new IntermediateSelectionProvider();
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.DashboardView_GetEffectiveRights, (IWorkbenchPart)this, "org.netxms.ui.eclipse.dashboard", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                DashboardView.this.readOnly = (DashboardView.this.dashboard.getEffectiveRights() & 2) == 0;
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.DashboardView_GetEffectiveRightsError;
            }
        };
        job.start();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
        this.parentComposite = parent;
        this.dbc = new DashboardControl(parent, 0, this.dashboard, (IViewPart)this, this.selectionProvider, false);
        if (!this.readOnly) {
            this.dbcModifyListener = new DashboardModifyListener(){

                @Override
                public void save() {
                    DashboardView.this.actionSave.setEnabled(false);
                    DashboardView.this.firePropertyChange(257);
                }

                @Override
                public void modify() {
                    DashboardView.this.actionSave.setEnabled(true);
                    DashboardView.this.firePropertyChange(257);
                }
            };
            this.dbc.setModifyListener(this.dbcModifyListener);
        }
        this.createActions();
        this.contributeToActionBars();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                if (DashboardView.this.dbc.isModified()) {
                    Shell shell = DashboardView.this.getSite().getShell();
                    Messages.get();
                    Messages.get();
                    if (!MessageDialogHelper.openConfirm((Shell)shell, (String)Messages.DashboardView_Refresh, (String)Messages.DashboardView_Confirmation)) {
                        return;
                    }
                }
                DashboardView.this.rebuildDashboard(true);
            }
        };
        Messages.get();
        this.actionSave = new Action(Messages.DashboardView_Save){

            public void run() {
                DashboardView.this.dbc.saveDashboard((IViewPart)DashboardView.this);
            }
        };
        this.actionSave.setImageDescriptor(SharedIcons.SAVE);
        this.actionSave.setEnabled(false);
        Messages.get();
        this.actionEditMode = new Action(Messages.DashboardView_EditMode, 2){

            public void run() {
                DashboardView.this.dbc.setEditMode(!DashboardView.this.dbc.isEditMode());
                DashboardView.this.actionEditMode.setChecked(DashboardView.this.dbc.isEditMode());
                if (!DashboardView.this.dbc.isEditMode()) {
                    DashboardView.this.rebuildDashboard(false);
                }
            }
        };
        this.actionEditMode.setImageDescriptor(SharedIcons.EDIT);
        this.actionEditMode.setChecked(this.dbc.isEditMode());
        Messages.get();
        this.actionAddAlarmBrowser = new Action(Messages.DashboardView_AddAlarmBrowser){

            public void run() {
                DashboardView.this.dbc.addAlarmBrowser();
            }
        };
        Messages.get();
        this.actionAddLabel = new Action(Messages.DashboardView_AddLabel){

            public void run() {
                DashboardView.this.dbc.addLabel();
            }
        };
        Messages.get();
        this.actionAddBarChart = new Action(Messages.DashboardView_AddBarChart){

            public void run() {
                DashboardView.this.dbc.addBarChart();
            }
        };
        Messages.get();
        this.actionAddPieChart = new Action(Messages.DashboardView_AddPieChart){

            public void run() {
                DashboardView.this.dbc.addPieChart();
            }
        };
        Messages.get();
        this.actionAddTubeChart = new Action(Messages.DashboardView_AddTubeChart){

            public void run() {
                DashboardView.this.dbc.addTubeChart();
            }
        };
        Messages.get();
        this.actionAddLineChart = new Action(Messages.DashboardView_AddLineChart){

            public void run() {
                DashboardView.this.dbc.addLineChart();
            }
        };
        Messages.get();
        this.actionAddAvailabilityChart = new Action(Messages.DashboardView_AddAvailChart){

            public void run() {
                DashboardView.this.dbc.addAvailabilityChart();
            }
        };
        Messages.get();
        this.actionAddDashboard = new Action(Messages.DashboardView_AddDashboard){

            public void run() {
                DashboardView.this.dbc.addEmbeddedDashboard();
            }
        };
        Messages.get();
        this.actionAddStatusIndicator = new Action(Messages.DashboardView_AddStatusIndicator){

            public void run() {
                DashboardView.this.dbc.addStatusIndicator();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        if (!this.readOnly) {
            manager.add((IAction)this.actionEditMode);
            manager.add((IAction)this.actionSave);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionAddAlarmBrowser);
            manager.add((IAction)this.actionAddLabel);
            manager.add((IAction)this.actionAddLineChart);
            manager.add((IAction)this.actionAddBarChart);
            manager.add((IAction)this.actionAddPieChart);
            manager.add((IAction)this.actionAddTubeChart);
            manager.add((IAction)this.actionAddStatusIndicator);
            manager.add((IAction)this.actionAddAvailabilityChart);
            manager.add((IAction)this.actionAddDashboard);
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        if (!this.readOnly) {
            manager.add((IAction)this.actionEditMode);
            manager.add((IAction)this.actionSave);
        }
        manager.add((IAction)this.actionRefresh);
    }

    public void setFocus() {
        this.dbc.setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
        this.dbc.saveDashboard((IViewPart)this);
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.dbc.isModified() && !this.readOnly;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.dbc.isModified() && !this.readOnly;
    }

    private void rebuildDashboard(boolean reload) {
        if (this.dashboard == null) {
            return;
        }
        if (this.dbc != null) {
            this.dbc.dispose();
        }
        if (reload) {
            this.dashboard = (Dashboard)((NXCSession)ConsoleSharedData.getSession()).findObjectById(this.dashboard.getObjectId(), Dashboard.class);
            if (this.dashboard != null) {
                this.dbc = new DashboardControl(this.parentComposite, 0, this.dashboard, (IViewPart)this, this.selectionProvider, false);
                this.parentComposite.layout(true, true);
                Messages.get();
                this.setPartName(String.valueOf(Messages.DashboardView_PartNamePrefix) + this.dashboard.getObjectName());
                if (!this.readOnly) {
                    this.dbc.setModifyListener(this.dbcModifyListener);
                }
            } else {
                this.dbc = null;
            }
        } else {
            this.dbc = new DashboardControl(this.parentComposite, 0, this.dashboard, this.dbc.getElements(), (IViewPart)this, this.selectionProvider, this.dbc.isModified());
            this.parentComposite.layout(true, true);
            if (!this.readOnly) {
                this.dbc.setModifyListener(this.dbcModifyListener);
            }
        }
        this.actionSave.setEnabled(this.dbc != null ? this.dbc.isModified() : false);
        this.firePropertyChange(257);
    }
}

