/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.widgets;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.base.GeoLocation;
import org.netxms.client.NXCSession;
import org.netxms.client.TimePeriod;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.osm.Activator;
import org.netxms.ui.eclipse.osm.GeoLocationCache;
import org.netxms.ui.eclipse.osm.GeoLocationCacheListener;
import org.netxms.ui.eclipse.osm.Messages;
import org.netxms.ui.eclipse.osm.tools.Area;
import org.netxms.ui.eclipse.osm.tools.MapAccessor;
import org.netxms.ui.eclipse.osm.tools.MapLoader;
import org.netxms.ui.eclipse.osm.tools.QuadTree;
import org.netxms.ui.eclipse.osm.tools.Tile;
import org.netxms.ui.eclipse.osm.tools.TileSet;
import org.netxms.ui.eclipse.osm.widgets.helpers.GeoMapListener;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class GeoMapViewer
extends Canvas
implements PaintListener,
GeoLocationCacheListener,
MouseWheelListener,
MouseListener,
MouseMoveListener {
    private static final int START = 1;
    private static final int END = 2;
    private static final String[] pointInformation;
    private static final Color MAP_BACKGROUND;
    private static final Color INFO_BLOCK_BACKGROUND;
    private static final Color INFO_BLOCK_TEXT;
    private static final Color LABEL_BACKGROUND;
    private static final Color LABEL_TEXT;
    private static final Color BORDER_COLOR;
    private static final Color SELECTION_COLOR;
    private static final Color TRACK_COLOR;
    private static final Font TITLE_FONT;
    private static final int LABEL_ARROW_HEIGHT = 20;
    private static final int LABEL_ARROW_OFFSET = 10;
    private static final int LABEL_X_MARGIN = 4;
    private static final int LABEL_Y_MARGIN = 4;
    private static final int LABEL_SPACING = 4;
    private static final int DRAG_JITTER = 8;
    private ILabelProvider labelProvider;
    private Image currentImage = null;
    private Image bufferImage = null;
    private Area coverage = new Area(0.0, 0.0, 0.0, 0.0);
    private List<AbstractObject> objects = new ArrayList<AbstractObject>();
    private MapAccessor accessor;
    private MapLoader mapLoader;
    private IViewPart viewPart = null;
    private Point currentPoint;
    private Point dragStartPoint = null;
    private Point selectionStartPoint = null;
    private Point selectionEndPoint = null;
    private Set<GeoMapListener> mapListeners = new HashSet<GeoMapListener>(0);
    private String title = null;
    private int offsetX;
    private int offsetY;
    private TileSet currentTileSet = null;
    private Image imageZoomIn;
    private Image imageZoomOut;
    private Rectangle zoomControlRect = null;
    private boolean historicalData;
    private List<GeoLocation> history = new ArrayList<GeoLocation>();
    private QuadTree<GeoLocation> locationTree = new QuadTree();
    private AbstractObject historyObject = null;
    private TimePeriod timePeriod = new TimePeriod();
    private int highlightobjectID = -1;
    private ToolTip toolTip;

    static {
        String[] stringArray = new String[2];
        Messages.get();
        stringArray[0] = Messages.GeoMapViewer_Start;
        Messages.get();
        stringArray[1] = Messages.GeoMapViewer_End;
        pointInformation = stringArray;
        MAP_BACKGROUND = new Color((Device)Display.getCurrent(), 255, 255, 255);
        INFO_BLOCK_BACKGROUND = new Color((Device)Display.getCurrent(), 0, 0, 0);
        INFO_BLOCK_TEXT = new Color((Device)Display.getCurrent(), 255, 255, 255);
        LABEL_BACKGROUND = new Color((Device)Display.getCurrent(), 240, 254, 192);
        LABEL_TEXT = new Color((Device)Display.getCurrent(), 0, 0, 0);
        BORDER_COLOR = new Color((Device)Display.getCurrent(), 128, 128, 128);
        SELECTION_COLOR = new Color((Device)Display.getCurrent(), 0, 0, 255);
        TRACK_COLOR = new Color((Device)Display.getCurrent(), 163, 73, 164);
        TITLE_FONT = new Font((Device)Display.getCurrent(), "Verdana", 10, 1);
    }

    public GeoMapViewer(Composite parent, int style, final boolean historicalData, AbstractObject historyObject) {
        super(parent, style | 0x40000 | 0x20000000);
        this.historicalData = historicalData;
        if (historicalData) {
            this.historyObject = historyObject;
        }
        this.imageZoomIn = Activator.getImageDescriptor("icons/map_zoom_in.png").createImage();
        this.imageZoomOut = Activator.getImageDescriptor("icons/map_zoom_out.png").createImage();
        this.labelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
        this.mapLoader = new MapLoader(this.getDisplay());
        this.setBackground(MAP_BACKGROUND);
        this.addPaintListener(this);
        final Runnable timer = new Runnable(){

            @Override
            public void run() {
                if (GeoMapViewer.this.isDisposed()) {
                    return;
                }
                GeoMapViewer.this.reloadMap();
            }
        };
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                GeoMapViewer.this.getDisplay().timerExec(-1, timer);
                GeoMapViewer.this.getDisplay().timerExec(1000, timer);
                if (GeoMapViewer.this.bufferImage != null) {
                    GeoMapViewer.this.bufferImage.dispose();
                }
                Rectangle rect = GeoMapViewer.this.getClientArea();
                GeoMapViewer.this.bufferImage = new Image((Device)GeoMapViewer.this.getDisplay(), rect.width, rect.height);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GeoMapViewer.this.labelProvider.dispose();
                GeoLocationCache.getInstance().removeListener(GeoMapViewer.this);
                if (GeoMapViewer.this.bufferImage != null) {
                    GeoMapViewer.this.bufferImage.dispose();
                }
                if (GeoMapViewer.this.currentImage != null) {
                    GeoMapViewer.this.currentImage.dispose();
                }
                GeoMapViewer.this.mapLoader.dispose();
                GeoMapViewer.this.imageZoomIn.dispose();
                GeoMapViewer.this.imageZoomOut.dispose();
            }
        });
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addMouseWheelListener(this);
        GeoLocationCache.getInstance().addListener(this);
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                GeoMapViewer.this.highlightobjectID = -1;
                GeoMapViewer.this.toolTip.setVisible(false);
                if (!historicalData) {
                    return;
                }
                Point p = new Point(e.x, e.y);
                p.x -= 5;
                p.y -= 5;
                GeoLocation loc1 = GeoMapViewer.this.getLocationAtPoint(p);
                p.x += 10;
                p.y += 10;
                GeoLocation loc2 = GeoMapViewer.this.getLocationAtPoint(p);
                Area area = new Area(loc1.getLatitude(), loc1.getLongitude(), loc2.getLatitude(), loc2.getLongitude());
                List suitablePoints = GeoMapViewer.this.locationTree.query(area);
                if (suitablePoints.size() == 0) {
                    return;
                }
                int i = 0;
                if (suitablePoints.size() > 1) {
                    double minDistance = 100.0;
                    int j = 0;
                    while (j < suitablePoints.size()) {
                        double newDistance = Math.pow(Math.pow(((GeoLocation)suitablePoints.get(j)).getLatitude() - loc1.getLatitude(), 2.0) + Math.pow(((GeoLocation)suitablePoints.get(j)).getLongitude() - loc1.getLongitude(), 2.0), 0.5);
                        if (minDistance > newDistance) {
                            minDistance = newDistance;
                            i = j;
                        }
                        ++j;
                    }
                }
                GeoMapViewer.this.highlightobjectID = GeoMapViewer.this.history.indexOf(suitablePoints.get(i));
                GeoMapViewer.this.redraw();
            }

            public void mouseExit(MouseEvent e) {
                GeoMapViewer.this.highlightobjectID = -1;
                GeoMapViewer.this.toolTip.setVisible(false);
                GeoMapViewer.this.redraw();
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (GeoMapViewer.this.highlightobjectID != -1) {
                    GeoMapViewer.this.highlightobjectID = -1;
                    GeoMapViewer.this.toolTip.setVisible(false);
                    GeoMapViewer.this.redraw();
                }
            }
        });
        this.toolTip = new ToolTip(this.getShell(), 4096);
    }

    public void addMapListener(GeoMapListener listener) {
        this.mapListeners.add(listener);
    }

    public void removeMapListener(GeoMapListener listener) {
        this.mapListeners.remove(listener);
    }

    private void notifyOnZoomChange() {
        for (GeoMapListener listener : this.mapListeners) {
            listener.onZoom(this.accessor.getZoom());
        }
    }

    private void notifyOnPositionChange() {
        for (GeoMapListener listener : this.mapListeners) {
            listener.onPan(this.accessor.getCenterPoint());
        }
    }

    public void showMap(MapAccessor accessor) {
        this.accessor = new MapAccessor(accessor);
        this.reloadMap();
    }

    public void showMap(double lat, double lon, int zoom) {
        this.showMap(new MapAccessor(lat, lon, zoom));
    }

    private void reloadMap() {
        Rectangle rect = this.getClientArea();
        this.accessor.setMapWidth(rect.width);
        this.accessor.setMapHeight(rect.height);
        if (this.currentImage != null) {
            this.currentImage.dispose();
        }
        this.currentImage = null;
        if (!this.accessor.isValid()) {
            return;
        }
        final Point mapSize = new Point(this.accessor.getMapWidth(), this.accessor.getMapHeight());
        final GeoLocation centerPoint = this.accessor.getCenterPoint();
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.GeoMapViewer_DownloadJob_Title, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.osm", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final TileSet tiles = GeoMapViewer.this.mapLoader.getAllTiles(mapSize, centerPoint, 0, GeoMapViewer.this.accessor.getZoom(), true);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        GeoMapViewer.this.currentTileSet = null;
                        if (tiles != null) {
                            GeoMapViewer.this.drawTiles(tiles);
                            if (tiles.missingTiles > 0) {
                                GeoMapViewer.this.currentTileSet = tiles;
                                GeoMapViewer.this.loadMissingTiles(tiles);
                            } else {
                                tiles.dispose();
                            }
                        }
                        Point mapSize = new Point(((GeoMapViewer)(this).GeoMapViewer.this).currentImage.getImageData().width, ((GeoMapViewer)(this).GeoMapViewer.this).currentImage.getImageData().height);
                        GeoMapViewer.this.coverage = GeoLocationCache.calculateCoverage(mapSize, GeoMapViewer.this.accessor.getCenterPoint(), 0, GeoMapViewer.this.accessor.getZoom());
                        if (!GeoMapViewer.this.historicalData) {
                            GeoMapViewer.this.objects = GeoLocationCache.getInstance().getObjectsInArea(GeoMapViewer.this.coverage);
                            GeoMapViewer.this.redraw();
                        } else {
                            GeoMapViewer.this.updateHistory();
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.GeoMapViewer_DownloadError;
            }
        };
        job.setUser(false);
        job.start();
    }

    private void loadMissingTiles(final TileSet tiles) {
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.GeoMapViewer_LoadMissingJob_Title, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.osm", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                GeoMapViewer.this.mapLoader.loadMissingTiles(tiles, new Runnable(){

                    @Override
                    public void run() {
                        if (!GeoMapViewer.this.isDisposed() && GeoMapViewer.this.currentTileSet == tiles) {
                            GeoMapViewer.this.drawTiles(tiles);
                            GeoMapViewer.this.redraw();
                        }
                        tiles.dispose();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.GeoMapViewer_DownloadError;
            }
        };
        job.setUser(false);
        job.start();
    }

    private void drawTiles(TileSet tileSet) {
        if (this.currentImage != null) {
            this.currentImage.dispose();
        }
        if (tileSet == null || tileSet.tiles == null || tileSet.tiles.length == 0) {
            this.currentImage = null;
            return;
        }
        Tile[][] tiles = tileSet.tiles;
        Point size = this.getSize();
        this.currentImage = new Image((Device)this.getDisplay(), size.x, size.y);
        GC gc = new GC((Drawable)this.currentImage);
        int x = tileSet.xOffset;
        int y = tileSet.yOffset;
        int i = 0;
        while (i < tiles.length) {
            int j = 0;
            while (j < tiles[i].length) {
                gc.drawImage(tiles[i][j].getImage(), x, y);
                if ((x += 256) >= size.x) {
                    x = tileSet.xOffset;
                    y += 256;
                }
                ++j;
            }
            ++i;
        }
        gc.dispose();
    }

    public void paintControl(PaintEvent e) {
        GeoLocation currentLocation;
        GC gc = new GC((Drawable)this.bufferImage);
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        if (this.dragStartPoint == null) {
            int imgH;
            int imgW;
            currentLocation = this.accessor.getCenterPoint();
            if (this.currentImage != null) {
                gc.drawImage(this.currentImage, -this.offsetX, -this.offsetY);
                imgW = this.currentImage.getImageData().width;
                imgH = this.currentImage.getImageData().height;
            } else {
                imgW = -1;
                imgH = -1;
            }
            Point centerXY = GeoLocationCache.coordinateToDisplay(currentLocation, this.accessor.getZoom());
            if (!this.historicalData) {
                for (AbstractObject object : this.objects) {
                    Point virtualXY = GeoLocationCache.coordinateToDisplay(object.getGeolocation(), this.accessor.getZoom());
                    int dx = virtualXY.x - centerXY.x;
                    int dy = virtualXY.y - centerXY.y;
                    this.drawObject(gc, imgW / 2 + dx, imgH / 2 + dy, object);
                }
            } else {
                int nextX = 0;
                int nextY = 0;
                int i = 0;
                while (i < this.history.size()) {
                    Point virtualXY = GeoLocationCache.coordinateToDisplay(this.history.get(i), this.accessor.getZoom());
                    int dx = virtualXY.x - centerXY.x;
                    int dy = virtualXY.y - centerXY.y;
                    if (i != this.history.size() - 1) {
                        Point virtualXY2 = GeoLocationCache.coordinateToDisplay(this.history.get(i + 1), this.accessor.getZoom());
                        nextX = imgW / 2 + (virtualXY2.x - centerXY.x);
                        nextY = imgH / 2 + (virtualXY2.y - centerXY.y);
                    }
                    int color = 3;
                    if (i == this.highlightobjectID) {
                        color = 5;
                        DateFormat df = RegionalSettings.getDateTimeFormat();
                        this.toolTip.setText(String.format("%s\r\n%s - %s", this.history.get(i), df.format(this.history.get(i).getTimestamp()), df.format(this.history.get(i).getEndTimestamp())));
                        this.toolTip.setVisible(true);
                    }
                    if (i == 0) {
                        if (i == this.history.size() - 1) {
                            nextX = imgW / 2 + dx;
                            nextY = imgH / 2 + dy;
                        }
                        this.drawObject(gc, imgW / 2 + dx, imgH / 2 + dy, 1, nextX, nextY, color);
                    } else if (i == this.history.size() - 1) {
                        this.drawObject(gc, imgW / 2 + dx, imgH / 2 + dy, 2, nextX, nextY, color);
                    } else {
                        this.drawObject(gc, imgW / 2 + dx, imgH / 2 + dy, 0, nextX, nextY, color);
                    }
                    ++i;
                }
            }
        } else {
            Point cp = GeoLocationCache.coordinateToDisplay(this.accessor.getCenterPoint(), this.accessor.getZoom());
            cp.x += this.offsetX;
            cp.y += this.offsetY;
            currentLocation = GeoLocationCache.displayToCoordinates(cp, this.accessor.getZoom());
            Point size = this.getSize();
            TileSet tileSet = this.mapLoader.getAllTiles(size, currentLocation, 0, this.accessor.getZoom(), true);
            int x = tileSet.xOffset;
            int y = tileSet.yOffset;
            Tile[][] tiles = tileSet.tiles;
            int i = 0;
            while (i < tiles.length) {
                int j = 0;
                while (j < tiles[i].length) {
                    gc.drawImage(tiles[i][j].getImage(), x, y);
                    if ((x += 256) >= size.x) {
                        x = tileSet.xOffset;
                        y += 256;
                    }
                    ++j;
                }
                ++i;
            }
            tileSet.dispose();
        }
        if (this.selectionStartPoint != null && this.selectionEndPoint != null) {
            int x = Math.min(this.selectionStartPoint.x, this.selectionEndPoint.x);
            int y = Math.min(this.selectionStartPoint.y, this.selectionEndPoint.y);
            int w = Math.abs(this.selectionStartPoint.x - this.selectionEndPoint.x);
            int h = Math.abs(this.selectionStartPoint.y - this.selectionEndPoint.y);
            gc.setBackground(SELECTION_COLOR);
            gc.setForeground(SELECTION_COLOR);
            gc.setAlpha(64);
            gc.fillRectangle(x, y, w, h);
            gc.setAlpha(255);
            gc.setLineWidth(2);
            gc.drawRectangle(x, y, w, h);
        }
        String text = currentLocation.toString();
        Point textSize = gc.textExtent(text);
        Rectangle rect = this.getClientArea();
        rect.x = rect.width - textSize.x - 20;
        rect.y += 10;
        rect.width = textSize.x + 10;
        rect.height = textSize.y + 8;
        gc.setBackground(INFO_BLOCK_BACKGROUND);
        gc.setAlpha(128);
        gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
        gc.setAlpha(255);
        gc.setForeground(INFO_BLOCK_TEXT);
        gc.drawText(text, rect.x + 5, rect.y + 4, true);
        if (this.title != null && !this.title.isEmpty()) {
            gc.setFont(TITLE_FONT);
            rect = this.getClientArea();
            int x = (rect.width - gc.textExtent((String)this.title).x) / 2;
            gc.setForeground(SharedColors.getColor((String)"GeoMap.Title", (Display)this.getDisplay()));
            gc.drawText(this.title, x, 10, true);
        }
        gc.setFont(JFaceResources.getHeaderFont());
        text = Integer.toString(this.accessor.getZoom());
        textSize = gc.textExtent(text);
        rect = this.getClientArea();
        rect.x = 10;
        rect.y = 10;
        rect.width = 80;
        rect.height = 47 + textSize.y;
        gc.setBackground(INFO_BLOCK_BACKGROUND);
        gc.setAlpha(128);
        gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
        gc.setAlpha(255);
        gc.drawText(text, rect.x + rect.width / 2 - textSize.x / 2, rect.y + 5, true);
        gc.drawImage(this.imageZoomIn, rect.x + 5, rect.y + rect.height - 37);
        gc.drawImage(this.imageZoomOut, rect.x + 42, rect.y + rect.height - 37);
        this.zoomControlRect = rect;
        gc.dispose();
        e.gc.drawImage(this.bufferImage, 0, 0);
    }

    private void drawObject(GC gc, int x, int y, AbstractObject object) {
        String text = object.getObjectName();
        Point textSize = gc.textExtent(text);
        Image image = this.labelProvider.getImage((Object)object);
        if (image == null) {
            image = SharedIcons.IMG_UNKNOWN_OBJECT;
        }
        Rectangle rect = new Rectangle(x - 10, y - 20 - textSize.y, textSize.x + image.getImageData().width + 8 + 4, Math.max(image.getImageData().height, textSize.y) + 8);
        gc.setBackground(LABEL_BACKGROUND);
        gc.setForeground(BORDER_COLOR);
        gc.setLineWidth(4);
        gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
        gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
        gc.setForeground(StatusDisplayInfo.getStatusColor((ObjectStatus)object.getStatus()));
        gc.setLineWidth(2);
        gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
        gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
        int[] arrow = new int[]{rect.x + 10 - 4, rect.y + rect.height, x, y, rect.x + 10 + 4, rect.y + rect.height};
        gc.setLineWidth(4);
        gc.setForeground(BORDER_COLOR);
        gc.drawPolyline(arrow);
        gc.fillPolygon(arrow);
        gc.setForeground(LABEL_BACKGROUND);
        gc.setLineWidth(2);
        gc.drawLine(arrow[0], arrow[1], arrow[4], arrow[5]);
        gc.setForeground(StatusDisplayInfo.getStatusColor((ObjectStatus)object.getStatus()));
        gc.drawPolyline(arrow);
        gc.setForeground(LABEL_TEXT);
        gc.drawImage(image, rect.x + 4, rect.y + 4);
        gc.drawText(text, rect.x + 4 + image.getImageData().width + 4, rect.y + 4);
    }

    private void drawObject(GC gc, int x, int y, int flag, int prevX, int prevY, int color) {
        if (flag == 1 || flag == 2) {
            if (flag == 1) {
                gc.setForeground(TRACK_COLOR);
                gc.setLineWidth(3);
                gc.drawLine(x, y, prevX, prevY);
            }
            gc.setBackground(Display.getCurrent().getSystemColor(color));
            gc.fillOval(x - 5, y - 5, 10, 10);
            String text = pointInformation[flag - 1];
            Point textSize = gc.textExtent(text);
            Rectangle rect = new Rectangle(x - 10, y - 20 - textSize.y, textSize.x + 8 + 4, textSize.y + 8);
            gc.setBackground(LABEL_BACKGROUND);
            gc.setForeground(BORDER_COLOR);
            gc.setLineWidth(4);
            gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
            gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
            gc.setLineWidth(2);
            gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
            gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
            int[] arrow = new int[]{rect.x + 10 - 4, rect.y + rect.height, x, y, rect.x + 10 + 4, rect.y + rect.height};
            gc.setLineWidth(4);
            gc.setForeground(BORDER_COLOR);
            gc.drawPolyline(arrow);
            gc.fillPolygon(arrow);
            gc.setForeground(LABEL_BACKGROUND);
            gc.setLineWidth(2);
            gc.drawLine(arrow[0], arrow[1], arrow[4], arrow[5]);
            gc.drawPolyline(arrow);
            gc.setForeground(LABEL_TEXT);
            gc.drawText(text, rect.x + 4 + 4, rect.y + 4);
        } else {
            gc.setForeground(TRACK_COLOR);
            gc.setLineWidth(3);
            gc.drawLine(x, y, prevX, prevY);
            gc.setBackground(Display.getCurrent().getSystemColor(color));
            gc.fillOval(x - 5, y - 5, 10, 10);
        }
    }

    @Override
    public void geoLocationCacheChanged(final AbstractObject object, final GeoLocation prevLocation) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!GeoMapViewer.this.historicalData) {
                    GeoMapViewer.this.onCacheChange(object, prevLocation);
                } else if (object.getObjectId() == GeoMapViewer.this.historyObject.getObjectId()) {
                    GeoMapViewer.this.onCacheChange(object, prevLocation);
                }
            }
        });
    }

    private void onCacheChange(AbstractObject object, GeoLocation prevLocation) {
        GeoLocation currLocation = object.getGeolocation();
        if (currLocation.getType() != 0 && this.coverage.contains(currLocation.getLatitude(), currLocation.getLongitude()) || prevLocation != null && prevLocation.getType() != 0 && this.coverage.contains(prevLocation.getLatitude(), prevLocation.getLongitude())) {
            if (!this.historicalData) {
                this.objects = GeoLocationCache.getInstance().getObjectsInArea(this.coverage);
                this.redraw();
            } else {
                this.updateHistory();
            }
        }
    }

    public void mouseScrolled(MouseEvent event) {
        int zoom = this.accessor.getZoom();
        if (event.count > 0) {
            if (zoom < 18) {
                ++zoom;
            }
        } else if (zoom > 1) {
            --zoom;
        }
        if (zoom != this.accessor.getZoom()) {
            this.accessor.setZoom(zoom);
            this.reloadMap();
            this.notifyOnZoomChange();
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 1) {
            if (this.zoomControlRect.contains(e.x, e.y)) {
                Rectangle r = new Rectangle(this.zoomControlRect.x + 5, this.zoomControlRect.y + this.zoomControlRect.height - 37, 32, 32);
                int zoom = this.accessor.getZoom();
                if (r.contains(e.x, e.y)) {
                    if (zoom < 18) {
                        ++zoom;
                    }
                } else {
                    r.x += 37;
                    if (r.contains(e.x, e.y) && zoom > 1) {
                        --zoom;
                    }
                }
                if (zoom != this.accessor.getZoom()) {
                    this.accessor.setZoom(zoom);
                    this.reloadMap();
                    this.notifyOnZoomChange();
                }
            } else if ((e.stateMask & 0x20000) != 0) {
                if (this.accessor.getZoom() < 18) {
                    this.selectionStartPoint = new Point(e.x, e.y);
                }
            } else {
                this.dragStartPoint = new Point(e.x, e.y);
                this.setCursor(this.getDisplay().getSystemCursor(5));
            }
        }
        this.currentPoint = new Point(e.x, e.y);
    }

    public void mouseUp(MouseEvent e) {
        if (e.button == 1 && this.dragStartPoint != null) {
            if (Math.abs(this.offsetX) > 8 || Math.abs(this.offsetY) > 8) {
                Point centerXY = GeoLocationCache.coordinateToDisplay(this.accessor.getCenterPoint(), this.accessor.getZoom());
                centerXY.x += this.offsetX;
                centerXY.y += this.offsetY;
                GeoLocation geoLocation = GeoLocationCache.displayToCoordinates(centerXY, this.accessor.getZoom());
                this.accessor.setLatitude(geoLocation.getLatitude());
                this.accessor.setLongitude(geoLocation.getLongitude());
                this.reloadMap();
                this.notifyOnPositionChange();
            }
            this.offsetX = 0;
            this.offsetY = 0;
            this.dragStartPoint = null;
            this.setCursor(null);
        }
        if (e.button == 1 && this.selectionStartPoint != null) {
            if (this.selectionEndPoint != null) {
                int x1 = Math.min(this.selectionStartPoint.x, this.selectionEndPoint.x);
                int x2 = Math.max(this.selectionStartPoint.x, this.selectionEndPoint.x);
                int y1 = Math.min(this.selectionStartPoint.y, this.selectionEndPoint.y);
                int y2 = Math.max(this.selectionStartPoint.y, this.selectionEndPoint.y);
                GeoLocation l1 = this.getLocationAtPoint(new Point(x1, y1));
                GeoLocation l2 = this.getLocationAtPoint(new Point(x2, y2));
                GeoLocation lc = this.getLocationAtPoint(new Point(x2 - (x2 - x1) / 2, y2 - (y2 - y1) / 2));
                int zoom = this.accessor.getZoom();
                while (zoom < 18) {
                    Area area = GeoLocationCache.calculateCoverage(this.getSize(), lc, 0, ++zoom);
                    if (area.contains(l1.getLatitude(), l1.getLongitude()) && area.contains(l2.getLatitude(), l2.getLongitude())) continue;
                    --zoom;
                    break;
                }
                if (zoom != this.accessor.getZoom()) {
                    this.accessor.setZoom(zoom);
                    this.accessor.setLatitude(lc.getLatitude());
                    this.accessor.setLongitude(lc.getLongitude());
                    this.reloadMap();
                    this.notifyOnPositionChange();
                    this.notifyOnZoomChange();
                }
            }
            this.selectionStartPoint = null;
            this.selectionEndPoint = null;
            this.redraw();
        }
    }

    public void mouseMove(MouseEvent e) {
        int deltaY;
        int deltaX;
        if (this.dragStartPoint != null) {
            deltaX = this.dragStartPoint.x - e.x;
            deltaY = this.dragStartPoint.y - e.y;
            if (Math.abs(deltaX) > 8 || Math.abs(deltaY) > 8) {
                this.offsetX = deltaX;
                this.offsetY = deltaY;
                this.redraw();
            }
        }
        if (this.selectionStartPoint != null) {
            deltaX = this.selectionStartPoint.x - e.x;
            deltaY = this.selectionStartPoint.y - e.y;
            if (Math.abs(deltaX) > 8 || Math.abs(deltaY) > 8) {
                this.selectionEndPoint = new Point(e.x, e.y);
                this.redraw();
            }
        }
    }

    public Point getCurrentPoint() {
        return this.currentPoint;
    }

    public GeoLocation getLocationAtPoint(Point p) {
        Point cp = GeoLocationCache.coordinateToDisplay(new GeoLocation(this.coverage.getxHigh(), this.coverage.getyLow()), this.accessor.getZoom());
        return GeoLocationCache.displayToCoordinates(new Point(cp.x + p.x, cp.y + p.y), this.accessor.getZoom());
    }

    public IViewPart getViewPart() {
        return this.viewPart;
    }

    public void setViewPart(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private void updateHistory() {
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.GeoMapViewer_DownloadJob_Title, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.osm", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                GeoMapViewer.this.history = session.getLocationHistory(GeoMapViewer.this.historyObject.getObjectId(), GeoMapViewer.this.timePeriod.getPeriodStart(), GeoMapViewer.this.timePeriod.getPeriodEnd());
                int i = 0;
                while (i < GeoMapViewer.this.history.size()) {
                    GeoMapViewer.this.locationTree.insert(((GeoLocation)GeoMapViewer.this.history.get(i)).getLatitude(), ((GeoLocation)GeoMapViewer.this.history.get(i)).getLongitude(), (GeoLocation)GeoMapViewer.this.history.get(i));
                    ++i;
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        GeoMapViewer.this.redraw();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.GeoMapViewer_DownloadError;
            }
        };
        job.setUser(false);
        job.start();
    }

    public void setTimePeriod(TimePeriod timePeriod) {
        this.timePeriod = timePeriod;
        this.updateHistory();
    }

    public TimePeriod getTimePeriod() {
        return this.timePeriod;
    }

    public void changeTimePeriod(int value, int unit) {
        this.timePeriod.setTimeFrameType(1);
        this.timePeriod.setTimeRangeValue(value);
        this.timePeriod.setTimeUnitValue(unit);
        this.updateHistory();
    }
}

