/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.topology;

import org.netxms.base.NXCPMessage;
import org.netxms.client.topology.Port;

public class VlanInfo {
    private int vlanId;
    private String name;
    private Port[] ports;

    public VlanInfo(NXCPMessage msg, long baseId) {
        this.vlanId = msg.getFieldAsInt32(baseId);
        this.name = msg.getFieldAsString(baseId + 1L);
        int count2 = msg.getFieldAsInt32(baseId + 2L);
        this.ports = new Port[count2];
        long[] sps = msg.getFieldAsUInt32Array(baseId + 3L);
        long[] indexes = msg.getFieldAsUInt32Array(baseId + 4L);
        long[] ids = msg.getFieldAsUInt32Array(baseId + 5L);
        for (int i = 0; i < count2; ++i) {
            this.ports[i] = new Port(ids[i], indexes[i], (int)(sps[i] >> 16), (int)(sps[i] & 0xFFFFL));
        }
    }

    public int getVlanId() {
        return this.vlanId;
    }

    public String getName() {
        return this.name;
    }

    public Port[] getPorts() {
        return this.ports;
    }
}

