/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.snmp;

import java.util.Arrays;
import org.netxms.base.NXCPMessage;
import org.netxms.client.snmp.SnmpObjectIdFormatException;

public class SnmpObjectId {
    private long[] value;

    public SnmpObjectId() {
        this.value = new long[0];
    }

    public SnmpObjectId(long[] value) {
        this.value = Arrays.copyOf(value, value.length);
    }

    public SnmpObjectId(SnmpObjectId parent, long id) {
        this.value = parent != null ? Arrays.copyOf(parent.value, parent.value.length + 1) : new long[1];
        this.value[this.value.length - 1] = id;
    }

    public static SnmpObjectId parseSnmpObjectId(String s) throws SnmpObjectIdFormatException {
        String st = s.trim();
        if (st.isEmpty()) {
            return new SnmpObjectId();
        }
        if (st.charAt(0) != '.') {
            throw new SnmpObjectIdFormatException("OID shoud start with . character");
        }
        String[] parts = st.split("\\.");
        if (parts.length == 0) {
            throw new SnmpObjectIdFormatException("Empty OID element");
        }
        long[] value = new long[parts.length - 1];
        for (int i = 1; i < parts.length; ++i) {
            String p = parts[i].trim();
            if (p.isEmpty()) {
                throw new SnmpObjectIdFormatException("Empty OID element");
            }
            try {
                value[i - 1] = Long.parseLong(p);
                continue;
            }
            catch (NumberFormatException e) {
                throw new SnmpObjectIdFormatException("OID element #" + i + " is not a whole number");
            }
        }
        return new SnmpObjectId(value);
    }

    public int getLength() {
        return this.value.length;
    }

    public void setNXCPVariable(NXCPMessage msg, long varId) {
        msg.setField(varId, this.value);
    }

    public boolean startsWith(SnmpObjectId oid) {
        if (oid.value.length > this.value.length) {
            return false;
        }
        for (int i = 0; i < oid.value.length; ++i) {
            if (oid.value[i] == this.value[i]) continue;
            return false;
        }
        return true;
    }

    public int compareTo(SnmpObjectId oid) {
        int maxLen = Math.min(this.value.length, oid.value.length);
        for (int i = 0; i < maxLen; ++i) {
            if (this.value[i] == oid.value[i]) continue;
            return Long.signum(this.value[i] - oid.value[i]);
        }
        return Integer.signum(this.value.length - oid.value.length);
    }

    public long getIdFromPos(int pos) {
        return pos >= 0 && pos < this.value.length ? this.value[pos] : -1L;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SnmpObjectId)) {
            return false;
        }
        return Arrays.equals(this.value, ((SnmpObjectId)obj).value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.value.length * 3);
        for (int i = 0; i < this.value.length; ++i) {
            sb.append('.');
            sb.append(this.value[i]);
        }
        return sb.toString();
    }
}

