/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxLoStat;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxOutputStream;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxTmpFile;
import com.informix.util.IfxErrMsg;
import com.informix.util.memoryUtil;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import netscape.security.PrivilegeManager;

abstract class IfxLob {
    protected static final short TYPE_IS_BLOB = 2;
    protected static final short TYPE_IS_CLOB = 3;
    protected static final short MODE_READ_WRITE = 0;
    protected static final short MODE_RW_BUFF = 1;
    protected static final short MODE_CLIENT_ONLY = 2;
    protected IfxSmartBlob smb;
    protected IfxLocator locatorPointer;
    protected IfxConnection conn;
    protected boolean isBlob_loaded;
    protected IfxTmpFile tempBlobFile;
    protected InputStream blobStream;
    protected byte[] blobBuffer;
    protected String BlobFileName;
    protected long blobSize;
    protected short ifxType;
    protected int smartBlobMode;

    protected IfxLob() {
        this.smb = null;
        this.locatorPointer = null;
        this.conn = null;
        this.isBlob_loaded = false;
        this.tempBlobFile = null;
        this.blobStream = null;
        this.blobBuffer = null;
        this.blobSize = 0L;
        this.smartBlobMode = 0;
    }

    protected IfxLob(Connection connection, InputStream inputStream, int n) throws SQLException {
        this.smb = null;
        this.locatorPointer = null;
        this.conn = null;
        this.isBlob_loaded = false;
        this.tempBlobFile = null;
        this.blobStream = null;
        this.blobBuffer = null;
        this.blobSize = 0L;
        this.smartBlobMode = 0;
        this.conn = (IfxConnection)connection;
        IfxLobDescriptor ifxLobDescriptor = new IfxLobDescriptor(connection);
        this.a(inputStream, n, ifxLobDescriptor);
    }

    protected IfxLob(Connection connection, InputStream inputStream, int n, String string) throws SQLException {
        this.smb = null;
        this.locatorPointer = null;
        this.conn = null;
        this.isBlob_loaded = false;
        this.tempBlobFile = null;
        this.blobStream = null;
        this.blobBuffer = null;
        this.blobSize = 0L;
        this.smartBlobMode = 0;
        this.conn = (IfxConnection)connection;
        IfxLobDescriptor ifxLobDescriptor = new IfxLobDescriptor(connection);
        ifxLobDescriptor.setSbspace(string);
        this.a(inputStream, n, ifxLobDescriptor);
    }

    protected IfxLob(Connection connection, InputStream inputStream, int n, IfxLobDescriptor ifxLobDescriptor) throws SQLException {
        this.smb = null;
        this.locatorPointer = null;
        this.conn = null;
        this.isBlob_loaded = false;
        this.tempBlobFile = null;
        this.blobStream = null;
        this.blobBuffer = null;
        this.blobSize = 0L;
        this.smartBlobMode = 0;
        this.conn = (IfxConnection)connection;
        this.a(inputStream, n, ifxLobDescriptor);
    }

    protected IfxLob(Connection connection, byte[] byArray) throws SQLException {
        int n;
        block3: {
            block2: {
                this.smb = null;
                this.locatorPointer = null;
                this.conn = null;
                this.isBlob_loaded = false;
                this.tempBlobFile = null;
                this.blobStream = null;
                this.blobBuffer = null;
                this.blobSize = 0L;
                this.smartBlobMode = 0;
                this.conn = (IfxConnection)connection;
                if (byArray != null) break block2;
                n = 0;
                if (IfxStatement.t == 0) break block3;
            }
            n = byArray.length;
        }
        IfxLobDescriptor ifxLobDescriptor = new IfxLobDescriptor(connection);
        this.a(byArray, n, ifxLobDescriptor);
    }

    protected IfxLob(Connection connection, byte[] byArray, String string) throws SQLException {
        int n;
        block3: {
            block2: {
                this.smb = null;
                this.locatorPointer = null;
                this.conn = null;
                this.isBlob_loaded = false;
                this.tempBlobFile = null;
                this.blobStream = null;
                this.blobBuffer = null;
                this.blobSize = 0L;
                this.smartBlobMode = 0;
                this.conn = (IfxConnection)connection;
                if (byArray != null) break block2;
                n = 0;
                if (IfxStatement.t == 0) break block3;
            }
            n = byArray.length;
        }
        IfxLobDescriptor ifxLobDescriptor = new IfxLobDescriptor(connection);
        ifxLobDescriptor.setSbspace(string);
        this.a(byArray, n, ifxLobDescriptor);
    }

    protected IfxLob(Connection connection, byte[] byArray, IfxLobDescriptor ifxLobDescriptor) throws SQLException {
        int n;
        block3: {
            block2: {
                this.smb = null;
                this.locatorPointer = null;
                this.conn = null;
                this.isBlob_loaded = false;
                this.tempBlobFile = null;
                this.blobStream = null;
                this.blobBuffer = null;
                this.blobSize = 0L;
                this.smartBlobMode = 0;
                this.conn = (IfxConnection)connection;
                if (byArray != null) break block2;
                n = 0;
                if (IfxStatement.t == 0) break block3;
            }
            n = byArray.length;
        }
        this.a(byArray, n, ifxLobDescriptor);
    }

    private void a(InputStream inputStream, int n, IfxLobDescriptor ifxLobDescriptor) throws SQLException {
        try {
            this.locatorPointer = new IfxLocator(this.conn);
            this.smb = new IfxSmartBlob(this.conn);
            this.smb.IfxLoCreate(ifxLobDescriptor, 8, this.locatorPointer);
            if (n > 0) {
                this.smb.IfxLoWrite(this.smb.getHandle(), inputStream, n);
            }
            this.blobSize = this.smb.IfxLoSize(this.smb.getHandle());
        }
        catch (SQLException sQLException) {
            this.smb = null;
            throw sQLException;
        }
    }

    private void a(byte[] byArray, int n, IfxLobDescriptor ifxLobDescriptor) throws SQLException {
        try {
            this.locatorPointer = new IfxLocator(this.conn);
            this.smb = new IfxSmartBlob(this.conn);
            this.smb.IfxLoCreate(ifxLobDescriptor, 8, this.locatorPointer);
            if (n > 0) {
                this.smb.IfxLoWrite(this.smb.getHandle(), byArray);
            }
            this.blobSize = this.smb.IfxLoSize(this.smb.getHandle());
        }
        catch (SQLException sQLException) {
            this.smb = null;
            throw sQLException;
        }
    }

    public IfxLocator getLocator() throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb == null) {
            return this.locatorPointer;
        }
        return this.smb.locator;
    }

    protected void setLocator(IfxLocator ifxLocator) throws SQLException {
        block5: {
            block4: {
                if (this.ifxType != 3 && this.ifxType != 2) {
                    throw IfxErrMsg.getSQLException(-79787, this.conn);
                }
                if (this.smb == null) break block4;
                this.smb.locator = ifxLocator;
                if (IfxStatement.t == 0) break block5;
            }
            this.locatorPointer = ifxLocator;
        }
    }

    protected void setIfxLobType(short s) {
        this.ifxType = s;
    }

    protected void setSize(long l) {
        this.blobSize = l;
    }

    protected void setConnection(IfxConnection ifxConnection) {
        this.conn = ifxConnection;
    }

    protected void setLoadFlag() {
        this.isBlob_loaded = true;
    }

    protected short getIfxLobType() {
        return this.ifxType;
    }

    protected void setMode(int n) {
        this.smartBlobMode = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] getPortion(long l, long l2) {
        int n;
        long l3;
        int n2;
        block21: {
            block20: {
                n2 = IfxStatement.t;
                if (l < 1L || l2 < 0L) {
                    return null;
                }
                if (l2 == 0L) {
                    return new byte[0];
                }
                try {
                    if (!this.isBlob_loaded) {
                        this.loadSmBlob();
                    }
                }
                catch (Exception exception) {
                    return null;
                }
                if (l > this.blobSize) {
                    return null;
                }
                l3 = l - 1L;
                if (l3 + l2 <= this.blobSize) break block20;
                n = (int)(this.blobSize - l3);
                if (n2 == 0) break block21;
            }
            n = (int)l2;
        }
        byte[] byArray = new byte[n];
        if (this.tempBlobFile != null) {
            IfxInputStream ifxInputStream;
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                ifxInputStream = this.tempBlobFile.b();
            }
            catch (Exception exception) {
                return null;
            }
            try {
                if (l3 > 0L) {
                    ifxInputStream.skip(l3);
                }
                ifxInputStream.read(byArray, 0, n);
                ((FileInputStream)ifxInputStream).close();
                if (this.ifxType != 3 && this.ifxType != 2) return byArray;
                this.isBlob_loaded = false;
                this.tempBlobFile.close();
                this.tempBlobFile = null;
                return byArray;
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (this.blobBuffer == null) return null;
        System.arraycopy(this.blobBuffer, (int)l3, byArray, 0, n);
        if (this.ifxType != 3 && this.ifxType != 2) return byArray;
        this.blobBuffer = null;
        this.isBlob_loaded = false;
        if (n2 == 0) return byArray;
        return null;
    }

    protected InputStream getStreamImd() throws SQLException {
        if (!this.isBlob_loaded) {
            this.loadSmBlob();
        }
        return this.getStream();
    }

    protected InputStream getStream() throws SQLException {
        if (!this.isBlob_loaded) {
            try {
                IfxLobInputStream ifxLobInputStream = new IfxLobInputStream(this.conn, this.getLocator());
                return ifxLobInputStream;
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
        }
        if (this.tempBlobFile != null) {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                IfxInputStream ifxInputStream = this.tempBlobFile.b();
                return ifxInputStream;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, this.conn);
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.blobBuffer);
        return byteArrayInputStream;
    }

    protected void setStream(InputStream inputStream, int n) throws SQLException {
        if (n > 0) {
            this.smb.IfxLoWrite(this.smb.getHandle(), inputStream, n);
        }
        this.blobSize = this.smb.IfxLoSize(this.smb.getHandle());
    }

    protected int setBuffer(byte[] byArray) throws SQLException {
        return this.setBuffer(byArray, 0, byArray == null ? 0 : byArray.length);
    }

    protected int setBuffer(byte[] byArray, int n, int n2) throws SQLException {
        int n3 = 0;
        if (byArray.length > 0 && n2 > 0) {
            n3 = this.smb.IfxLoWrite(this.smb.getHandle(), byArray, n, n2);
            this.blobSize = this.smb.IfxLoSize(this.smb.getHandle());
        }
        return n3;
    }

    public long seek(long l, int n) throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb != null) {
            return this.smb.IfxLoSeek(this.smb.getHandle(), l, n);
        }
        throw IfxErrMsg.getSQLException(-79814, this.conn);
    }

    public long where() throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb != null) {
            return this.smb.IfxLoTell(this.smb.getHandle());
        }
        throw IfxErrMsg.getSQLException(-79814, this.conn);
    }

    public IfxLoStat getLoStat() throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb != null) {
            return this.smb.IfxLoGetStat(this.smb.getHandle());
        }
        throw IfxErrMsg.getSQLException(-79814, this.conn);
    }

    public void truncate(long l) throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb != null) {
            this.smb.IfxLoTruncate(this.smb.getHandle(), l);
        }
    }

    public void close() throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb != null && this.smb.getHandle() != -1) {
            this.smb.IfxLoClose(this.smb.getHandle());
        }
        this.smb = null;
    }

    protected void loadSmBlob() throws SQLException {
        block15: {
            IfxOutputStream ifxOutputStream;
            int n;
            block17: {
                int n2;
                block16: {
                    n = IfxStatement.t;
                    ifxOutputStream = null;
                    this.tempBlobFile = null;
                    this.blobBuffer = null;
                    this.blobSize = this.smb.IfxLoSize(this.smb.getHandle());
                    if (this.blobSize == 0L) {
                        this.blobBuffer = new byte[0];
                        this.tempBlobFile = null;
                        return;
                    }
                    n2 = this.conn.getBlobCacheSize();
                    if (n2 >= 0 && (n2 <= 0 || this.blobSize > (long)n2)) break block16;
                    try {
                        this.blobBuffer = memoryUtil.allocateMemory((int)this.blobSize, this.conn);
                    }
                    catch (Exception exception) {
                        throw IfxErrMsg.getSQLException(-79753, this.conn);
                    }
                    this.tempBlobFile = null;
                    if (n == 0) break block17;
                }
                if (System.getProperty("java.vendor").startsWith("Netscape")) {
                    try {
                        PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    this.tempBlobFile = new IfxTmpFile(this.conn);
                    ifxOutputStream = this.tempBlobFile.c();
                    this.blobBuffer = null;
                }
                catch (Exception exception) {
                    if (n2 == 0) {
                        throw IfxErrMsg.getSQLException(-79774, this.conn);
                    }
                    this.blobBuffer = memoryUtil.allocateMemory((int)this.blobSize, this.conn);
                    ifxOutputStream = null;
                    this.tempBlobFile = null;
                }
            }
            try {
                if (this.blobBuffer == null) {
                    this.smb.IfxLoSeek(this.smb.getHandle(), 0L, 0);
                    this.smb.IfxLoRead(this.smb.getHandle(), ifxOutputStream, (int)this.blobSize);
                    ((FileOutputStream)ifxOutputStream).close();
                    if (n == 0) break block15;
                }
                this.smb.IfxLoSeek(this.smb.getHandle(), 0L, 0);
                this.smb.IfxLoRead(this.smb.getHandle(), this.blobBuffer, (int)this.blobSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isBlob_loaded = true;
    }

    protected void verifySmbMode() throws SQLException {
        if (this.smb == null || this.smb.getHandle() == -1) {
            if (this.smartBlobMode != 0) {
                throw IfxErrMsg.getSQLException(-79814, this.conn);
            }
            this.smb = new IfxSmartBlob(this.conn);
            this.smb.IfxLoOpen(this.locatorPointer, 8);
        }
    }
}

