/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.tabulator;

import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.tabulator.DimensionControl;
import net.sf.jasperreports.engine.export.tabulator.DimensionEntry;
import net.sf.jasperreports.engine.export.tabulator.DimensionRange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DimensionEntries<T extends DimensionEntry> {
    private static final Log log = LogFactory.getLog(DimensionEntries.class);
    private DimensionControl<T> control;
    private TreeSet<T> entries;

    public DimensionEntries(DimensionControl<T> control) {
        this.control = control;
        this.entries = new TreeSet();
        DimensionEntry univEntry = (DimensionEntry)control.createEntry(-33554432, 2098200576);
        this.entries.add(univEntry);
    }

    public String toString() {
        return "DimensionEntries " + this.logId();
    }

    protected String logId() {
        return Integer.toHexString(this.hashCode());
    }

    public DimensionRange<T> getRange(int start, int end) {
        DimensionEntry endKey;
        if (start > end) {
            throw new IllegalArgumentException(start + " > " + end);
        }
        if (start <= -33554432) {
            throw new JRRuntimeException("Out of range start value " + start);
        }
        if (end >= 2098200576) {
            throw new JRRuntimeException("Out of range start value " + end);
        }
        DimensionEntry startKey = (DimensionEntry)this.control.entryKey(start);
        DimensionEntry floor = this.entries.floor(startKey);
        assert (floor != null);
        NavigableSet<DimensionEntry> tailSet = this.entries.tailSet(floor, true);
        DimensionEntry ceiling = tailSet.ceiling(endKey = (DimensionEntry)this.control.entryKey(end));
        NavigableSet<DimensionEntry> rangeSet = ceiling == null ? tailSet : tailSet.headSet(ceiling, false);
        return new DimensionRange<DimensionEntry>(start, end, floor, ceiling, rangeSet);
    }

    public DimensionRange<T> addEntries(DimensionRange<T> range) {
        T resultStart = this.addStartEntry(range);
        assert (resultStart != null && ((DimensionEntry)resultStart).startCoord == range.start);
        T resultEnd = this.addEndEntry(range);
        assert (resultEnd != null && ((DimensionEntry)resultEnd).startCoord == range.end);
        if (((DimensionEntry)resultStart).startCoord == ((DimensionEntry)range.floor).startCoord && range.ceiling != null && ((DimensionEntry)resultEnd).startCoord == ((DimensionEntry)range.ceiling).startCoord) {
            return range;
        }
        NavigableSet resultRange = range.rangeSet.subSet(resultStart, true, resultEnd, false);
        return new DimensionRange<T>(range.start, range.end, resultStart, resultEnd, resultRange);
    }

    protected T addStartEntry(DimensionRange<T> range) {
        DimensionEntry resultStart;
        if (((DimensionEntry)range.floor).startCoord < range.start) {
            int entryEnd;
            DimensionEntry splitEntry = null;
            if (((DimensionEntry)range.floor).endCoord > range.start) {
                splitEntry = (DimensionEntry)range.floor;
                entryEnd = splitEntry.endCoord;
            } else {
                assert (range.floor == this.entries.last());
                if (((DimensionEntry)range.floor).endCoord < range.start) {
                    this.addEntry(((DimensionEntry)range.floor).endCoord, range.start, null);
                }
                entryEnd = range.end;
            }
            resultStart = this.addEntry(range.start, entryEnd, splitEntry);
        } else {
            resultStart = (DimensionEntry)range.floor;
        }
        return (T)resultStart;
    }

    protected T addEndEntry(DimensionRange<T> range) {
        DimensionEntry resultEnd;
        if (range.ceiling != null && ((DimensionEntry)range.ceiling).startCoord == range.end) {
            resultEnd = (DimensionEntry)range.ceiling;
        } else {
            DimensionEntry last = (DimensionEntry)range.rangeSet.last();
            assert (last != null);
            if (range.ceiling == null) {
                assert (last.endCoord > range.end);
                resultEnd = this.addEntry(range.end, last.endCoord, last);
            } else {
                resultEnd = this.addEntry(range.end, ((DimensionEntry)range.ceiling).startCoord, last);
            }
        }
        return (T)resultEnd;
    }

    protected T addEntry(int startCoord) {
        DimensionEntry entryKey = (DimensionEntry)this.control.entryKey(startCoord);
        DimensionEntry floorEntry = this.entries.floor(entryKey);
        assert (floorEntry != null);
        DimensionEntry startEntry = floorEntry.startCoord == startCoord ? floorEntry : this.addEntry(startCoord, floorEntry.endCoord, floorEntry);
        return (T)startEntry;
    }

    protected T addEntry(int startCoord, int endCoord) {
        assert (startCoord < endCoord);
        DimensionEntry entryKey = (DimensionEntry)this.control.entryKey(startCoord);
        DimensionEntry floorEntry = this.entries.floor(entryKey);
        assert (floorEntry != null);
        assert (endCoord <= floorEntry.endCoord);
        DimensionEntry startEntry = floorEntry.startCoord == startCoord ? floorEntry : this.addEntry(startCoord, floorEntry.endCoord, floorEntry);
        if (endCoord < startEntry.endCoord) {
            this.addEntry(endCoord, startEntry.endCoord, startEntry);
        }
        return (T)startEntry;
    }

    protected T addEntry(int startCoord, int endCoord, T splitEntry) {
        assert (startCoord < endCoord);
        DimensionEntry entry = (DimensionEntry)this.control.createEntry(startCoord, endCoord);
        boolean added = this.entries.add(entry);
        assert (added);
        if (splitEntry == null) {
            assert (entry == this.entries.first() && (this.entries.size() == 1 || endCoord == this.entries.higher(entry).startCoord) || entry == this.entries.last() && (this.entries.size() == 1 || startCoord == this.entries.lower(entry).endCoord));
        } else {
            assert (((DimensionEntry)splitEntry).startCoord < startCoord);
            assert (((DimensionEntry)splitEntry).endCoord == endCoord);
            ((DimensionEntry)splitEntry).endCoord = startCoord;
            this.control.entrySplit((DimensionEntry)splitEntry, entry);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)(this.logId() + ": added entry " + entry + ", split " + splitEntry));
        }
        return (T)entry;
    }

    public void addMargins(int extent) {
        DimensionEntry firstEntry;
        if (log.isTraceEnabled()) {
            log.trace((Object)("add margins to extent " + extent));
        }
        int marginStart = (firstEntry = (DimensionEntry)this.entries.higher(this.entries.first())) == null || firstEntry.startCoord > 0 ? 0 : firstEntry.startCoord;
        DimensionEntry lastEntry = (DimensionEntry)this.entries.lower(this.entries.last());
        int marginEnd = lastEntry == null || lastEntry.endCoord < extent ? extent : lastEntry.endCoord;
        DimensionRange<T> range = this.getRange(marginStart, marginEnd);
        this.addEntries(range);
    }

    public void removeEntry(T entry, T prevEntry) {
        assert (((DimensionEntry)prevEntry).endCoord == ((DimensionEntry)entry).startCoord);
        boolean removed = this.entries.remove(entry);
        assert (removed);
        ((DimensionEntry)prevEntry).endCoord = ((DimensionEntry)entry).endCoord;
        if (log.isTraceEnabled()) {
            log.trace((Object)(this.logId() + ": removed entry at " + ((DimensionEntry)entry).startCoord));
        }
    }

    public NavigableSet<T> getEntries() {
        return this.entries;
    }

    public SortedSet<T> getUserEntries() {
        return this.entries.subSet(this.entries.first(), false, this.entries.last(), false);
    }

    public DimensionControl<T> getControl() {
        return this.control;
    }
}

