/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import net.sf.jasperreports.engine.export.FileHtmlResourceHandler;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.export.HtmlExporterOutput;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;

public class SimpleHtmlExporterOutput
extends SimpleWriterExporterOutput
implements HtmlExporterOutput {
    private HtmlResourceHandler imageHandler;
    private HtmlResourceHandler fontHandler;
    private HtmlResourceHandler resourceHandler;

    public SimpleHtmlExporterOutput(StringBuffer sbuffer) {
        super(sbuffer);
    }

    public SimpleHtmlExporterOutput(Writer writer) {
        super(writer);
    }

    public SimpleHtmlExporterOutput(OutputStream outputStream) {
        super(outputStream);
    }

    public SimpleHtmlExporterOutput(OutputStream outputStream, String encoding) {
        super(outputStream, encoding);
    }

    public SimpleHtmlExporterOutput(File file) {
        super(file);
        this.setFileHandlers(file);
    }

    public SimpleHtmlExporterOutput(File file, String encoding) {
        super(file, encoding);
        this.setFileHandlers(file);
    }

    public SimpleHtmlExporterOutput(String fileName) {
        super(fileName);
        this.setFileHandlers(new File(fileName));
    }

    public SimpleHtmlExporterOutput(String fileName, String encoding) {
        super(fileName, encoding);
        this.setFileHandlers(new File(fileName));
    }

    @Override
    public HtmlResourceHandler getImageHandler() {
        return this.imageHandler;
    }

    public void setImageHandler(HtmlResourceHandler imageHandler) {
        this.imageHandler = imageHandler;
    }

    @Override
    public HtmlResourceHandler getFontHandler() {
        return this.fontHandler;
    }

    public void setFontHandler(HtmlResourceHandler fontHandler) {
        this.fontHandler = fontHandler;
    }

    @Override
    public HtmlResourceHandler getResourceHandler() {
        return this.resourceHandler;
    }

    public void setResourceHandler(HtmlResourceHandler resourceHandler) {
        this.resourceHandler = resourceHandler;
    }

    private void setFileHandlers(File destFile) {
        File resourcesDir = new File(destFile.getParent(), destFile.getName() + "_files");
        String pathPattern = resourcesDir.getName() + "/{0}";
        this.imageHandler = new FileHtmlResourceHandler(resourcesDir, pathPattern);
        this.fontHandler = new FileHtmlResourceHandler(resourcesDir, pathPattern);
        this.resourceHandler = new FileHtmlResourceHandler(resourcesDir);
    }
}

