/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.ExceptionInterceptor;
import com.mysql.jdbc.Extension;
import com.mysql.jdbc.LoadBalancedConnection;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MySQLConnection;
import com.mysql.jdbc.NonRegisteringDriver;
import com.mysql.jdbc.PingTarget;
import com.mysql.jdbc.ReplicationConnectionGroup;
import com.mysql.jdbc.ReplicationConnectionGroupManager;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.Statement;
import com.mysql.jdbc.log.Log;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationConnection
implements Connection,
PingTarget {
    protected Connection currentConnection;
    protected LoadBalancedConnection masterConnection;
    protected LoadBalancedConnection slavesConnection;
    private Properties slaveProperties;
    private Properties masterProperties;
    private NonRegisteringDriver driver;
    private long connectionGroupID = -1L;
    private ReplicationConnectionGroup connectionGroup;
    private List<String> slaveHosts;
    private List<String> masterHosts;
    private boolean allowMasterDownConnections = false;
    private boolean enableJMX = false;
    private boolean readOnly = false;

    protected ReplicationConnection() {
    }

    public ReplicationConnection(Properties masterProperties, Properties slaveProperties, List<String> masterHostList, List<String> slaveHostList) throws SQLException {
        String enableJMXAsString = masterProperties.getProperty("replicationEnableJMX", "false");
        try {
            this.enableJMX = Boolean.parseBoolean(enableJMXAsString);
        }
        catch (Exception e) {
            throw SQLError.createSQLException(Messages.getString("ReplicationConnection.badValueForReplicationEnableJMX", new Object[]{enableJMXAsString}), "S1009", null);
        }
        String allowMasterDownConnectionsAsString = masterProperties.getProperty("allowMasterDownConnections", "false");
        try {
            this.allowMasterDownConnections = Boolean.parseBoolean(allowMasterDownConnectionsAsString);
        }
        catch (Exception e) {
            throw SQLError.createSQLException(Messages.getString("ReplicationConnection.badValueForAllowMasterDownConnections", new Object[]{enableJMXAsString}), "S1009", null);
        }
        String group = masterProperties.getProperty("replicationConnectionGroup", null);
        if (group != null) {
            this.connectionGroup = ReplicationConnectionGroupManager.getConnectionGroupInstance(group);
            if (this.enableJMX) {
                ReplicationConnectionGroupManager.registerJmx();
            }
            this.connectionGroupID = this.connectionGroup.registerReplicationConnection(this, masterHostList, slaveHostList);
            this.slaveHosts = new ArrayList<String>(this.connectionGroup.getSlaveHosts());
            this.masterHosts = new ArrayList<String>(this.connectionGroup.getMasterHosts());
        } else {
            this.slaveHosts = new ArrayList<String>(slaveHostList);
            this.masterHosts = new ArrayList<String>(masterHostList);
        }
        this.driver = new NonRegisteringDriver();
        this.slaveProperties = slaveProperties;
        this.masterProperties = masterProperties;
        boolean createdMaster = this.initializeMasterConnection();
        this.initializeSlaveConnection();
        if (!createdMaster) {
            this.readOnly = true;
            this.currentConnection = this.slavesConnection;
            return;
        }
        this.currentConnection = this.masterConnection;
    }

    private boolean initializeMasterConnection() throws SQLException {
        return this.initializeMasterConnection(this.allowMasterDownConnections);
    }

    public long getConnectionGroupId() {
        return this.connectionGroupID;
    }

    private boolean initializeMasterConnection(boolean allowMasterDown) throws SQLException {
        boolean isMaster = this.isMasterConnection();
        StringBuffer masterUrl = new StringBuffer("jdbc:mysql:loadbalance://");
        boolean firstHost = true;
        for (String host : this.masterHosts) {
            if (!firstHost) {
                masterUrl.append(',');
            }
            masterUrl.append(host);
            firstHost = false;
        }
        String masterDb = this.masterProperties.getProperty("DBNAME");
        masterUrl.append("/");
        if (masterDb != null) {
            masterUrl.append(masterDb);
        }
        LoadBalancedConnection newMasterConn = null;
        try {
            newMasterConn = (LoadBalancedConnection)this.driver.connect(masterUrl.toString(), this.masterProperties);
        }
        catch (SQLException ex) {
            if (allowMasterDown) {
                this.currentConnection = this.slavesConnection;
                this.masterConnection = null;
                this.readOnly = true;
                return false;
            }
            throw ex;
        }
        if (isMaster && this.currentConnection != null) {
            this.swapConnections(newMasterConn, this.currentConnection);
        }
        if (this.masterConnection != null) {
            try {
                this.masterConnection.close();
                this.masterConnection = null;
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        this.masterConnection = newMasterConn;
        return true;
    }

    private void initializeSlaveConnection() throws SQLException {
        if (this.slaveHosts.size() == 0) {
            return;
        }
        StringBuffer slaveUrl = new StringBuffer("jdbc:mysql:loadbalance://");
        boolean firstHost = true;
        for (String host : this.slaveHosts) {
            if (!firstHost) {
                slaveUrl.append(',');
            }
            slaveUrl.append(host);
            firstHost = false;
        }
        String slaveDb = this.slaveProperties.getProperty("DBNAME");
        slaveUrl.append("/");
        if (slaveDb != null) {
            slaveUrl.append(slaveDb);
        }
        this.slavesConnection = (LoadBalancedConnection)this.driver.connect(slaveUrl.toString(), this.slaveProperties);
        this.slavesConnection.setReadOnly(true);
        if (this.currentConnection != null && this.currentConnection == this.masterConnection && this.readOnly) {
            this.switchToSlavesConnection();
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.getCurrentConnection().clearWarnings();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.masterConnection != null) {
            this.masterConnection.close();
        }
        if (this.slavesConnection != null) {
            this.slavesConnection.close();
        }
        if (this.connectionGroup != null) {
            this.connectionGroup.handleCloseConnection(this);
        }
    }

    @Override
    public void commit() throws SQLException {
        this.getCurrentConnection().commit();
    }

    public boolean isHostMaster(String host) {
        if (host == null) {
            return false;
        }
        for (String test : this.masterHosts) {
            if (!test.equalsIgnoreCase(host)) continue;
            return true;
        }
        return false;
    }

    public boolean isHostSlave(String host) {
        if (host == null) {
            return false;
        }
        for (String test : this.slaveHosts) {
            if (!test.equalsIgnoreCase(host)) continue;
            return true;
        }
        return false;
    }

    public synchronized void removeSlave(String host) throws SQLException {
        this.removeSlave(host, true);
    }

    public synchronized void removeSlave(String host, boolean closeGently) throws SQLException {
        this.slaveHosts.remove(host);
        if (this.slavesConnection == null) {
            return;
        }
        if (closeGently) {
            this.slavesConnection.removeHostWhenNotInUse(host);
        } else {
            this.slavesConnection.removeHost(host);
        }
        if (this.slaveHosts.size() == 0) {
            this.switchToMasterConnection();
            this.slavesConnection.close();
            this.slavesConnection = null;
            this.setReadOnly(this.readOnly);
        }
    }

    public synchronized void addSlaveHost(String host) throws SQLException {
        if (this.isHostSlave(host)) {
            return;
        }
        this.slaveHosts.add(host);
        if (this.slavesConnection == null) {
            this.initializeSlaveConnection();
        } else {
            this.slavesConnection.addHost(host);
        }
    }

    public synchronized void promoteSlaveToMaster(String host) throws SQLException {
        if (!this.isHostSlave(host)) {
            // empty if block
        }
        this.masterHosts.add(host);
        this.removeSlave(host);
        if (this.masterConnection != null) {
            this.masterConnection.addHost(host);
        }
    }

    public synchronized void removeMasterHost(String host) throws SQLException {
        this.removeMasterHost(host, true);
    }

    public synchronized void removeMasterHost(String host, boolean waitUntilNotInUse) throws SQLException {
        this.removeMasterHost(host, waitUntilNotInUse, false);
    }

    public synchronized void removeMasterHost(String host, boolean waitUntilNotInUse, boolean isNowSlave) throws SQLException {
        if (isNowSlave) {
            this.slaveHosts.add(host);
        }
        this.masterHosts.remove(host);
        if (this.masterConnection == null) {
            return;
        }
        if (waitUntilNotInUse) {
            this.masterConnection.removeHostWhenNotInUse(host);
        } else {
            this.masterConnection.removeHost(host);
        }
    }

    @Override
    public java.sql.Statement createStatement() throws SQLException {
        java.sql.Statement stmt = this.getCurrentConnection().createStatement();
        ((Statement)stmt).setPingTarget(this);
        return stmt;
    }

    @Override
    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        java.sql.Statement stmt = this.getCurrentConnection().createStatement(resultSetType, resultSetConcurrency);
        ((Statement)stmt).setPingTarget(this);
        return stmt;
    }

    @Override
    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        java.sql.Statement stmt = this.getCurrentConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        ((Statement)stmt).setPingTarget(this);
        return stmt;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.getCurrentConnection().getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.getCurrentConnection().getCatalog();
    }

    public synchronized Connection getCurrentConnection() {
        return this.currentConnection;
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.getCurrentConnection().getHoldability();
    }

    public synchronized Connection getMasterConnection() {
        return this.masterConnection;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getCurrentConnection().getMetaData();
    }

    public synchronized Connection getSlavesConnection() {
        return this.slavesConnection;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.getCurrentConnection().getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.getCurrentConnection().getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.getCurrentConnection().getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.getCurrentConnection().isClosed();
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.getCurrentConnection().nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.getCurrentConnection().prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.getCurrentConnection().prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.getCurrentConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement pstmt = this.getCurrentConnection().prepareStatement(sql);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement pstmt = this.getCurrentConnection().prepareStatement(sql, autoGeneratedKeys);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement pstmt = this.getCurrentConnection().prepareStatement(sql, resultSetType, resultSetConcurrency);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement pstmt = this.getCurrentConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement pstmt = this.getCurrentConnection().prepareStatement(sql, columnIndexes);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement pstmt = this.getCurrentConnection().prepareStatement(sql, columnNames);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.getCurrentConnection().releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this.getCurrentConnection().rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.getCurrentConnection().rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.getCurrentConnection().setAutoCommit(autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.getCurrentConnection().setCatalog(catalog);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.getCurrentConnection().setHoldability(holdability);
    }

    @Override
    public synchronized void setReadOnly(boolean readOnly) throws SQLException {
        if (readOnly) {
            if (this.currentConnection != this.slavesConnection) {
                this.switchToSlavesConnection();
            }
        } else if (this.currentConnection != this.masterConnection) {
            this.switchToMasterConnection();
        }
        this.readOnly = readOnly;
        if (this.currentConnection == this.masterConnection) {
            this.currentConnection.setReadOnly(this.readOnly);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.getCurrentConnection().setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.getCurrentConnection().setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.getCurrentConnection().setTransactionIsolation(level);
    }

    private synchronized void switchToMasterConnection() throws SQLException {
        if (this.masterConnection == null || this.masterConnection.isClosed()) {
            this.initializeMasterConnection();
        }
        this.swapConnections(this.masterConnection, this.slavesConnection);
        this.masterConnection.setReadOnly(false);
    }

    private synchronized void switchToSlavesConnection() throws SQLException {
        if (this.slavesConnection == null || this.slavesConnection.isClosed()) {
            this.initializeSlaveConnection();
        }
        if (this.slavesConnection != null) {
            this.swapConnections(this.slavesConnection, this.masterConnection);
            this.slavesConnection.setReadOnly(true);
        }
    }

    private synchronized void swapConnections(Connection switchToConnection, Connection switchFromConnection) throws SQLException {
        String switchFromCatalog = switchFromConnection.getCatalog();
        String switchToCatalog = switchToConnection.getCatalog();
        if (switchToCatalog != null && !switchToCatalog.equals(switchFromCatalog)) {
            switchToConnection.setCatalog(switchFromCatalog);
        } else if (switchFromCatalog != null) {
            switchToConnection.setCatalog(switchFromCatalog);
        }
        boolean switchToAutoCommit = switchToConnection.getAutoCommit();
        boolean switchFromConnectionAutoCommit = switchFromConnection.getAutoCommit();
        if (switchFromConnectionAutoCommit != switchToAutoCommit) {
            switchToConnection.setAutoCommit(switchFromConnectionAutoCommit);
        }
        int switchToIsolation = switchToConnection.getTransactionIsolation();
        int switchFromIsolation = switchFromConnection.getTransactionIsolation();
        if (switchFromIsolation != switchToIsolation) {
            switchToConnection.setTransactionIsolation(switchFromIsolation);
        }
        switchToConnection.setSessionMaxRows(switchFromConnection.getSessionMaxRows());
        this.currentConnection = switchToConnection;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized void doPing() throws SQLException {
        isMasterConn = this.isMasterConnection();
        if (this.masterConnection != null) {
            try {
                this.masterConnection.ping();
            }
            catch (SQLException e) {
                if (!isMasterConn) ** GOTO lbl13
                this.currentConnection = this.slavesConnection;
                this.masterConnection = null;
                throw e;
            }
        } else {
            this.initializeMasterConnection();
        }
lbl13:
        // 3 sources

        if (this.slavesConnection != null) {
            try {
                this.slavesConnection.ping();
            }
            catch (SQLException e) {
                if (isMasterConn) ** GOTO lbl23
                this.currentConnection = this.masterConnection;
                this.slavesConnection = null;
                throw e;
            }
        } else {
            this.initializeSlaveConnection();
        }
lbl23:
        // 3 sources

    }

    @Override
    public synchronized void changeUser(String userName, String newPassword) throws SQLException {
        this.masterConnection.changeUser(userName, newPassword);
        this.slavesConnection.changeUser(userName, newPassword);
    }

    @Override
    public synchronized void clearHasTriedMaster() {
        this.masterConnection.clearHasTriedMaster();
        this.slavesConnection.clearHasTriedMaster();
    }

    @Override
    public PreparedStatement clientPrepareStatement(String sql) throws SQLException {
        PreparedStatement pstmt = this.getCurrentConnection().clientPrepareStatement(sql);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public PreparedStatement clientPrepareStatement(String sql, int autoGenKeyIndex) throws SQLException {
        PreparedStatement pstmt = this.getCurrentConnection().clientPrepareStatement(sql, autoGenKeyIndex);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public PreparedStatement clientPrepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement pstmt = this.getCurrentConnection().clientPrepareStatement(sql, resultSetType, resultSetConcurrency);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public PreparedStatement clientPrepareStatement(String sql, int[] autoGenKeyIndexes) throws SQLException {
        PreparedStatement pstmt = this.getCurrentConnection().clientPrepareStatement(sql, autoGenKeyIndexes);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public PreparedStatement clientPrepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement pstmt = this.getCurrentConnection().clientPrepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public PreparedStatement clientPrepareStatement(String sql, String[] autoGenKeyColNames) throws SQLException {
        PreparedStatement pstmt = this.getCurrentConnection().clientPrepareStatement(sql, autoGenKeyColNames);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public int getActiveStatementCount() {
        return this.getCurrentConnection().getActiveStatementCount();
    }

    @Override
    public long getIdleFor() {
        return this.getCurrentConnection().getIdleFor();
    }

    @Override
    public Log getLog() throws SQLException {
        return this.getCurrentConnection().getLog();
    }

    @Override
    public String getServerCharacterEncoding() {
        return this.getCurrentConnection().getServerCharacterEncoding();
    }

    @Override
    public TimeZone getServerTimezoneTZ() {
        return this.getCurrentConnection().getServerTimezoneTZ();
    }

    @Override
    public String getStatementComment() {
        return this.getCurrentConnection().getStatementComment();
    }

    @Override
    public boolean hasTriedMaster() {
        return this.getCurrentConnection().hasTriedMaster();
    }

    @Override
    public void initializeExtension(Extension ex) throws SQLException {
        this.getCurrentConnection().initializeExtension(ex);
    }

    @Override
    public boolean isAbonormallyLongQuery(long millisOrNanos) {
        return this.getCurrentConnection().isAbonormallyLongQuery(millisOrNanos);
    }

    @Override
    public boolean isInGlobalTx() {
        return this.getCurrentConnection().isInGlobalTx();
    }

    @Override
    public boolean isMasterConnection() {
        if (this.currentConnection == null) {
            return true;
        }
        return this.currentConnection == this.masterConnection;
    }

    @Override
    public boolean isNoBackslashEscapesSet() {
        return this.getCurrentConnection().isNoBackslashEscapesSet();
    }

    @Override
    public boolean lowerCaseTableNames() {
        return this.getCurrentConnection().lowerCaseTableNames();
    }

    @Override
    public boolean parserKnowsUnicode() {
        return this.getCurrentConnection().parserKnowsUnicode();
    }

    @Override
    public synchronized void ping() throws SQLException {
        block5: {
            block4: {
                try {
                    this.masterConnection.ping();
                }
                catch (SQLException e) {
                    if (!this.isMasterConnection()) break block4;
                    throw e;
                }
            }
            try {
                this.slavesConnection.ping();
            }
            catch (SQLException e) {
                if (this.isMasterConnection()) break block5;
                throw e;
            }
        }
    }

    @Override
    public void reportQueryTime(long millisOrNanos) {
        this.getCurrentConnection().reportQueryTime(millisOrNanos);
    }

    @Override
    public void resetServerState() throws SQLException {
        this.getCurrentConnection().resetServerState();
    }

    @Override
    public PreparedStatement serverPrepareStatement(String sql) throws SQLException {
        PreparedStatement pstmt = this.getCurrentConnection().serverPrepareStatement(sql);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public PreparedStatement serverPrepareStatement(String sql, int autoGenKeyIndex) throws SQLException {
        PreparedStatement pstmt = this.getCurrentConnection().serverPrepareStatement(sql, autoGenKeyIndex);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public PreparedStatement serverPrepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement pstmt = this.getCurrentConnection().serverPrepareStatement(sql, resultSetType, resultSetConcurrency);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public PreparedStatement serverPrepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement pstmt = this.getCurrentConnection().serverPrepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public PreparedStatement serverPrepareStatement(String sql, int[] autoGenKeyIndexes) throws SQLException {
        PreparedStatement pstmt = this.getCurrentConnection().serverPrepareStatement(sql, autoGenKeyIndexes);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public PreparedStatement serverPrepareStatement(String sql, String[] autoGenKeyColNames) throws SQLException {
        PreparedStatement pstmt = this.getCurrentConnection().serverPrepareStatement(sql, autoGenKeyColNames);
        ((Statement)((Object)pstmt)).setPingTarget(this);
        return pstmt;
    }

    @Override
    public void setFailedOver(boolean flag) {
        this.getCurrentConnection().setFailedOver(flag);
    }

    @Override
    public void setPreferSlaveDuringFailover(boolean flag) {
        this.getCurrentConnection().setPreferSlaveDuringFailover(flag);
    }

    @Override
    public synchronized void setStatementComment(String comment) {
        this.masterConnection.setStatementComment(comment);
        this.slavesConnection.setStatementComment(comment);
    }

    @Override
    public void shutdownServer() throws SQLException {
        this.getCurrentConnection().shutdownServer();
    }

    @Override
    public boolean supportsIsolationLevel() {
        return this.getCurrentConnection().supportsIsolationLevel();
    }

    @Override
    public boolean supportsQuotedIdentifiers() {
        return this.getCurrentConnection().supportsQuotedIdentifiers();
    }

    @Override
    public boolean supportsTransactions() {
        return this.getCurrentConnection().supportsTransactions();
    }

    @Override
    public boolean versionMeetsMinimum(int major, int minor, int subminor) throws SQLException {
        return this.getCurrentConnection().versionMeetsMinimum(major, minor, subminor);
    }

    @Override
    public String exposeAsXml() throws SQLException {
        return this.getCurrentConnection().exposeAsXml();
    }

    @Override
    public boolean getAllowLoadLocalInfile() {
        return this.getCurrentConnection().getAllowLoadLocalInfile();
    }

    @Override
    public boolean getAllowMultiQueries() {
        return this.getCurrentConnection().getAllowMultiQueries();
    }

    @Override
    public boolean getAllowNanAndInf() {
        return this.getCurrentConnection().getAllowNanAndInf();
    }

    @Override
    public boolean getAllowUrlInLocalInfile() {
        return this.getCurrentConnection().getAllowUrlInLocalInfile();
    }

    @Override
    public boolean getAlwaysSendSetIsolation() {
        return this.getCurrentConnection().getAlwaysSendSetIsolation();
    }

    @Override
    public boolean getAutoClosePStmtStreams() {
        return this.getCurrentConnection().getAutoClosePStmtStreams();
    }

    @Override
    public boolean getAutoDeserialize() {
        return this.getCurrentConnection().getAutoDeserialize();
    }

    @Override
    public boolean getAutoGenerateTestcaseScript() {
        return this.getCurrentConnection().getAutoGenerateTestcaseScript();
    }

    @Override
    public boolean getAutoReconnectForPools() {
        return this.getCurrentConnection().getAutoReconnectForPools();
    }

    @Override
    public boolean getAutoSlowLog() {
        return this.getCurrentConnection().getAutoSlowLog();
    }

    @Override
    public int getBlobSendChunkSize() {
        return this.getCurrentConnection().getBlobSendChunkSize();
    }

    @Override
    public boolean getBlobsAreStrings() {
        return this.getCurrentConnection().getBlobsAreStrings();
    }

    @Override
    public boolean getCacheCallableStatements() {
        return this.getCurrentConnection().getCacheCallableStatements();
    }

    @Override
    public boolean getCacheCallableStmts() {
        return this.getCurrentConnection().getCacheCallableStmts();
    }

    @Override
    public boolean getCachePrepStmts() {
        return this.getCurrentConnection().getCachePrepStmts();
    }

    @Override
    public boolean getCachePreparedStatements() {
        return this.getCurrentConnection().getCachePreparedStatements();
    }

    @Override
    public boolean getCacheResultSetMetadata() {
        return this.getCurrentConnection().getCacheResultSetMetadata();
    }

    @Override
    public boolean getCacheServerConfiguration() {
        return this.getCurrentConnection().getCacheServerConfiguration();
    }

    @Override
    public int getCallableStatementCacheSize() {
        return this.getCurrentConnection().getCallableStatementCacheSize();
    }

    @Override
    public int getCallableStmtCacheSize() {
        return this.getCurrentConnection().getCallableStmtCacheSize();
    }

    @Override
    public boolean getCapitalizeTypeNames() {
        return this.getCurrentConnection().getCapitalizeTypeNames();
    }

    @Override
    public String getCharacterSetResults() {
        return this.getCurrentConnection().getCharacterSetResults();
    }

    @Override
    public String getClientCertificateKeyStorePassword() {
        return this.getCurrentConnection().getClientCertificateKeyStorePassword();
    }

    @Override
    public String getClientCertificateKeyStoreType() {
        return this.getCurrentConnection().getClientCertificateKeyStoreType();
    }

    @Override
    public String getClientCertificateKeyStoreUrl() {
        return this.getCurrentConnection().getClientCertificateKeyStoreUrl();
    }

    @Override
    public String getClientInfoProvider() {
        return this.getCurrentConnection().getClientInfoProvider();
    }

    @Override
    public String getClobCharacterEncoding() {
        return this.getCurrentConnection().getClobCharacterEncoding();
    }

    @Override
    public boolean getClobberStreamingResults() {
        return this.getCurrentConnection().getClobberStreamingResults();
    }

    @Override
    public int getConnectTimeout() {
        return this.getCurrentConnection().getConnectTimeout();
    }

    @Override
    public String getConnectionCollation() {
        return this.getCurrentConnection().getConnectionCollation();
    }

    @Override
    public String getConnectionLifecycleInterceptors() {
        return this.getCurrentConnection().getConnectionLifecycleInterceptors();
    }

    @Override
    public boolean getContinueBatchOnError() {
        return this.getCurrentConnection().getContinueBatchOnError();
    }

    @Override
    public boolean getCreateDatabaseIfNotExist() {
        return this.getCurrentConnection().getCreateDatabaseIfNotExist();
    }

    @Override
    public int getDefaultFetchSize() {
        return this.getCurrentConnection().getDefaultFetchSize();
    }

    @Override
    public boolean getDontTrackOpenResources() {
        return this.getCurrentConnection().getDontTrackOpenResources();
    }

    @Override
    public boolean getDumpMetadataOnColumnNotFound() {
        return this.getCurrentConnection().getDumpMetadataOnColumnNotFound();
    }

    @Override
    public boolean getDumpQueriesOnException() {
        return this.getCurrentConnection().getDumpQueriesOnException();
    }

    @Override
    public boolean getDynamicCalendars() {
        return this.getCurrentConnection().getDynamicCalendars();
    }

    @Override
    public boolean getElideSetAutoCommits() {
        return this.getCurrentConnection().getElideSetAutoCommits();
    }

    @Override
    public boolean getEmptyStringsConvertToZero() {
        return this.getCurrentConnection().getEmptyStringsConvertToZero();
    }

    @Override
    public boolean getEmulateLocators() {
        return this.getCurrentConnection().getEmulateLocators();
    }

    @Override
    public boolean getEmulateUnsupportedPstmts() {
        return this.getCurrentConnection().getEmulateUnsupportedPstmts();
    }

    @Override
    public boolean getEnablePacketDebug() {
        return this.getCurrentConnection().getEnablePacketDebug();
    }

    @Override
    public boolean getEnableQueryTimeouts() {
        return this.getCurrentConnection().getEnableQueryTimeouts();
    }

    @Override
    public String getEncoding() {
        return this.getCurrentConnection().getEncoding();
    }

    @Override
    public boolean getExplainSlowQueries() {
        return this.getCurrentConnection().getExplainSlowQueries();
    }

    @Override
    public boolean getFailOverReadOnly() {
        return this.getCurrentConnection().getFailOverReadOnly();
    }

    @Override
    public boolean getFunctionsNeverReturnBlobs() {
        return this.getCurrentConnection().getFunctionsNeverReturnBlobs();
    }

    @Override
    public boolean getGatherPerfMetrics() {
        return this.getCurrentConnection().getGatherPerfMetrics();
    }

    @Override
    public boolean getGatherPerformanceMetrics() {
        return this.getCurrentConnection().getGatherPerformanceMetrics();
    }

    @Override
    public boolean getGenerateSimpleParameterMetadata() {
        return this.getCurrentConnection().getGenerateSimpleParameterMetadata();
    }

    @Override
    public boolean getHoldResultsOpenOverStatementClose() {
        return this.getCurrentConnection().getHoldResultsOpenOverStatementClose();
    }

    @Override
    public boolean getIgnoreNonTxTables() {
        return this.getCurrentConnection().getIgnoreNonTxTables();
    }

    @Override
    public boolean getIncludeInnodbStatusInDeadlockExceptions() {
        return this.getCurrentConnection().getIncludeInnodbStatusInDeadlockExceptions();
    }

    @Override
    public int getInitialTimeout() {
        return this.getCurrentConnection().getInitialTimeout();
    }

    @Override
    public boolean getInteractiveClient() {
        return this.getCurrentConnection().getInteractiveClient();
    }

    @Override
    public boolean getIsInteractiveClient() {
        return this.getCurrentConnection().getIsInteractiveClient();
    }

    @Override
    public boolean getJdbcCompliantTruncation() {
        return this.getCurrentConnection().getJdbcCompliantTruncation();
    }

    @Override
    public boolean getJdbcCompliantTruncationForReads() {
        return this.getCurrentConnection().getJdbcCompliantTruncationForReads();
    }

    @Override
    public String getLargeRowSizeThreshold() {
        return this.getCurrentConnection().getLargeRowSizeThreshold();
    }

    @Override
    public String getLoadBalanceStrategy() {
        return this.getCurrentConnection().getLoadBalanceStrategy();
    }

    @Override
    public String getLocalSocketAddress() {
        return this.getCurrentConnection().getLocalSocketAddress();
    }

    @Override
    public int getLocatorFetchBufferSize() {
        return this.getCurrentConnection().getLocatorFetchBufferSize();
    }

    @Override
    public boolean getLogSlowQueries() {
        return this.getCurrentConnection().getLogSlowQueries();
    }

    @Override
    public boolean getLogXaCommands() {
        return this.getCurrentConnection().getLogXaCommands();
    }

    @Override
    public String getLogger() {
        return this.getCurrentConnection().getLogger();
    }

    @Override
    public String getLoggerClassName() {
        return this.getCurrentConnection().getLoggerClassName();
    }

    @Override
    public boolean getMaintainTimeStats() {
        return this.getCurrentConnection().getMaintainTimeStats();
    }

    @Override
    public int getMaxQuerySizeToLog() {
        return this.getCurrentConnection().getMaxQuerySizeToLog();
    }

    @Override
    public int getMaxReconnects() {
        return this.getCurrentConnection().getMaxReconnects();
    }

    @Override
    public int getMaxRows() {
        return this.getCurrentConnection().getMaxRows();
    }

    @Override
    public int getMetadataCacheSize() {
        return this.getCurrentConnection().getMetadataCacheSize();
    }

    @Override
    public int getNetTimeoutForStreamingResults() {
        return this.getCurrentConnection().getNetTimeoutForStreamingResults();
    }

    @Override
    public boolean getNoAccessToProcedureBodies() {
        return this.getCurrentConnection().getNoAccessToProcedureBodies();
    }

    @Override
    public boolean getNoDatetimeStringSync() {
        return this.getCurrentConnection().getNoDatetimeStringSync();
    }

    @Override
    public boolean getNoTimezoneConversionForTimeType() {
        return this.getCurrentConnection().getNoTimezoneConversionForTimeType();
    }

    @Override
    public boolean getNullCatalogMeansCurrent() {
        return this.getCurrentConnection().getNullCatalogMeansCurrent();
    }

    @Override
    public boolean getNullNamePatternMatchesAll() {
        return this.getCurrentConnection().getNullNamePatternMatchesAll();
    }

    @Override
    public boolean getOverrideSupportsIntegrityEnhancementFacility() {
        return this.getCurrentConnection().getOverrideSupportsIntegrityEnhancementFacility();
    }

    @Override
    public int getPacketDebugBufferSize() {
        return this.getCurrentConnection().getPacketDebugBufferSize();
    }

    @Override
    public boolean getPadCharsWithSpace() {
        return this.getCurrentConnection().getPadCharsWithSpace();
    }

    @Override
    public boolean getParanoid() {
        return this.getCurrentConnection().getParanoid();
    }

    @Override
    public boolean getPedantic() {
        return this.getCurrentConnection().getPedantic();
    }

    @Override
    public boolean getPinGlobalTxToPhysicalConnection() {
        return this.getCurrentConnection().getPinGlobalTxToPhysicalConnection();
    }

    @Override
    public boolean getPopulateInsertRowWithDefaultValues() {
        return this.getCurrentConnection().getPopulateInsertRowWithDefaultValues();
    }

    @Override
    public int getPrepStmtCacheSize() {
        return this.getCurrentConnection().getPrepStmtCacheSize();
    }

    @Override
    public int getPrepStmtCacheSqlLimit() {
        return this.getCurrentConnection().getPrepStmtCacheSqlLimit();
    }

    @Override
    public int getPreparedStatementCacheSize() {
        return this.getCurrentConnection().getPreparedStatementCacheSize();
    }

    @Override
    public int getPreparedStatementCacheSqlLimit() {
        return this.getCurrentConnection().getPreparedStatementCacheSqlLimit();
    }

    @Override
    public boolean getProcessEscapeCodesForPrepStmts() {
        return this.getCurrentConnection().getProcessEscapeCodesForPrepStmts();
    }

    @Override
    public boolean getProfileSQL() {
        return this.getCurrentConnection().getProfileSQL();
    }

    @Override
    public boolean getProfileSql() {
        return this.getCurrentConnection().getProfileSql();
    }

    @Override
    public String getProfilerEventHandler() {
        return this.getCurrentConnection().getProfilerEventHandler();
    }

    @Override
    public String getPropertiesTransform() {
        return this.getCurrentConnection().getPropertiesTransform();
    }

    @Override
    public int getQueriesBeforeRetryMaster() {
        return this.getCurrentConnection().getQueriesBeforeRetryMaster();
    }

    @Override
    public boolean getReconnectAtTxEnd() {
        return this.getCurrentConnection().getReconnectAtTxEnd();
    }

    @Override
    public boolean getRelaxAutoCommit() {
        return this.getCurrentConnection().getRelaxAutoCommit();
    }

    @Override
    public int getReportMetricsIntervalMillis() {
        return this.getCurrentConnection().getReportMetricsIntervalMillis();
    }

    @Override
    public boolean getRequireSSL() {
        return this.getCurrentConnection().getRequireSSL();
    }

    @Override
    public String getResourceId() {
        return this.getCurrentConnection().getResourceId();
    }

    @Override
    public int getResultSetSizeThreshold() {
        return this.getCurrentConnection().getResultSetSizeThreshold();
    }

    @Override
    public boolean getRewriteBatchedStatements() {
        return this.getCurrentConnection().getRewriteBatchedStatements();
    }

    @Override
    public boolean getRollbackOnPooledClose() {
        return this.getCurrentConnection().getRollbackOnPooledClose();
    }

    @Override
    public boolean getRoundRobinLoadBalance() {
        return this.getCurrentConnection().getRoundRobinLoadBalance();
    }

    @Override
    public boolean getRunningCTS13() {
        return this.getCurrentConnection().getRunningCTS13();
    }

    @Override
    public int getSecondsBeforeRetryMaster() {
        return this.getCurrentConnection().getSecondsBeforeRetryMaster();
    }

    @Override
    public int getSelfDestructOnPingMaxOperations() {
        return this.getCurrentConnection().getSelfDestructOnPingMaxOperations();
    }

    @Override
    public int getSelfDestructOnPingSecondsLifetime() {
        return this.getCurrentConnection().getSelfDestructOnPingSecondsLifetime();
    }

    @Override
    public String getServerTimezone() {
        return this.getCurrentConnection().getServerTimezone();
    }

    @Override
    public String getSessionVariables() {
        return this.getCurrentConnection().getSessionVariables();
    }

    @Override
    public int getSlowQueryThresholdMillis() {
        return this.getCurrentConnection().getSlowQueryThresholdMillis();
    }

    @Override
    public long getSlowQueryThresholdNanos() {
        return this.getCurrentConnection().getSlowQueryThresholdNanos();
    }

    @Override
    public String getSocketFactory() {
        return this.getCurrentConnection().getSocketFactory();
    }

    @Override
    public String getSocketFactoryClassName() {
        return this.getCurrentConnection().getSocketFactoryClassName();
    }

    @Override
    public int getSocketTimeout() {
        return this.getCurrentConnection().getSocketTimeout();
    }

    @Override
    public String getStatementInterceptors() {
        return this.getCurrentConnection().getStatementInterceptors();
    }

    @Override
    public boolean getStrictFloatingPoint() {
        return this.getCurrentConnection().getStrictFloatingPoint();
    }

    @Override
    public boolean getStrictUpdates() {
        return this.getCurrentConnection().getStrictUpdates();
    }

    @Override
    public boolean getTcpKeepAlive() {
        return this.getCurrentConnection().getTcpKeepAlive();
    }

    @Override
    public boolean getTcpNoDelay() {
        return this.getCurrentConnection().getTcpNoDelay();
    }

    @Override
    public int getTcpRcvBuf() {
        return this.getCurrentConnection().getTcpRcvBuf();
    }

    @Override
    public int getTcpSndBuf() {
        return this.getCurrentConnection().getTcpSndBuf();
    }

    @Override
    public int getTcpTrafficClass() {
        return this.getCurrentConnection().getTcpTrafficClass();
    }

    @Override
    public boolean getTinyInt1isBit() {
        return this.getCurrentConnection().getTinyInt1isBit();
    }

    @Override
    public boolean getTraceProtocol() {
        return this.getCurrentConnection().getTraceProtocol();
    }

    @Override
    public boolean getTransformedBitIsBoolean() {
        return this.getCurrentConnection().getTransformedBitIsBoolean();
    }

    @Override
    public boolean getTreatUtilDateAsTimestamp() {
        return this.getCurrentConnection().getTreatUtilDateAsTimestamp();
    }

    @Override
    public String getTrustCertificateKeyStorePassword() {
        return this.getCurrentConnection().getTrustCertificateKeyStorePassword();
    }

    @Override
    public String getTrustCertificateKeyStoreType() {
        return this.getCurrentConnection().getTrustCertificateKeyStoreType();
    }

    @Override
    public String getTrustCertificateKeyStoreUrl() {
        return this.getCurrentConnection().getTrustCertificateKeyStoreUrl();
    }

    @Override
    public boolean getUltraDevHack() {
        return this.getCurrentConnection().getUltraDevHack();
    }

    @Override
    public boolean getUseBlobToStoreUTF8OutsideBMP() {
        return this.getCurrentConnection().getUseBlobToStoreUTF8OutsideBMP();
    }

    @Override
    public boolean getUseCompression() {
        return this.getCurrentConnection().getUseCompression();
    }

    @Override
    public String getUseConfigs() {
        return this.getCurrentConnection().getUseConfigs();
    }

    @Override
    public boolean getUseCursorFetch() {
        return this.getCurrentConnection().getUseCursorFetch();
    }

    @Override
    public boolean getUseDirectRowUnpack() {
        return this.getCurrentConnection().getUseDirectRowUnpack();
    }

    @Override
    public boolean getUseDynamicCharsetInfo() {
        return this.getCurrentConnection().getUseDynamicCharsetInfo();
    }

    @Override
    public boolean getUseFastDateParsing() {
        return this.getCurrentConnection().getUseFastDateParsing();
    }

    @Override
    public boolean getUseFastIntParsing() {
        return this.getCurrentConnection().getUseFastIntParsing();
    }

    @Override
    public boolean getUseGmtMillisForDatetimes() {
        return this.getCurrentConnection().getUseGmtMillisForDatetimes();
    }

    @Override
    public boolean getUseHostsInPrivileges() {
        return this.getCurrentConnection().getUseHostsInPrivileges();
    }

    @Override
    public boolean getUseInformationSchema() {
        return this.getCurrentConnection().getUseInformationSchema();
    }

    @Override
    public boolean getUseJDBCCompliantTimezoneShift() {
        return this.getCurrentConnection().getUseJDBCCompliantTimezoneShift();
    }

    @Override
    public boolean getUseJvmCharsetConverters() {
        return this.getCurrentConnection().getUseJvmCharsetConverters();
    }

    @Override
    public boolean getUseLegacyDatetimeCode() {
        return this.getCurrentConnection().getUseLegacyDatetimeCode();
    }

    @Override
    public boolean getUseLocalSessionState() {
        return this.getCurrentConnection().getUseLocalSessionState();
    }

    @Override
    public boolean getUseNanosForElapsedTime() {
        return this.getCurrentConnection().getUseNanosForElapsedTime();
    }

    @Override
    public boolean getUseOldAliasMetadataBehavior() {
        return this.getCurrentConnection().getUseOldAliasMetadataBehavior();
    }

    @Override
    public boolean getUseOldUTF8Behavior() {
        return this.getCurrentConnection().getUseOldUTF8Behavior();
    }

    @Override
    public boolean getUseOnlyServerErrorMessages() {
        return this.getCurrentConnection().getUseOnlyServerErrorMessages();
    }

    @Override
    public boolean getUseReadAheadInput() {
        return this.getCurrentConnection().getUseReadAheadInput();
    }

    @Override
    public boolean getUseSSL() {
        return this.getCurrentConnection().getUseSSL();
    }

    @Override
    public boolean getUseSSPSCompatibleTimezoneShift() {
        return this.getCurrentConnection().getUseSSPSCompatibleTimezoneShift();
    }

    @Override
    public boolean getUseServerPrepStmts() {
        return this.getCurrentConnection().getUseServerPrepStmts();
    }

    @Override
    public boolean getUseServerPreparedStmts() {
        return this.getCurrentConnection().getUseServerPreparedStmts();
    }

    @Override
    public boolean getUseSqlStateCodes() {
        return this.getCurrentConnection().getUseSqlStateCodes();
    }

    @Override
    public boolean getUseStreamLengthsInPrepStmts() {
        return this.getCurrentConnection().getUseStreamLengthsInPrepStmts();
    }

    @Override
    public boolean getUseTimezone() {
        return this.getCurrentConnection().getUseTimezone();
    }

    @Override
    public boolean getUseUltraDevWorkAround() {
        return this.getCurrentConnection().getUseUltraDevWorkAround();
    }

    @Override
    public boolean getUseUnbufferedInput() {
        return this.getCurrentConnection().getUseUnbufferedInput();
    }

    @Override
    public boolean getUseUnicode() {
        return this.getCurrentConnection().getUseUnicode();
    }

    @Override
    public boolean getUseUsageAdvisor() {
        return this.getCurrentConnection().getUseUsageAdvisor();
    }

    @Override
    public String getUtf8OutsideBmpExcludedColumnNamePattern() {
        return this.getCurrentConnection().getUtf8OutsideBmpExcludedColumnNamePattern();
    }

    @Override
    public String getUtf8OutsideBmpIncludedColumnNamePattern() {
        return this.getCurrentConnection().getUtf8OutsideBmpIncludedColumnNamePattern();
    }

    @Override
    public boolean getVerifyServerCertificate() {
        return this.getCurrentConnection().getVerifyServerCertificate();
    }

    @Override
    public boolean getYearIsDateType() {
        return this.getCurrentConnection().getYearIsDateType();
    }

    @Override
    public String getZeroDateTimeBehavior() {
        return this.getCurrentConnection().getZeroDateTimeBehavior();
    }

    @Override
    public void setAllowLoadLocalInfile(boolean property) {
    }

    @Override
    public void setAllowMultiQueries(boolean property) {
    }

    @Override
    public void setAllowNanAndInf(boolean flag) {
    }

    @Override
    public void setAllowUrlInLocalInfile(boolean flag) {
    }

    @Override
    public void setAlwaysSendSetIsolation(boolean flag) {
    }

    @Override
    public void setAutoClosePStmtStreams(boolean flag) {
    }

    @Override
    public void setAutoDeserialize(boolean flag) {
    }

    @Override
    public void setAutoGenerateTestcaseScript(boolean flag) {
    }

    @Override
    public void setAutoReconnect(boolean flag) {
    }

    @Override
    public void setAutoReconnectForConnectionPools(boolean property) {
    }

    @Override
    public void setAutoReconnectForPools(boolean flag) {
    }

    @Override
    public void setAutoSlowLog(boolean flag) {
    }

    @Override
    public void setBlobSendChunkSize(String value) throws SQLException {
    }

    @Override
    public void setBlobsAreStrings(boolean flag) {
    }

    @Override
    public void setCacheCallableStatements(boolean flag) {
    }

    @Override
    public void setCacheCallableStmts(boolean flag) {
    }

    @Override
    public void setCachePrepStmts(boolean flag) {
    }

    @Override
    public void setCachePreparedStatements(boolean flag) {
    }

    @Override
    public void setCacheResultSetMetadata(boolean property) {
    }

    @Override
    public void setCacheServerConfiguration(boolean flag) {
    }

    @Override
    public void setCallableStatementCacheSize(int size) {
    }

    @Override
    public void setCallableStmtCacheSize(int cacheSize) {
    }

    @Override
    public void setCapitalizeDBMDTypes(boolean property) {
    }

    @Override
    public void setCapitalizeTypeNames(boolean flag) {
    }

    @Override
    public void setCharacterEncoding(String encoding) {
    }

    @Override
    public void setCharacterSetResults(String characterSet) {
    }

    @Override
    public void setClientCertificateKeyStorePassword(String value) {
    }

    @Override
    public void setClientCertificateKeyStoreType(String value) {
    }

    @Override
    public void setClientCertificateKeyStoreUrl(String value) {
    }

    @Override
    public void setClientInfoProvider(String classname) {
    }

    @Override
    public void setClobCharacterEncoding(String encoding) {
    }

    @Override
    public void setClobberStreamingResults(boolean flag) {
    }

    @Override
    public void setConnectTimeout(int timeoutMs) {
    }

    @Override
    public void setConnectionCollation(String collation) {
    }

    @Override
    public void setConnectionLifecycleInterceptors(String interceptors) {
    }

    @Override
    public void setContinueBatchOnError(boolean property) {
    }

    @Override
    public void setCreateDatabaseIfNotExist(boolean flag) {
    }

    @Override
    public void setDefaultFetchSize(int n) {
    }

    @Override
    public void setDetectServerPreparedStmts(boolean property) {
    }

    @Override
    public void setDontTrackOpenResources(boolean flag) {
    }

    @Override
    public void setDumpMetadataOnColumnNotFound(boolean flag) {
    }

    @Override
    public void setDumpQueriesOnException(boolean flag) {
    }

    @Override
    public void setDynamicCalendars(boolean flag) {
    }

    @Override
    public void setElideSetAutoCommits(boolean flag) {
    }

    @Override
    public void setEmptyStringsConvertToZero(boolean flag) {
    }

    @Override
    public void setEmulateLocators(boolean property) {
    }

    @Override
    public void setEmulateUnsupportedPstmts(boolean flag) {
    }

    @Override
    public void setEnablePacketDebug(boolean flag) {
    }

    @Override
    public void setEnableQueryTimeouts(boolean flag) {
    }

    @Override
    public void setEncoding(String property) {
    }

    @Override
    public void setExplainSlowQueries(boolean flag) {
    }

    @Override
    public void setFailOverReadOnly(boolean flag) {
    }

    @Override
    public void setFunctionsNeverReturnBlobs(boolean flag) {
    }

    @Override
    public void setGatherPerfMetrics(boolean flag) {
    }

    @Override
    public void setGatherPerformanceMetrics(boolean flag) {
    }

    @Override
    public void setGenerateSimpleParameterMetadata(boolean flag) {
    }

    @Override
    public void setHoldResultsOpenOverStatementClose(boolean flag) {
    }

    @Override
    public void setIgnoreNonTxTables(boolean property) {
    }

    @Override
    public void setIncludeInnodbStatusInDeadlockExceptions(boolean flag) {
    }

    @Override
    public void setInitialTimeout(int property) {
    }

    @Override
    public void setInteractiveClient(boolean property) {
    }

    @Override
    public void setIsInteractiveClient(boolean property) {
    }

    @Override
    public void setJdbcCompliantTruncation(boolean flag) {
    }

    @Override
    public void setJdbcCompliantTruncationForReads(boolean jdbcCompliantTruncationForReads) {
    }

    @Override
    public void setLargeRowSizeThreshold(String value) {
    }

    @Override
    public void setLoadBalanceStrategy(String strategy) {
    }

    @Override
    public void setLocalSocketAddress(String address) {
    }

    @Override
    public void setLocatorFetchBufferSize(String value) throws SQLException {
    }

    @Override
    public void setLogSlowQueries(boolean flag) {
    }

    @Override
    public void setLogXaCommands(boolean flag) {
    }

    @Override
    public void setLogger(String property) {
    }

    @Override
    public void setLoggerClassName(String className) {
    }

    @Override
    public void setMaintainTimeStats(boolean flag) {
    }

    @Override
    public void setMaxQuerySizeToLog(int sizeInBytes) {
    }

    @Override
    public void setMaxReconnects(int property) {
    }

    @Override
    public void setMaxRows(int property) {
    }

    @Override
    public void setMetadataCacheSize(int value) {
    }

    @Override
    public void setNetTimeoutForStreamingResults(int value) {
    }

    @Override
    public void setNoAccessToProcedureBodies(boolean flag) {
    }

    @Override
    public void setNoDatetimeStringSync(boolean flag) {
    }

    @Override
    public void setNoTimezoneConversionForTimeType(boolean flag) {
    }

    @Override
    public void setNullCatalogMeansCurrent(boolean value) {
    }

    @Override
    public void setNullNamePatternMatchesAll(boolean value) {
    }

    @Override
    public void setOverrideSupportsIntegrityEnhancementFacility(boolean flag) {
    }

    @Override
    public void setPacketDebugBufferSize(int size) {
    }

    @Override
    public void setPadCharsWithSpace(boolean flag) {
    }

    @Override
    public void setParanoid(boolean property) {
    }

    @Override
    public void setPedantic(boolean property) {
    }

    @Override
    public void setPinGlobalTxToPhysicalConnection(boolean flag) {
    }

    @Override
    public void setPopulateInsertRowWithDefaultValues(boolean flag) {
    }

    @Override
    public void setPrepStmtCacheSize(int cacheSize) {
    }

    @Override
    public void setPrepStmtCacheSqlLimit(int sqlLimit) {
    }

    @Override
    public void setPreparedStatementCacheSize(int cacheSize) {
    }

    @Override
    public void setPreparedStatementCacheSqlLimit(int cacheSqlLimit) {
    }

    @Override
    public void setProcessEscapeCodesForPrepStmts(boolean flag) {
    }

    @Override
    public void setProfileSQL(boolean flag) {
    }

    @Override
    public void setProfileSql(boolean property) {
    }

    @Override
    public void setProfilerEventHandler(String handler) {
    }

    @Override
    public void setPropertiesTransform(String value) {
    }

    @Override
    public void setQueriesBeforeRetryMaster(int property) {
    }

    @Override
    public void setReconnectAtTxEnd(boolean property) {
    }

    @Override
    public void setRelaxAutoCommit(boolean property) {
    }

    @Override
    public void setReportMetricsIntervalMillis(int millis) {
    }

    @Override
    public void setRequireSSL(boolean property) {
    }

    @Override
    public void setResourceId(String resourceId) {
    }

    @Override
    public void setResultSetSizeThreshold(int threshold) {
    }

    @Override
    public void setRetainStatementAfterResultSetClose(boolean flag) {
    }

    @Override
    public void setRewriteBatchedStatements(boolean flag) {
    }

    @Override
    public void setRollbackOnPooledClose(boolean flag) {
    }

    @Override
    public void setRoundRobinLoadBalance(boolean flag) {
    }

    @Override
    public void setRunningCTS13(boolean flag) {
    }

    @Override
    public void setSecondsBeforeRetryMaster(int property) {
    }

    @Override
    public void setSelfDestructOnPingMaxOperations(int maxOperations) {
    }

    @Override
    public void setSelfDestructOnPingSecondsLifetime(int seconds) {
    }

    @Override
    public void setServerTimezone(String property) {
    }

    @Override
    public void setSessionVariables(String variables) {
    }

    @Override
    public void setSlowQueryThresholdMillis(int millis) {
    }

    @Override
    public void setSlowQueryThresholdNanos(long nanos) {
    }

    @Override
    public void setSocketFactory(String name) {
    }

    @Override
    public void setSocketFactoryClassName(String property) {
    }

    @Override
    public void setSocketTimeout(int property) {
    }

    @Override
    public void setStatementInterceptors(String value) {
    }

    @Override
    public void setStrictFloatingPoint(boolean property) {
    }

    @Override
    public void setStrictUpdates(boolean property) {
    }

    @Override
    public void setTcpKeepAlive(boolean flag) {
    }

    @Override
    public void setTcpNoDelay(boolean flag) {
    }

    @Override
    public void setTcpRcvBuf(int bufSize) {
    }

    @Override
    public void setTcpSndBuf(int bufSize) {
    }

    @Override
    public void setTcpTrafficClass(int classFlags) {
    }

    @Override
    public void setTinyInt1isBit(boolean flag) {
    }

    @Override
    public void setTraceProtocol(boolean flag) {
    }

    @Override
    public void setTransformedBitIsBoolean(boolean flag) {
    }

    @Override
    public void setTreatUtilDateAsTimestamp(boolean flag) {
    }

    @Override
    public void setTrustCertificateKeyStorePassword(String value) {
    }

    @Override
    public void setTrustCertificateKeyStoreType(String value) {
    }

    @Override
    public void setTrustCertificateKeyStoreUrl(String value) {
    }

    @Override
    public void setUltraDevHack(boolean flag) {
    }

    @Override
    public void setUseBlobToStoreUTF8OutsideBMP(boolean flag) {
    }

    @Override
    public void setUseCompression(boolean property) {
    }

    @Override
    public void setUseConfigs(String configs) {
    }

    @Override
    public void setUseCursorFetch(boolean flag) {
    }

    @Override
    public void setUseDirectRowUnpack(boolean flag) {
    }

    @Override
    public void setUseDynamicCharsetInfo(boolean flag) {
    }

    @Override
    public void setUseFastDateParsing(boolean flag) {
    }

    @Override
    public void setUseFastIntParsing(boolean flag) {
    }

    @Override
    public void setUseGmtMillisForDatetimes(boolean flag) {
    }

    @Override
    public void setUseHostsInPrivileges(boolean property) {
    }

    @Override
    public void setUseInformationSchema(boolean flag) {
    }

    @Override
    public void setUseJDBCCompliantTimezoneShift(boolean flag) {
    }

    @Override
    public void setUseJvmCharsetConverters(boolean flag) {
    }

    @Override
    public void setUseLegacyDatetimeCode(boolean flag) {
    }

    @Override
    public void setUseLocalSessionState(boolean flag) {
    }

    @Override
    public void setUseNanosForElapsedTime(boolean flag) {
    }

    @Override
    public void setUseOldAliasMetadataBehavior(boolean flag) {
    }

    @Override
    public void setUseOldUTF8Behavior(boolean flag) {
    }

    @Override
    public void setUseOnlyServerErrorMessages(boolean flag) {
    }

    @Override
    public void setUseReadAheadInput(boolean flag) {
    }

    @Override
    public void setUseSSL(boolean property) {
    }

    @Override
    public void setUseSSPSCompatibleTimezoneShift(boolean flag) {
    }

    @Override
    public void setUseServerPrepStmts(boolean flag) {
    }

    @Override
    public void setUseServerPreparedStmts(boolean flag) {
    }

    @Override
    public void setUseSqlStateCodes(boolean flag) {
    }

    @Override
    public void setUseStreamLengthsInPrepStmts(boolean property) {
    }

    @Override
    public void setUseTimezone(boolean property) {
    }

    @Override
    public void setUseUltraDevWorkAround(boolean property) {
    }

    @Override
    public void setUseUnbufferedInput(boolean flag) {
    }

    @Override
    public void setUseUnicode(boolean flag) {
    }

    @Override
    public void setUseUsageAdvisor(boolean useUsageAdvisorFlag) {
    }

    @Override
    public void setUtf8OutsideBmpExcludedColumnNamePattern(String regexPattern) {
    }

    @Override
    public void setUtf8OutsideBmpIncludedColumnNamePattern(String regexPattern) {
    }

    @Override
    public void setVerifyServerCertificate(boolean flag) {
    }

    @Override
    public void setYearIsDateType(boolean flag) {
    }

    @Override
    public void setZeroDateTimeBehavior(String behavior) {
    }

    @Override
    public boolean useUnbufferedInput() {
        return this.getCurrentConnection().useUnbufferedInput();
    }

    @Override
    public boolean isSameResource(Connection c) {
        return this.getCurrentConnection().isSameResource(c);
    }

    @Override
    public void setInGlobalTx(boolean flag) {
        this.getCurrentConnection().setInGlobalTx(flag);
    }

    @Override
    public boolean getUseColumnNamesInFindColumn() {
        return this.getCurrentConnection().getUseColumnNamesInFindColumn();
    }

    @Override
    public void setUseColumnNamesInFindColumn(boolean flag) {
    }

    @Override
    public boolean getUseLocalTransactionState() {
        return this.getCurrentConnection().getUseLocalTransactionState();
    }

    @Override
    public void setUseLocalTransactionState(boolean flag) {
    }

    @Override
    public boolean getCompensateOnDuplicateKeyUpdateCounts() {
        return this.getCurrentConnection().getCompensateOnDuplicateKeyUpdateCounts();
    }

    @Override
    public void setCompensateOnDuplicateKeyUpdateCounts(boolean flag) {
    }

    @Override
    public boolean getUseAffectedRows() {
        return this.getCurrentConnection().getUseAffectedRows();
    }

    @Override
    public void setUseAffectedRows(boolean flag) {
    }

    @Override
    public String getPasswordCharacterEncoding() {
        return this.getCurrentConnection().getPasswordCharacterEncoding();
    }

    @Override
    public void setPasswordCharacterEncoding(String characterSet) {
        this.getCurrentConnection().setPasswordCharacterEncoding(characterSet);
    }

    @Override
    public int getAutoIncrementIncrement() {
        return this.getCurrentConnection().getAutoIncrementIncrement();
    }

    @Override
    public int getLoadBalanceBlacklistTimeout() {
        return this.getCurrentConnection().getLoadBalanceBlacklistTimeout();
    }

    @Override
    public void setLoadBalanceBlacklistTimeout(int loadBalanceBlacklistTimeout) throws SQLException {
        this.getCurrentConnection().setLoadBalanceBlacklistTimeout(loadBalanceBlacklistTimeout);
    }

    @Override
    public int getLoadBalancePingTimeout() {
        return this.getCurrentConnection().getLoadBalancePingTimeout();
    }

    @Override
    public void setLoadBalancePingTimeout(int loadBalancePingTimeout) throws SQLException {
        this.getCurrentConnection().setLoadBalancePingTimeout(loadBalancePingTimeout);
    }

    @Override
    public boolean getLoadBalanceValidateConnectionOnSwapServer() {
        return this.getCurrentConnection().getLoadBalanceValidateConnectionOnSwapServer();
    }

    @Override
    public void setLoadBalanceValidateConnectionOnSwapServer(boolean loadBalanceValidateConnectionOnSwapServer) {
        this.getCurrentConnection().setLoadBalanceValidateConnectionOnSwapServer(loadBalanceValidateConnectionOnSwapServer);
    }

    @Override
    public int getRetriesAllDown() {
        return this.getCurrentConnection().getRetriesAllDown();
    }

    @Override
    public void setRetriesAllDown(int retriesAllDown) throws SQLException {
        this.getCurrentConnection().setRetriesAllDown(retriesAllDown);
    }

    @Override
    public ExceptionInterceptor getExceptionInterceptor() {
        return this.getCurrentConnection().getExceptionInterceptor();
    }

    @Override
    public String getExceptionInterceptors() {
        return this.getCurrentConnection().getExceptionInterceptors();
    }

    @Override
    public void setExceptionInterceptors(String exceptionInterceptors) {
        this.getCurrentConnection().setExceptionInterceptors(exceptionInterceptors);
    }

    @Override
    public boolean getQueryTimeoutKillsConnection() {
        return this.getCurrentConnection().getQueryTimeoutKillsConnection();
    }

    @Override
    public void setQueryTimeoutKillsConnection(boolean queryTimeoutKillsConnection) {
        this.getCurrentConnection().setQueryTimeoutKillsConnection(queryTimeoutKillsConnection);
    }

    @Override
    public boolean hasSameProperties(Connection c) {
        return this.masterConnection.hasSameProperties(c) && this.slavesConnection.hasSameProperties(c);
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.masterConnection.getProperties());
        props.putAll((Map<?, ?>)this.slavesConnection.getProperties());
        return props;
    }

    @Override
    public String getHost() {
        return this.getCurrentConnection().getHost();
    }

    @Override
    public void setProxy(MySQLConnection proxy) {
        this.getCurrentConnection().setProxy(proxy);
    }

    @Override
    public boolean getRetainStatementAfterResultSetClose() {
        return this.getCurrentConnection().getRetainStatementAfterResultSetClose();
    }

    @Override
    public int getMaxAllowedPacket() {
        return this.getCurrentConnection().getMaxAllowedPacket();
    }

    @Override
    public String getLoadBalanceConnectionGroup() {
        return this.getCurrentConnection().getLoadBalanceConnectionGroup();
    }

    @Override
    public boolean getLoadBalanceEnableJMX() {
        return this.getCurrentConnection().getLoadBalanceEnableJMX();
    }

    @Override
    public String getLoadBalanceExceptionChecker() {
        return this.currentConnection.getLoadBalanceExceptionChecker();
    }

    @Override
    public String getLoadBalanceSQLExceptionSubclassFailover() {
        return this.currentConnection.getLoadBalanceSQLExceptionSubclassFailover();
    }

    @Override
    public String getLoadBalanceSQLStateFailover() {
        return this.currentConnection.getLoadBalanceSQLStateFailover();
    }

    @Override
    public void setLoadBalanceConnectionGroup(String loadBalanceConnectionGroup) {
        this.currentConnection.setLoadBalanceConnectionGroup(loadBalanceConnectionGroup);
    }

    @Override
    public void setLoadBalanceEnableJMX(boolean loadBalanceEnableJMX) {
        this.currentConnection.setLoadBalanceEnableJMX(loadBalanceEnableJMX);
    }

    @Override
    public void setLoadBalanceExceptionChecker(String loadBalanceExceptionChecker) {
        this.currentConnection.setLoadBalanceExceptionChecker(loadBalanceExceptionChecker);
    }

    @Override
    public void setLoadBalanceSQLExceptionSubclassFailover(String loadBalanceSQLExceptionSubclassFailover) {
        this.currentConnection.setLoadBalanceSQLExceptionSubclassFailover(loadBalanceSQLExceptionSubclassFailover);
    }

    @Override
    public void setLoadBalanceSQLStateFailover(String loadBalanceSQLStateFailover) {
        this.currentConnection.setLoadBalanceSQLStateFailover(loadBalanceSQLStateFailover);
    }

    @Override
    public String getLoadBalanceAutoCommitStatementRegex() {
        return this.getCurrentConnection().getLoadBalanceAutoCommitStatementRegex();
    }

    @Override
    public int getLoadBalanceAutoCommitStatementThreshold() {
        return this.getCurrentConnection().getLoadBalanceAutoCommitStatementThreshold();
    }

    @Override
    public void setLoadBalanceAutoCommitStatementRegex(String loadBalanceAutoCommitStatementRegex) {
        this.getCurrentConnection().setLoadBalanceAutoCommitStatementRegex(loadBalanceAutoCommitStatementRegex);
    }

    @Override
    public void setLoadBalanceAutoCommitStatementThreshold(int loadBalanceAutoCommitStatementThreshold) throws SQLException {
        this.getCurrentConnection().setLoadBalanceAutoCommitStatementThreshold(loadBalanceAutoCommitStatementThreshold);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public boolean getIncludeThreadDumpInDeadlockExceptions() {
        return this.getCurrentConnection().getIncludeThreadDumpInDeadlockExceptions();
    }

    @Override
    public void setIncludeThreadDumpInDeadlockExceptions(boolean flag) {
        this.getCurrentConnection().setIncludeThreadDumpInDeadlockExceptions(flag);
    }

    @Override
    public boolean getIncludeThreadNamesAsStatementComment() {
        return this.getCurrentConnection().getIncludeThreadNamesAsStatementComment();
    }

    @Override
    public void setIncludeThreadNamesAsStatementComment(boolean flag) {
        this.getCurrentConnection().setIncludeThreadNamesAsStatementComment(flag);
    }

    @Override
    public boolean isServerLocal() throws SQLException {
        return this.getCurrentConnection().isServerLocal();
    }

    @Override
    public void setAuthenticationPlugins(String authenticationPlugins) {
        this.getCurrentConnection().setAuthenticationPlugins(authenticationPlugins);
    }

    @Override
    public String getAuthenticationPlugins() {
        return this.getCurrentConnection().getAuthenticationPlugins();
    }

    @Override
    public void setDisabledAuthenticationPlugins(String disabledAuthenticationPlugins) {
        this.getCurrentConnection().setDisabledAuthenticationPlugins(disabledAuthenticationPlugins);
    }

    @Override
    public String getDisabledAuthenticationPlugins() {
        return this.getCurrentConnection().getDisabledAuthenticationPlugins();
    }

    @Override
    public void setDefaultAuthenticationPlugin(String defaultAuthenticationPlugin) {
        this.getCurrentConnection().setDefaultAuthenticationPlugin(defaultAuthenticationPlugin);
    }

    @Override
    public String getDefaultAuthenticationPlugin() {
        return this.getCurrentConnection().getDefaultAuthenticationPlugin();
    }

    @Override
    public void setParseInfoCacheFactory(String factoryClassname) {
        this.getCurrentConnection().setParseInfoCacheFactory(factoryClassname);
    }

    @Override
    public String getParseInfoCacheFactory() {
        return this.getCurrentConnection().getParseInfoCacheFactory();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.getCurrentConnection().setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.getCurrentConnection().getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.getCurrentConnection().abort(executor);
        if (this.connectionGroup != null) {
            this.connectionGroup.handleCloseConnection(this);
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.getCurrentConnection().setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.getCurrentConnection().getNetworkTimeout();
    }

    @Override
    public void setServerConfigCacheFactory(String factoryClassname) {
        this.getCurrentConnection().setServerConfigCacheFactory(factoryClassname);
    }

    @Override
    public String getServerConfigCacheFactory() {
        return this.getCurrentConnection().getServerConfigCacheFactory();
    }

    @Override
    public void setDisconnectOnExpiredPasswords(boolean disconnectOnExpiredPasswords) {
        this.getCurrentConnection().setDisconnectOnExpiredPasswords(disconnectOnExpiredPasswords);
    }

    @Override
    public boolean getDisconnectOnExpiredPasswords() {
        return this.getCurrentConnection().getDisconnectOnExpiredPasswords();
    }

    @Override
    public void setGetProceduresReturnsFunctions(boolean getProcedureReturnsFunctions) {
        this.getCurrentConnection().setGetProceduresReturnsFunctions(getProcedureReturnsFunctions);
    }

    @Override
    public boolean getGetProceduresReturnsFunctions() {
        return this.getCurrentConnection().getGetProceduresReturnsFunctions();
    }

    @Override
    public void abortInternal() throws SQLException {
        this.getCurrentConnection().abortInternal();
        if (this.connectionGroup != null) {
            this.connectionGroup.handleCloseConnection(this);
        }
    }

    @Override
    public void checkClosed() throws SQLException {
        this.getCurrentConnection().checkClosed();
    }

    @Override
    public Object getConnectionMutex() {
        return this.getCurrentConnection().getConnectionMutex();
    }

    @Override
    public boolean getAllowMasterDownConnections() {
        return this.allowMasterDownConnections;
    }

    @Override
    public void setAllowMasterDownConnections(boolean connectIfMasterDown) {
        this.allowMasterDownConnections = connectIfMasterDown;
    }

    @Override
    public boolean getReplicationEnableJMX() {
        return this.enableJMX;
    }

    @Override
    public void setReplicationEnableJMX(boolean replicationEnableJMX) {
        this.enableJMX = replicationEnableJMX;
    }

    @Override
    public String getConnectionAttributes() throws SQLException {
        return this.getCurrentConnection().getConnectionAttributes();
    }

    @Override
    public void setDetectCustomCollations(boolean detectCustomCollations) {
        this.getCurrentConnection().setDetectCustomCollations(detectCustomCollations);
    }

    @Override
    public boolean getDetectCustomCollations() {
        return this.getCurrentConnection().getDetectCustomCollations();
    }

    @Override
    public int getSessionMaxRows() {
        return this.getCurrentConnection().getSessionMaxRows();
    }

    @Override
    public void setSessionMaxRows(int max) throws SQLException {
        this.getCurrentConnection().setSessionMaxRows(max);
    }

    @Override
    public String getServerRSAPublicKeyFile() {
        return this.getCurrentConnection().getServerRSAPublicKeyFile();
    }

    @Override
    public void setServerRSAPublicKeyFile(String serverRSAPublicKeyFile) throws SQLException {
        this.getCurrentConnection().setServerRSAPublicKeyFile(serverRSAPublicKeyFile);
    }

    @Override
    public boolean getAllowPublicKeyRetrieval() {
        return this.getCurrentConnection().getAllowPublicKeyRetrieval();
    }

    @Override
    public void setAllowPublicKeyRetrieval(boolean allowPublicKeyRetrieval) throws SQLException {
        this.getCurrentConnection().setAllowPublicKeyRetrieval(allowPublicKeyRetrieval);
    }
}

