/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.api.client.mt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.netxms.api.client.mt.MappingTableEntry;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCommon;

public class MappingTable {
    public static final int NUMERIC_KEYS = 1;
    protected int id;
    protected UUID guid;
    protected String name;
    protected String description;
    protected int flags;
    protected List<MappingTableEntry> data;
    protected Map<String, String> hashMap = null;

    public MappingTable(String name, String description) {
        this.id = 0;
        this.name = name;
        this.description = description;
        this.flags = 0;
        this.guid = NXCommon.EMPTY_GUID;
        this.data = new ArrayList<MappingTableEntry>(0);
    }

    public MappingTable(NXCPMessage msg) {
        this.id = msg.getFieldAsInt32(434L);
        this.name = msg.getFieldAsString(20L);
        this.description = msg.getFieldAsString(27L);
        this.flags = msg.getFieldAsInt32(13L);
        this.guid = msg.getFieldAsUUID(222L);
        int count = msg.getFieldAsInt32(361L);
        this.data = new ArrayList<MappingTableEntry>(count);
        long varId = 0x10000000L;
        for (int i = 0; i < count; ++i) {
            this.data.add(new MappingTableEntry(msg, varId));
            varId += 10L;
        }
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setFieldInt32(434L, this.id);
        msg.setField(20L, this.name);
        msg.setField(27L, this.description);
        msg.setFieldInt32(13L, this.flags);
        if (this.guid != null) {
            msg.setField(222L, this.guid);
        }
        msg.setFieldInt32(361L, this.data.size());
        long varId = 0x10000000L;
        for (MappingTableEntry e : this.data) {
            msg.setField(varId++, e.getKey());
            msg.setField(varId++, e.getValue());
            msg.setField(varId++, e.getDescription());
            varId += 7L;
        }
    }

    public String lookup(String key) {
        if (this.hashMap == null) {
            this.buildHash();
        }
        return this.hashMap.get(key);
    }

    public void buildHash() {
        this.hashMap = new HashMap<String, String>(this.data.size());
        for (MappingTableEntry e : this.data) {
            this.hashMap.put(e.getKey(), e.getValue());
        }
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final void setFlags(int flags) {
        this.flags = flags;
    }

    public final int getId() {
        return this.id;
    }

    public final List<MappingTableEntry> getData() {
        return this.data;
    }

    public UUID getGuid() {
        return this.guid;
    }
}

