/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.NetworkMap;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.objectbrowser.dialogs.CreateObjectDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class CloneNetworkMap
implements IObjectActionDelegate {
    private IWorkbenchWindow window;
    private IWorkbenchPart part;
    private NetworkMap source = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
        this.window = targetPart.getSite().getWorkbenchWindow();
    }

    public void run(IAction action) {
        if (this.source == null) {
            return;
        }
        final CreateObjectDialog dlg = new CreateObjectDialog(this.window.getShell(), "Network map");
        if (dlg.open() != 0) {
            return;
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.CreateNetworkMap_JobName, this.part, "org.netxms.ui.eclipse.networkmaps", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NXCObjectCreationData cd = new NXCObjectCreationData(21, dlg.getObjectName(), CloneNetworkMap.this.source.getParentIdList()[0]);
                NXCObjectModificationData md = new NXCObjectModificationData(0L);
                CloneNetworkMap.this.source.prepareCopy(cd, md);
                long id = session.createObject(cd);
                md.setObjectId(id);
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.CreateNetworkMap_JobError, dlg.getObjectName());
            }
        }.start();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object object;
        this.source = selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 ? ((object = ((IStructuredSelection)selection).getFirstElement()) instanceof NetworkMap ? (NetworkMap)object : null) : null;
        action.setEnabled(this.source != null);
    }
}

