/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.dialogs;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.filemanager.widgets.LocalFileSelector;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class ImportDashboardDialog
extends Dialog {
    private String objectName;
    private File importFile;
    private LabeledText textName;
    private LocalFileSelector importFileSelector;

    public ImportDashboardDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.ImportDashboardDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.textName = new LabeledText(dialogArea, 0);
        Messages.get();
        this.textName.setLabel(Messages.ImportDashboardDialog_ObjectName);
        this.textName.getTextControl().setTextLimit(63);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        this.textName.setLayoutData((Object)gd);
        this.importFileSelector = new LocalFileSelector(dialogArea, 0, false, 4096);
        Messages.get();
        this.importFileSelector.setLabel(Messages.ImportDashboardDialog_ImportFile);
        this.importFileSelector.setFilterExtensions(new String[]{"*.xml", "*.*"});
        String[] stringArray = new String[2];
        Messages.get();
        stringArray[0] = Messages.ImportDashboardDialog_XMLFiles;
        Messages.get();
        stringArray[1] = Messages.ImportDashboardDialog_AllFiles;
        this.importFileSelector.setFilterNames(stringArray);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        this.importFileSelector.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.objectName = this.textName.getText().trim();
        if (this.objectName.isEmpty()) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.ImportDashboardDialog_Warning, (String)Messages.ImportDashboardDialog_WarningValidName);
            return;
        }
        this.importFile = this.importFileSelector.getFile();
        if (this.importFile == null) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.ImportDashboardDialog_Warning, (String)Messages.ImportDashboardDialog_WarningSelectFile);
            return;
        }
        super.okPressed();
    }

    public String getObjectName() {
        return this.objectName;
    }

    public File getImportFile() {
        return this.importFile;
    }
}

